/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival;

import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.gecko.DragonEntity;
import by.jackraidenph.dragonsurvival.handlers.ClientEvents;
import by.jackraidenph.dragonsurvival.handlers.EntityTypesInit;
import by.jackraidenph.dragonsurvival.handlers.FlightController;
import by.jackraidenph.dragonsurvival.network.PacketSyncCapabilityMovement;
import by.jackraidenph.dragonsurvival.network.SyncLevel;
import by.jackraidenph.dragonsurvival.network.SynchronizeDragonCap;
import java.io.Serializable;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketProxy {
    public DistExecutor.SafeRunnable handleCapabilityMovement(PacketSyncCapabilityMovement syncCapabilityMovement, Supplier<NetworkEvent.Context> supplier) {
        return (DistExecutor.SafeRunnable & Serializable)() -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            context.enqueueWork(() -> this.handleMovement(syncCapabilityMovement, context));
        };
    }

    private void handleMovement(PacketSyncCapabilityMovement syncCapabilityMovement, NetworkEvent.Context context) {
        ClientPlayerEntity thisPlayer = Minecraft.func_71410_x().field_71439_g;
        if (thisPlayer != null) {
            World world = thisPlayer.field_70170_p;
            Entity entity = world.func_73045_a(syncCapabilityMovement.playerId);
            if (entity instanceof PlayerEntity && entity != thisPlayer) {
                DragonStateProvider.getCap(entity).ifPresent(dragonStateHandler -> dragonStateHandler.setMovementData(syncCapabilityMovement.bodyYaw, syncCapabilityMovement.headYaw, syncCapabilityMovement.headPitch));
            }
            context.setPacketHandled(true);
        }
    }

    public DistExecutor.SafeRunnable updateLevel(SyncLevel syncLevel, Supplier<NetworkEvent.Context> contextSupplier) {
        return (DistExecutor.SafeRunnable & Serializable)() -> {
            Minecraft minecraft = Minecraft.func_71410_x();
            Entity entity = minecraft.field_71441_e.func_73045_a(syncLevel.playerId);
            if (entity instanceof PlayerEntity) {
                DragonStateProvider.getCap(entity).ifPresent(dragonStateHandler -> dragonStateHandler.setLevel(syncLevel.level));
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        };
    }

    public DistExecutor.SafeRunnable refreshInstances(SynchronizeDragonCap synchronizeDragonCap, Supplier<NetworkEvent.Context> context) {
        return (DistExecutor.SafeRunnable & Serializable)() -> {
            ClientPlayerEntity myPlayer = Minecraft.func_71410_x().field_71439_g;
            if (myPlayer != null) {
                PlayerEntity thatPlayer;
                World world = myPlayer.field_70170_p;
                if (ClientEvents.dummyDragon2 != null && !ClientEvents.isRenderingFirstPerson) {
                    ClientEvents.dummyDragon2.player = myPlayer.func_145782_y();
                }
                if ((thatPlayer = (PlayerEntity)world.func_73045_a(synchronizeDragonCap.playerId)) != null) {
                    DragonStateProvider.getCap((Entity)thatPlayer).ifPresent(dragonStateHandler -> {
                        dragonStateHandler.setIsDragon(synchronizeDragonCap.isDragon);
                        dragonStateHandler.setLevel(synchronizeDragonCap.dragonLevel);
                        dragonStateHandler.setType(synchronizeDragonCap.dragonType);
                        dragonStateHandler.setIsHiding(synchronizeDragonCap.hiding);
                        dragonStateHandler.setHasWings(synchronizeDragonCap.hasWings);
                        if (!dragonStateHandler.hasWings()) {
                            FlightController.wingsEnabled = false;
                        }
                    });
                    if (thatPlayer != myPlayer && !ClientEvents.isRenderingThirdPerson) {
                        DragonEntity dragonEntity = (DragonEntity)EntityTypesInit.dragonEntity.func_200721_a(world);
                        dragonEntity.player = thatPlayer.func_145782_y();
                        ClientEvents.playerDragonHashMap.put(thatPlayer.func_145782_y(), dragonEntity);
                    }
                }
                ((NetworkEvent.Context)context.get()).setPacketHandled(true);
            }
        };
    }
}

