/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.capability;

import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;

public class CapabilityStorage
implements Capability.IStorage<DragonStateHandler> {
    private static CompoundNBT writeVec3d(Vec3d vec) {
        CompoundNBT comp = new CompoundNBT();
        comp.func_74780_a("X", vec.field_72450_a);
        comp.func_74780_a("Y", vec.field_72448_b);
        comp.func_74780_a("Z", vec.field_72449_c);
        return comp;
    }

    private static Vec3d getVec3d(INBT nbt) {
        CompoundNBT tag = (CompoundNBT)nbt;
        Vec3d vec = Vec3d.field_186680_a;
        if (tag != null && tag.func_74764_b("X")) {
            vec = new Vec3d(tag.func_74769_h("X"), tag.func_74769_h("Y"), tag.func_74769_h("Z"));
        }
        return vec;
    }

    public INBT writeNBT(Capability<DragonStateHandler> capability, DragonStateHandler instance, Direction side) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("isDragon", instance.isDragon());
        if (instance.isDragon()) {
            DragonStateHandler.DragonMovementData movementData = instance.getMovementData();
            tag.func_74780_a("bodyYaw", movementData.bodyYaw);
            tag.func_74780_a("headYaw", movementData.headYaw);
            tag.func_74780_a("headPitch", movementData.headPitch);
            tag.func_74757_a("isHiding", instance.isHiding());
            tag.func_74778_a("type", instance.getType().toString());
            tag.func_74778_a("level", instance.getLevel().toString());
            tag.func_74776_a("Health", instance.getHealth());
            tag.func_74757_a("Has wings", instance.hasWings());
        }
        return tag;
    }

    public void readNBT(Capability<DragonStateHandler> capability, DragonStateHandler instance, Direction side, INBT base) {
        CompoundNBT tag = (CompoundNBT)base;
        instance.setIsDragon(tag.func_74767_n("isDragon"));
        if (tag.func_74767_n("isDragon")) {
            instance.setMovementData(tag.func_74769_h("bodyYaw"), tag.func_74769_h("headYaw"), tag.func_74769_h("headPitch"));
            instance.setIsHiding(tag.func_74767_n("isHiding"));
            instance.setType(DragonType.valueOf(tag.func_74779_i("type")));
            String level = tag.func_74779_i("level");
            if (level.isEmpty()) {
                instance.setLevel(DragonLevel.BABY);
            } else {
                instance.setLevel(DragonLevel.valueOf(level));
            }
            instance.setHealth(tag.func_74760_g("Health"));
            instance.setHasWings(tag.func_74767_n("Has wings"));
        }
    }
}

