/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.capability;

import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec3d;

public class DragonStateHandler {
    private boolean isDragon;
    private boolean isHiding;
    private DragonType type = DragonType.NONE;
    private DragonLevel level = DragonLevel.BABY;
    private float health;
    private final DragonMovementData data;
    private boolean hasWings;

    public DragonStateHandler() {
        this.health = this.level.initialHealth;
        this.data = new DragonMovementData(0.0, 0.0, 0.0);
    }

    public boolean hasWings() {
        return this.hasWings;
    }

    public void setHasWings(boolean hasWings) {
        this.hasWings = hasWings;
    }

    public boolean isDragon() {
        return this.isDragon;
    }

    public void setIsDragon(boolean isDragon) {
        this.isDragon = isDragon;
    }

    public boolean isHiding() {
        return this.isHiding;
    }

    public void setIsHiding(boolean hiding) {
        this.isHiding = hiding;
    }

    public DragonLevel getLevel() {
        return this.level;
    }

    public void setLevel(DragonLevel level) {
        this.level = level;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    public float getHealth() {
        return this.health;
    }

    public void setLevel(DragonLevel level, PlayerEntity playerEntity) {
        this.setLevel(level);
        playerEntity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)level.initialHealth);
        playerEntity.func_70691_i(playerEntity.func_110138_aP());
        this.setHealth(level.initialHealth);
    }

    public void setLevelAndHealth(DragonLevel level, float health, PlayerEntity playerEntity) {
        this.setLevel(level);
        playerEntity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)health);
        playerEntity.func_70691_i(playerEntity.func_110138_aP());
        this.setHealth(health);
    }

    public void setMovementData(double bodyYaw, double headYaw, double headPitch) {
        this.data.bodyYaw = bodyYaw;
        this.data.headYaw = headYaw;
        this.data.headPitch = headPitch;
    }

    public DragonMovementData getMovementData() {
        return this.data;
    }

    public DragonType getType() {
        return this.type;
    }

    public void setType(DragonType type) {
        this.type = type;
    }

    public static class DragonMovementData {
        public double bodyYaw;
        public double headYaw;
        public double headPitch;
        public Vec3d headPosLastTick;
        public Vec3d tailPosLastTick;
        public double headYawLastTick;
        public double headPitchLastTick;
        public double bodyYawLastTick;

        public DragonMovementData(double bodyYaw, double headYaw, double headPitch) {
            this.bodyYaw = bodyYaw;
            this.headYaw = headYaw;
            this.headPitch = headPitch;
            this.headYawLastTick = headYaw;
            this.headPitchLastTick = headPitch;
            this.bodyYawLastTick = bodyYaw;
        }

        void setMovementData(double bodyYaw, double headYaw, double headPitch) {
            this.setMovementLastTick(this.bodyYaw, this.headYaw, this.headPitch);
            this.bodyYaw = bodyYaw;
            this.headYaw = headYaw;
            this.headPitch = headPitch;
        }

        void setMovementLastTick(double bodyYawLastTick, double headYawLastTick, double headPitchLastTick) {
            this.bodyYawLastTick = bodyYawLastTick;
            this.headYawLastTick = headYawLastTick;
            this.headPitchLastTick = headPitchLastTick;
        }
    }
}

