/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.entity;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.handlers.BlockInit;
import by.jackraidenph.dragonsurvival.network.PacketSyncXPDevour;
import by.jackraidenph.dragonsurvival.util.ConfigurationHandler;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class MagicalPredatorEntity
extends MonsterEntity {
    public int field_200606_g;
    public float field_213325_aI;
    private final float scale;

    public MagicalPredatorEntity(EntityType<? extends MonsterEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
        this.field_200606_g = worldIn.func_201674_k().nextInt(10);
        this.field_213325_aI = worldIn.func_201674_k().nextFloat() + 0.95f;
        this.scale = this.field_213325_aI / this.func_213302_cg();
    }

    private static int getActualDistance(PlayerEntity player) {
        AtomicInteger distance = new AtomicInteger();
        if (player != null) {
            DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
                if (cap.isDragon() && !cap.isHiding()) {
                    distance.set(30);
                } else if (cap.isDragon()) {
                    distance.set(18);
                } else {
                    distance.set(10);
                }
            });
        }
        return distance.get();
    }

    protected boolean func_225511_J_() {
        return true;
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 19) {
            this.field_70170_p.func_175656_a(this.func_180425_c(), BlockInit.PREDATOR_STAR_BLOCK.func_176223_P());
            this.func_70656_aK();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (double)this.field_70170_p.func_201674_k().nextFloat() * 1.25 - 0.75, this.func_226278_cu_() + (double)(this.func_213302_cg() / 1.5f * this.scale), this.func_226281_cx_() + (double)this.field_70170_p.func_201674_k().nextFloat() * 1.25 - 0.75, 0.0, (double)(this.field_70170_p.func_201674_k().nextFloat() / 12.5f), 0.0);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187864_fh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (worldIn.func_201674_k().nextInt(10) == 0) {
            SkeletonEntity skeletonentity = (SkeletonEntity)EntityType.field_200741_ag.func_200721_a(this.field_70170_p);
            skeletonentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
            skeletonentity.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
            worldIn.func_217376_c((Entity)skeletonentity);
            skeletonentity.func_184220_m((Entity)this);
        }
        return spawnDataIn;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new DevourXP(this.field_70170_p, this));
        this.field_70715_bh.func_75776_a(1, (Goal)new FindPlayerGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new IsNearestDragonTargetGoal((MobEntity)this, true));
    }

    public double func_70042_X() {
        return (double)(this.func_213302_cg() * this.scale) * 0.75;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.475);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0 * (Double)ConfigurationHandler.predatorDamageFactor.get());
        this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(29.5 * (Double)ConfigurationHandler.predatorHealthFactor.get());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("healthBoost", (double)this.scale, AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("damageBoost", (double)this.scale, AttributeModifier.Operation.MULTIPLY_BASE));
        this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111121_a(new AttributeModifier("attackBoost", (double)this.scale, AttributeModifier.Operation.MULTIPLY_BASE));
    }

    private void teleportToEntity(Entity p_70816_1_) {
        Vec3d vec = p_70816_1_.func_213303_ch().func_178788_d(p_70816_1_.func_70040_Z().func_216372_d(3.0, 1.0, 3.0));
        double d1 = vec.func_82615_a();
        double d2 = 256.0;
        double d3 = vec.func_82616_c();
        this.teleportTo(d1, d2, d3);
    }

    private void teleportTo(double x, double y, double z) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a(FluidTags.field_206959_a);
        this.func_213373_a(x, y, z, true);
        if (flag && !flag1) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
    }

    public boolean func_213373_a(double p_213373_1_, double p_213373_3_, double p_213373_5_, boolean p_213373_7_) {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        double d3 = p_213373_3_;
        boolean flag = false;
        World world = this.field_70170_p;
        BlockPos blockpos = new BlockPos(p_213373_1_, p_213373_3_, p_213373_5_);
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                BlockState blockstate = world.func_180495_p(blockpos1);
                if (blockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                d3 -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(p_213373_1_, d3, p_213373_5_);
                if (world.func_226669_j_((Entity)this) && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        if (p_213373_7_) {
            world.func_72960_a((Entity)this, (byte)46);
        }
        this.func_70661_as().func_75499_g();
        return true;
    }

    static class FindPlayerGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        private final MagicalPredatorEntity beast;

        public FindPlayerGoal(MagicalPredatorEntity beastIn) {
            super((MobEntity)beastIn, PlayerEntity.class, false);
            this.beast = beastIn;
        }

        protected AxisAlignedBB func_188511_a(double p_188511_1_) {
            PlayerEntity player = (PlayerEntity)this.field_75309_a;
            return this.field_75299_d.func_174813_aQ().func_186662_g((double)MagicalPredatorEntity.getActualDistance(player));
        }

        public void func_75246_d() {
            float diff;
            if (this.field_75309_a != null && this.field_75309_a instanceof PlayerEntity && (diff = (float)MagicalPredatorEntity.getActualDistance((PlayerEntity)this.field_75309_a) - this.beast.func_70032_d((Entity)this.field_75309_a)) <= 16.0f & diff >= -2.0f) {
                this.beast.teleportToEntity((Entity)this.field_75309_a);
            }
        }
    }

    static class IsNearestDragonTargetGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        public IsNearestDragonTargetGoal(MobEntity p_i50313_1_, boolean p_i50313_3_) {
            super(p_i50313_1_, PlayerEntity.class, p_i50313_3_);
        }

        protected AxisAlignedBB func_188511_a(double p_188511_1_) {
            PlayerEntity player = (PlayerEntity)this.field_75309_a;
            return this.field_75299_d.func_174813_aQ().func_186662_g((double)MagicalPredatorEntity.getActualDistance(player));
        }
    }

    static class DevourXP
    extends Goal {
        World world;
        MagicalPredatorEntity entity;

        public DevourXP(World worldIn, MagicalPredatorEntity entityIn) {
            this.world = worldIn;
            this.entity = entityIn;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            this.world.func_217394_a(EntityType.field_200807_u, this.entity.func_174813_aQ().func_186662_g(4.0), Objects::nonNull).forEach(xpOrb -> DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new PacketSyncXPDevour(this.entity.func_145782_y(), xpOrb.func_145782_y())));
            super.func_75246_d();
        }
    }
}

