/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.gecko;

import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.handlers.ClientEvents;
import java.util.Collections;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DragonEntity
extends LivingEntity
implements IAnimatable {
    AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);
    public volatile int player;

    public DragonEntity(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> animationEvent) {
        PlayerEntity player = this.getPlayer();
        if (player != null) {
            Vec3d motio = player.func_213322_ci();
            AnimationController animationController = animationEvent.getController();
            if (player.func_213283_Z() == Pose.SWIMMING) {
                animationController.setAnimation(new AnimationBuilder().addAnimation("animation.dragon.swim_fast", Boolean.valueOf(true)));
            } else if (player.func_203005_aq() && (motio.field_72450_a != 0.0 || motio.field_72449_c != 0.0)) {
                animationController.setAnimation(new AnimationBuilder().addAnimation("animation.dragon.swim", Boolean.valueOf(true)));
            } else if ((player.field_71075_bZ.field_75100_b || ClientEvents.dragonsFlying.getOrDefault(player.func_145782_y(), false).booleanValue()) && !player.field_70122_E && !player.func_70090_H() && ((DragonStateHandler)player.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElse(null)).hasWings()) {
                animationController.setAnimation(new AnimationBuilder().addAnimation("animation.dragon.fly_slow", Boolean.valueOf(true)));
            } else if (player.func_70051_ag()) {
                animationController.setAnimation(new AnimationBuilder().addAnimation("animation.dragon.run", Boolean.valueOf(true)));
            } else if (player.func_225608_bj_()) {
                if ((motio.func_82615_a() != 0.0 || motio.func_82616_c() != 0.0) && player.field_70721_aZ != 0.0f) {
                    animationController.setAnimation(new AnimationBuilder().addAnimation("animation.dragon.stand5", Boolean.valueOf(true)));
                } else if (ClientEvents.dragonsDigging.getOrDefault(this.player, false).booleanValue()) {
                    animationController.setAnimation(new AnimationBuilder().addAnimation("animation.dragon.stand8", Boolean.valueOf(true)));
                } else {
                    animationController.setAnimation(new AnimationBuilder().addAnimation("animation.dragon.stand6", Boolean.valueOf(true)));
                }
            } else if (player.field_82175_bq && player.func_184825_o(-3.0f) != 1.0f) {
                animationController.setAnimation(new AnimationBuilder().addAnimation("animation.model.new"));
            } else if (ClientEvents.dragonsJumpingTicks.getOrDefault(this.player, 0) > 0) {
                animationController.setAnimation(new AnimationBuilder().addAnimation("animation.model.new2", Boolean.valueOf(true)));
            } else if ((motio.func_82615_a() != 0.0 || motio.func_82616_c() != 0.0) && player.field_70721_aZ != 0.0f) {
                animationController.setAnimation(new AnimationBuilder().addAnimation("animation.dragon.stand3", Boolean.valueOf(true)));
            } else if (player.func_70608_bn()) {
                animationController.setAnimation(new AnimationBuilder().addAnimation("animation.dragon.sleep", Boolean.valueOf(true)));
            } else if (ClientEvents.dragonsDigging.getOrDefault(this.player, false).booleanValue()) {
                animationController.setAnimation(new AnimationBuilder().addAnimation("animation.dragon.stand7", Boolean.valueOf(true)));
            } else {
                animationController.setAnimation(new AnimationBuilder().addAnimation("animation.dragon.stand3", Boolean.valueOf(true)));
            }
        }
        return PlayState.CONTINUE;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    PlayerEntity getPlayer() {
        return (PlayerEntity)this.field_70170_p.func_73045_a(this.player);
    }
}

