/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.gecko;

import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.gecko.DragonEntity;
import by.jackraidenph.dragonsurvival.handlers.ClientEvents;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import software.bernie.geckolib3.model.AnimatedGeoModel;

public class DragonModel
extends AnimatedGeoModel<DragonEntity> {
    private ResourceLocation currentTexture = new ResourceLocation("dragonsurvival", "textures/dragon/cave_newborn.png");

    public ResourceLocation getModelLocation(DragonEntity dragonEntity) {
        return new ResourceLocation("dragonsurvival", "geo/dragon_model.geo.json");
    }

    public void setCurrentTexture(ResourceLocation currentTexture) {
        this.currentTexture = currentTexture;
    }

    public ResourceLocation getTextureLocation(DragonEntity dragonEntity) {
        return this.currentTexture;
    }

    public ResourceLocation getAnimationFileLocation(DragonEntity dragonEntity) {
        PlayerEntity player = dragonEntity.getPlayer();
        if (player != null) {
            Vec3d playerMotion = player.func_213322_ci();
            if (player.func_213283_Z() == Pose.SWIMMING) {
                return new ResourceLocation("dragonsurvival", "animations/dragon.swim_fast.animation.json");
            }
            if (player.func_203005_aq() && (playerMotion.field_72450_a != 0.0 || playerMotion.field_72449_c != 0.0)) {
                return new ResourceLocation("dragonsurvival", "animations/dragon.swim.animation.json");
            }
            if (player.func_225608_bj_()) {
                if ((playerMotion.func_82616_c() != 0.0 || playerMotion.func_82615_a() != 0.0) && player.field_70721_aZ != 0.0f) {
                    return new ResourceLocation("dragonsurvival", "animations/dragon.sneaking.animation.json");
                }
                if (ClientEvents.dragonsDigging.getOrDefault(dragonEntity.player, false).booleanValue()) {
                    return new ResourceLocation("dragonsurvival", "animations/dragon.digging_sneaking.animation.json");
                }
                return new ResourceLocation("dragonsurvival", "animations/dragon.sneaking_stand.animation.json");
            }
            boolean flyingEnabled = ClientEvents.dragonsFlying.getOrDefault(player.func_145782_y(), false);
            if ((flyingEnabled || player.field_71075_bZ.field_75100_b) && !player.func_70090_H() && !player.field_70122_E && ((DragonStateHandler)player.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElse(null)).hasWings()) {
                return new ResourceLocation("dragonsurvival", "animations/dragon.fly.animation.json");
            }
            if (player.func_70051_ag()) {
                return new ResourceLocation("dragonsurvival", "animations/dragon.run.animation.json");
            }
            if (player.field_82175_bq && player.func_184825_o(-3.0f) != 1.0f) {
                return new ResourceLocation("dragonsurvival", "animations/dragon.bite.animation.json");
            }
            if (ClientEvents.dragonsJumpingTicks.getOrDefault(dragonEntity.player, 0) > 0) {
                return new ResourceLocation("dragonsurvival", "animations/dragon.jump.animation.json");
            }
            if ((playerMotion.field_72449_c != 0.0 || playerMotion.field_72450_a != 0.0) && player.field_70721_aZ != 0.0f) {
                return new ResourceLocation("dragonsurvival", "animations/dragon.walk.animation.json");
            }
            if (player.func_70608_bn()) {
                return new ResourceLocation("dragonsurvival", "animations/dragon.sleep.animation.json");
            }
            if (ClientEvents.dragonsDigging.getOrDefault(dragonEntity.player, false).booleanValue()) {
                return new ResourceLocation("dragonsurvival", "animations/dragon.digging.animation.json");
            }
        }
        return new ResourceLocation("dragonsurvival", "animations/dragon.stand.animation.json");
    }
}

