/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.gui;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.network.GiveNest;
import by.jackraidenph.dragonsurvival.network.PacketSyncCapabilityMovement;
import by.jackraidenph.dragonsurvival.network.ResetPlayer;
import by.jackraidenph.dragonsurvival.network.SynchronizeDragonCap;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class DragonAltarGUI
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("dragonsurvival", "textures/gui/dragon_altar_texture.png");
    private final int xSize = 426;
    private final int ySize = 250;
    private int guiLeft;
    private int guiTop;
    private HashMap<Integer, Integer> wtf = Maps.newHashMap();

    public DragonAltarGUI(ITextComponent title) {
        super(title);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft == null) {
            return;
        }
        this.renderBackground();
        int startX = this.guiLeft;
        int startY = this.guiTop;
        super.render(mouseX, mouseY, partialTicks);
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        DragonAltarGUI.blit((int)startX, (int)startY, (float)0.0f, (float)0.0f, (int)215, (int)158, (int)512, (int)512);
        if (mouseY > startY + 6 && mouseY < startY + 153) {
            if (mouseX > startX + 5 && mouseX < startX + 55) {
                DragonAltarGUI.blit((int)(startX + 6), (int)(startY + 6), (float)217.0f, (float)0.0f, (int)49, (int)149, (int)512, (int)512);
            }
            if (mouseX > startX + 57 && mouseX < startX + 107) {
                DragonAltarGUI.blit((int)(startX + 58), (int)(startY + 6), (float)266.0f, (float)0.0f, (int)49, (int)149, (int)512, (int)512);
            }
            if (mouseX > startX + 109 && mouseX < startX + 159) {
                DragonAltarGUI.blit((int)(startX + 110), (int)(startY + 6), (float)315.0f, (float)0.0f, (int)49, (int)149, (int)512, (int)512);
            }
            if (mouseX > startX + 161 && mouseX < startX + 211) {
                DragonAltarGUI.blit((int)(startX + 161), (int)(startY + 6), (float)364.0f, (float)0.0f, (int)49, (int)149, (int)512, (int)512);
            }
        }
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - this.xSize / 2) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.addButton((Widget)new ExtendedButton(this.guiLeft + 6, this.guiTop + 6, 49, 147, "CAVE", button -> {
            this.initiateDragonForm(DragonType.CAVE);
            this.minecraft.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("ds.cave_dragon_choice", new Object[0]));
        }));
        this.addButton((Widget)new ExtendedButton(this.guiLeft + 58, this.guiTop + 6, 49, 147, "FOREST", button -> {
            this.initiateDragonForm(DragonType.FOREST);
            this.minecraft.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("ds.forest_dragon_choice", new Object[0]));
        }));
        this.addButton((Widget)new ExtendedButton(this.guiLeft + 110, this.guiTop + 6, 49, 147, "SEA", button -> {
            this.initiateDragonForm(DragonType.SEA);
            this.minecraft.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("ds.sea_dragon_choice", new Object[0]));
        }));
        this.addButton((Widget)new ExtendedButton(this.guiLeft + 162, this.guiTop + 6, 49, 147, "Human", b -> DragonStateProvider.getCap((Entity)this.minecraft.field_71439_g).ifPresent(playerStateHandler -> {
            playerStateHandler.setIsDragon(false);
            playerStateHandler.setIsHiding(false);
            playerStateHandler.setLevel(DragonLevel.BABY);
            playerStateHandler.setType(DragonType.NONE);
            playerStateHandler.setHasWings(false);
            DragonSurvivalMod.CHANNEL.sendToServer((Object)new SynchronizeDragonCap(this.minecraft.field_71439_g.func_145782_y(), false, DragonType.NONE, DragonLevel.BABY, false, 20.0f, false));
            DragonSurvivalMod.CHANNEL.sendToServer((Object)new ResetPlayer());
            this.minecraft.field_71439_g.func_71053_j();
            this.minecraft.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("ds.choice_human", new Object[0]));
        })));
    }

    private void initiateDragonForm(DragonType type) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        player.func_71053_j();
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            DragonSurvivalMod.CHANNEL.sendToServer((Object)new SynchronizeDragonCap(player.func_145782_y(), false, type, DragonLevel.BABY, true, DragonLevel.BABY.initialHealth, false));
            DragonSurvivalMod.CHANNEL.sendToServer((Object)new GiveNest(type));
            player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, 0.7f);
            DragonSurvivalMod.CHANNEL.sendToServer((Object)new PacketSyncCapabilityMovement(player.func_145782_y(), 0.0, 0.0, 0.0));
            cap.setIsDragon(true);
            cap.setType(type);
            cap.setLevel(DragonLevel.BABY);
            cap.setHasWings(false);
            player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)DragonLevel.BABY.initialHealth);
        });
    }
}

