/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.handlers;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.gecko.DragonEntity;
import by.jackraidenph.dragonsurvival.gecko.DragonModel;
import by.jackraidenph.dragonsurvival.handlers.ClientModEvents;
import by.jackraidenph.dragonsurvival.handlers.EntityTypesInit;
import by.jackraidenph.dragonsurvival.network.OpenDragonInventory;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib3.core.processor.IBone;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    public static float bodyYaw;
    public static DragonModel dragonModel;
    static boolean showingInventory;
    static HashMap<UUID, Boolean> warnings;
    static HashMap<String, Boolean> warningsForName;
    static HashMultimap<String, ResourceLocation> skinCache;
    static HashMultimap<String, ResourceLocation> skinCacheForName;
    public static DragonEntity dummyDragon2;
    public static ConcurrentHashMap<Integer, DragonEntity> playerDragonHashMap;
    public static ConcurrentHashMap<Integer, Boolean> dragonsFlying;
    public static ConcurrentHashMap<Integer, Boolean> dragonsDigging;
    public static ConcurrentHashMap<Integer, Integer> dragonsJumpingTicks;
    public static boolean isRenderingFirstPerson;
    public static boolean isRenderingThirdPerson;
    static ResourceLocation HUDTextures;

    @SubscribeEvent
    public static void decreaseJumpDuration(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase == TickEvent.Phase.END) {
            PlayerEntity playerEntity = playerTickEvent.player;
            dragonsJumpingTicks.computeIfPresent(playerEntity.func_145782_y(), (playerEntity1, integer) -> integer > 0 ? integer - 1 : integer);
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent renderHandEvent) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (dummyDragon2 == null) {
            dummyDragon2 = (DragonEntity)EntityTypesInit.dragonEntity.func_200721_a(player.field_70170_p);
            ClientEvents.dummyDragon2.player = player.func_145782_y();
        }
        isRenderingFirstPerson = true;
        DragonStateProvider.getCap((Entity)player).ifPresent(playerStateHandler -> {
            if (playerStateHandler.isDragon()) {
                if (renderHandEvent.getItemStack().func_190926_b()) {
                    renderHandEvent.setCanceled(true);
                }
                MatrixStack eventMatrixStack = renderHandEvent.getMatrixStack();
                try {
                    eventMatrixStack.func_227860_a_();
                    float partialTicks = renderHandEvent.getPartialTicks();
                    float playerYaw = player.func_195046_g(partialTicks);
                    float playerPitch = player.func_195050_f(partialTicks);
                    ResourceLocation texture = ClientEvents.getSkin((PlayerEntity)player, playerStateHandler, playerStateHandler.getLevel());
                    eventMatrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(player.field_70125_A));
                    eventMatrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    eventMatrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(player.field_70177_z));
                    eventMatrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-bodyYaw));
                    eventMatrixStack.func_227861_a_(0.0, -2.0, -1.0);
                    IRenderTypeBuffer buffers = renderHandEvent.getBuffers();
                    int light = renderHandEvent.getLight();
                    EntityRenderer dragonRenderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)dummyDragon2);
                    dummyDragon2.func_82149_j((Entity)player);
                    dragonModel.setCurrentTexture(texture);
                    IBone neckandHead = dragonModel.getAnimationProcessor().getBone("NeckandHead");
                    if (neckandHead != null) {
                        neckandHead.setHidden(true);
                    }
                    IBone leftwing = dragonModel.getAnimationProcessor().getBone("Leftwing");
                    IBone rightWing = dragonModel.getAnimationProcessor().getBone("Leftwing2");
                    if (leftwing != null) {
                        leftwing.setHidden(!playerStateHandler.hasWings());
                    }
                    if (rightWing != null) {
                        rightWing.setHidden(!playerStateHandler.hasWings());
                    }
                    dragonRenderer.func_225623_a_((Entity)dummyDragon2, playerYaw, partialTicks, eventMatrixStack, buffers, light);
                    eventMatrixStack.func_227862_a_(1.02f, 1.02f, 1.02f);
                    ResourceLocation chestplate = new ResourceLocation("dragonsurvival", ClientEvents.constructArmorTexture((PlayerEntity)player, EquipmentSlotType.CHEST));
                    dragonModel.setCurrentTexture(chestplate);
                    dragonRenderer.func_225623_a_((Entity)dummyDragon2, playerYaw, partialTicks, eventMatrixStack, buffers, light);
                    ResourceLocation legs = new ResourceLocation("dragonsurvival", ClientEvents.constructArmorTexture((PlayerEntity)player, EquipmentSlotType.LEGS));
                    dragonModel.setCurrentTexture(legs);
                    dragonRenderer.func_225623_a_((Entity)dummyDragon2, playerYaw, partialTicks, eventMatrixStack, buffers, light);
                    ResourceLocation boots = new ResourceLocation("dragonsurvival", ClientEvents.constructArmorTexture((PlayerEntity)player, EquipmentSlotType.FEET));
                    dragonModel.setCurrentTexture(boots);
                    dragonRenderer.func_225623_a_((Entity)dummyDragon2, playerYaw, partialTicks, eventMatrixStack, buffers, light);
                    eventMatrixStack.func_227861_a_(0.0, 0.0, 0.15);
                    eventMatrixStack.func_227865_b_();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        isRenderingFirstPerson = false;
    }

    @SubscribeEvent
    public static void onOpenScreen(GuiOpenEvent openEvent) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (openEvent.getGui() instanceof InventoryScreen && !player.func_184812_l_() && DragonStateProvider.isDragon((Entity)player)) {
            openEvent.setCanceled(true);
            showingInventory = false;
        }
    }

    @SubscribeEvent
    public static void onKey(InputEvent.KeyInputEvent keyInputEvent) {
        Minecraft minecraft = Minecraft.func_71410_x();
        GameSettings gameSettings = minecraft.field_71474_y;
        InputMappings.Input input = InputMappings.func_197954_a((int)keyInputEvent.getKey(), (int)keyInputEvent.getScanCode());
        if (minecraft.field_71462_r == null && DragonStateProvider.isDragon((Entity)minecraft.field_71439_g) && !minecraft.field_71439_g.func_184812_l_() && gameSettings.field_151445_Q.isActiveAndMatches(input) && !showingInventory) {
            DragonSurvivalMod.CHANNEL.sendToServer((Object)new OpenDragonInventory());
            showingInventory = true;
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent clientTickEvent) {
        if (clientTickEvent.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientPlayerEntity player = minecraft.field_71439_g;
            if (player != null) {
                float bodyAndHeadYawDiff = bodyYaw - player.field_70759_as;
                if (minecraft.field_71474_y.field_74320_O == 0 && Math.abs(bodyAndHeadYawDiff) > 170.0f) {
                    bodyYaw -= Math.signum(bodyAndHeadYawDiff) * 2.0f;
                }
                if (player.func_213322_ci().field_72450_a != 0.0 || player.func_213322_ci().field_72449_c != 0.0) {
                    DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> dragonStateHandler.setMovementData(player.func_195046_g(1.0f), player.field_70759_as, player.field_70125_A));
                    bodyYaw = player.field_70759_as;
                }
            }
        }
    }

    @SubscribeEvent
    public static void thirdPersonPreRender(RenderPlayerEvent.Pre renderPlayerEvent) {
        PlayerEntity player = renderPlayerEvent.getPlayer();
        if (!playerDragonHashMap.containsKey(player.func_145782_y())) {
            DragonEntity dummyDragon = (DragonEntity)EntityTypesInit.dragonEntity.func_200721_a(player.field_70170_p);
            dummyDragon.player = player.func_145782_y();
            playerDragonHashMap.put(player.func_145782_y(), dummyDragon);
        }
        isRenderingThirdPerson = true;
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            if (cap.isDragon()) {
                renderPlayerEvent.setCanceled(true);
                float partialRenderTick = renderPlayerEvent.getPartialRenderTick();
                float limbSwingAmount = MathHelper.func_219799_g((float)partialRenderTick, (float)player.field_184618_aE, (float)player.field_70721_aZ);
                float yaw = player.func_195046_g(partialRenderTick);
                float pitch = player.func_195050_f(partialRenderTick);
                DragonLevel dragonStage = cap.getLevel();
                ResourceLocation texture = ClientEvents.getSkin(player, cap, dragonStage);
                MatrixStack matrixStack = renderPlayerEvent.getMatrixStack();
                try {
                    IBone neckHead;
                    matrixStack.func_227860_a_();
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(-cap.getMovementData().bodyYaw)));
                    float maxHealth = player.func_110138_aP();
                    float scale = Math.max(maxHealth / 40.0f, DragonLevel.BABY.maxWidth);
                    matrixStack.func_227862_a_(scale, scale, scale);
                    int eventLight = renderPlayerEvent.getLight();
                    DragonEntity dummyDragon = playerDragonHashMap.get(player.func_145782_y());
                    EntityRenderer dragonRenderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)dummyDragon);
                    dummyDragon.func_82149_j((Entity)player);
                    dragonModel.setCurrentTexture(texture);
                    IBone leftwing = dragonModel.getAnimationProcessor().getBone("Leftwing");
                    IBone rightWing = dragonModel.getAnimationProcessor().getBone("Leftwing2");
                    if (leftwing != null) {
                        leftwing.setHidden(!cap.hasWings());
                    }
                    if (rightWing != null) {
                        rightWing.setHidden(!cap.hasWings());
                    }
                    if ((neckHead = dragonModel.getAnimationProcessor().getBone("NeckandHead")) != null) {
                        neckHead.setHidden(false);
                    }
                    IRenderTypeBuffer renderTypeBuffer = renderPlayerEvent.getBuffers();
                    if (player.func_213453_ef()) {
                        switch (dragonStage) {
                            case ADULT: {
                                matrixStack.func_227861_a_(0.0, 0.2, 0.0);
                                break;
                            }
                            case YOUNG: {
                                matrixStack.func_227861_a_(0.0, 0.25, 0.0);
                                break;
                            }
                            case BABY: {
                                matrixStack.func_227861_a_(0.0, 0.3, 0.0);
                            }
                        }
                    }
                    dragonRenderer.func_225623_a_((Entity)dummyDragon, yaw, partialRenderTick, matrixStack, renderTypeBuffer, eventLight);
                    String helmetTexture = ClientEvents.constructArmorTexture(player, EquipmentSlotType.HEAD);
                    String chestPlateTexture = ClientEvents.constructArmorTexture(player, EquipmentSlotType.CHEST);
                    String legsTexture = ClientEvents.constructArmorTexture(player, EquipmentSlotType.LEGS);
                    String bootsTexture = ClientEvents.constructArmorTexture(player, EquipmentSlotType.FEET);
                    matrixStack.func_227862_a_(1.08f, 1.02f, 1.02f);
                    dragonModel.setCurrentTexture(new ResourceLocation("dragonsurvival", helmetTexture));
                    dragonRenderer.func_225623_a_((Entity)dummyDragon, yaw, partialRenderTick, matrixStack, renderTypeBuffer, eventLight);
                    dragonModel.setCurrentTexture(new ResourceLocation("dragonsurvival", chestPlateTexture));
                    dragonRenderer.func_225623_a_((Entity)dummyDragon, yaw, partialRenderTick, matrixStack, renderTypeBuffer, eventLight);
                    dragonModel.setCurrentTexture(new ResourceLocation("dragonsurvival", legsTexture));
                    dragonRenderer.func_225623_a_((Entity)dummyDragon, yaw, partialRenderTick, matrixStack, renderTypeBuffer, eventLight);
                    dragonModel.setCurrentTexture(new ResourceLocation("dragonsurvival", bootsTexture));
                    dragonRenderer.func_225623_a_((Entity)dummyDragon, yaw, partialRenderTick, matrixStack, renderTypeBuffer, eventLight);
                    ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                    ItemStack right = player.func_184614_ca();
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(45.0f));
                    matrixStack.func_227861_a_((double)-0.45f, 1.0, 0.0);
                    int combinedOverlayIn = LivingRenderer.func_229117_c_((LivingEntity)player, (float)0.0f);
                    itemRenderer.func_229110_a_(right, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, eventLight, combinedOverlayIn, matrixStack, renderTypeBuffer);
                    ItemStack left = player.func_184592_cb();
                    matrixStack.func_227861_a_(0.9, 0.0, 0.0);
                    itemRenderer.func_229110_a_(left, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, eventLight, combinedOverlayIn, matrixStack, renderTypeBuffer);
                    matrixStack.func_227865_b_();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        isRenderingThirdPerson = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceLocation getSkin(PlayerEntity player, DragonStateHandler cap, DragonLevel dragonStage) {
        ResourceLocation texture;
        UUID playerUniqueID = player.func_110124_au();
        String playerName = player.func_146103_bH().getName();
        Optional<ResourceLocation> skinForName = skinCacheForName.get((Object)playerName).stream().filter(location -> Boolean.parseBoolean(location.toString().endsWith(playerName.toLowerCase() + "_" + dragonStage.name) + "")).findFirst();
        if (skinForName.isPresent()) {
            return skinForName.get();
        }
        Optional<ResourceLocation> defSkin = skinCache.get((Object)playerName).stream().filter(location -> location.toString().endsWith(cap.getType().toString().toLowerCase(Locale.ROOT) + "_" + dragonStage.name + ".png")).findFirst();
        if (defSkin.isPresent()) {
            return defSkin.get();
        }
        try {
            texture = ClientModEvents.loadCustomSkinForName(player, dragonStage);
            skinCacheForName.put((Object)playerName, (Object)texture);
        }
        catch (IOException e) {
            if (warningsForName.get(playerName) == null) {
                DragonSurvivalMod.LOGGER.info("Custom skin for user {} doesn't exist", (Object)playerName);
                warningsForName.put(playerName, true);
            }
        }
        finally {
            texture = ClientEvents.constructTexture(cap.getType(), dragonStage);
            skinCache.put((Object)playerName, (Object)texture);
        }
        return texture;
    }

    private static ResourceLocation constructTexture(DragonType dragonType, DragonLevel stage) {
        String texture = "textures/dragon/";
        switch (dragonType) {
            case SEA: {
                texture = texture + "sea";
                break;
            }
            case CAVE: {
                texture = texture + "cave";
                break;
            }
            case FOREST: {
                texture = texture + "forest";
            }
        }
        switch (stage) {
            case BABY: {
                texture = texture + "_newborn";
                break;
            }
            case YOUNG: {
                texture = texture + "_young";
                break;
            }
            case ADULT: {
                texture = texture + "_adult";
            }
        }
        texture = texture + ".png";
        return new ResourceLocation("dragonsurvival", texture);
    }

    private static String constructArmorTexture(PlayerEntity playerEntity, EquipmentSlotType equipmentSlot) {
        String texture = "textures/armor/";
        Item item = playerEntity.func_184582_a(equipmentSlot).func_77973_b();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            IArmorMaterial armorMaterial = armorItem.func_200880_d();
            if (armorMaterial == ArmorMaterial.DIAMOND) {
                texture = texture + "diamond_";
            } else if (armorMaterial == ArmorMaterial.IRON) {
                texture = texture + "iron_";
            } else if (armorMaterial == ArmorMaterial.LEATHER) {
                texture = texture + "leather_";
            } else if (armorMaterial == ArmorMaterial.GOLD) {
                texture = texture + "gold_";
            } else if (armorMaterial == ArmorMaterial.CHAIN) {
                texture = texture + "chainmail_";
            }
            texture = texture + "dragon_";
            switch (equipmentSlot) {
                case HEAD: {
                    texture = texture + "helmet";
                    break;
                }
                case CHEST: {
                    texture = texture + "chestplate";
                    break;
                }
                case LEGS: {
                    texture = texture + "leggings";
                    break;
                }
                case FEET: {
                    texture = texture + "boots";
                }
            }
            texture = texture + ".png";
            return texture;
        }
        return texture + "empty_armor.png";
    }

    static {
        warnings = new HashMap();
        warningsForName = new HashMap();
        skinCache = HashMultimap.create((int)1, (int)3);
        skinCacheForName = HashMultimap.create((int)1, (int)3);
        playerDragonHashMap = new ConcurrentHashMap(20);
        dragonsFlying = new ConcurrentHashMap(20);
        dragonsDigging = new ConcurrentHashMap(20);
        dragonsJumpingTicks = new ConcurrentHashMap(20);
        HUDTextures = new ResourceLocation("dragonsurvival", "textures/gui/dragon_hud.png");
    }
}

