/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.handlers;

import by.jackraidenph.dragonsurvival.entity.MagicalPredatorEntity;
import by.jackraidenph.dragonsurvival.gecko.DragonEntity;
import by.jackraidenph.dragonsurvival.handlers.ItemsInit;
import by.jackraidenph.dragonsurvival.util.BiomeDictionaryHelper;
import by.jackraidenph.dragonsurvival.util.ConfigurationHandler;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dragonsurvival", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityTypesInit {
    private static final List<EntityType<?>> entities = Lists.newArrayList();
    private static final List<Item> spawnEggs = Lists.newArrayList();
    public static EntityType<MagicalPredatorEntity> MAGICAL_BEAST;
    public static EntityType<DragonEntity> dragonEntity;

    private static <T extends CreatureEntity> EntityType<T> createEntity(Class<T> entityClass, EntityType.IFactory<T> factory, float width, float height, int eggPrimary, int eggSecondary) {
        ResourceLocation location = new ResourceLocation("dragonsurvival", EntityTypesInit.classToString(entityClass));
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MONSTER).func_220321_a(width, height).setTrackingRange(64).setUpdateInterval(1).func_206830_a(location.toString());
        entity.setRegistryName(location);
        entities.add(entity);
        SpawnEggItem spawnEgg = new SpawnEggItem(entity, eggPrimary, eggSecondary, new Item.Properties().func_200916_a(ItemsInit.items));
        spawnEgg.setRegistryName(new ResourceLocation("dragonsurvival", EntityTypesInit.classToString(entityClass) + "_spawn_egg"));
        spawnEggs.add((Item)spawnEgg);
        return entity;
    }

    private static String classToString(Class<? extends CreatureEntity> entityClass) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_", "");
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType<?> entity : entities) {
            Preconditions.checkNotNull((Object)entity.getRegistryName(), (Object)"registryName");
            event.getRegistry().register(entity);
            EntitySpawnPlacementRegistry.func_209343_a(entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        }
        dragonEntity = new EntityType(DragonEntity::new, EntityClassification.MISC, true, false, false, false, EntitySize.func_220311_c((float)0.9f, (float)1.9f));
        dragonEntity.setRegistryName(new ResourceLocation("dragonsurvival", "dummy_dragon"));
        event.getRegistry().register(dragonEntity);
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        MAGICAL_BEAST = EntityTypesInit.createEntity(MagicalPredatorEntity.class, MagicalPredatorEntity::new, 1.1f, 1.5625f, 0, 0xFFFFFF);
        for (Item spawnEgg : spawnEggs) {
            Preconditions.checkNotNull((Object)spawnEgg.getRegistryName(), (Object)"registry name is null");
            event.getRegistry().register((IForgeRegistryEntry)spawnEgg);
        }
    }

    public static void addSpawn() {
        ArrayList spawnableBiomes = Lists.newArrayList();
        List<BiomeDictionary.Type> includeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray((List)ConfigurationHandler.SPAWN.include.get()));
        List<BiomeDictionary.Type> excludeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray((List)ConfigurationHandler.SPAWN.exclude.get()));
        if (!includeList.isEmpty()) {
            for (BiomeDictionary.Type type : includeList) {
                for (Biome biome : BiomeDictionary.getBiomes((BiomeDictionary.Type)type)) {
                    if (biome.func_76747_a(EntityClassification.MONSTER).isEmpty()) continue;
                    spawnableBiomes.add(biome);
                }
            }
            if (!excludeList.isEmpty()) {
                for (BiomeDictionary.Type type : excludeList) {
                    Set excludeBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)type);
                    for (Biome biome : excludeBiomes) {
                        spawnableBiomes.remove(biome);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Do not leave the BiomeDictionary type inclusion list empty. If you wish to disable spawning of an entity, set the weight to 0 instead.");
        }
        for (Biome biome : spawnableBiomes) {
            biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(MAGICAL_BEAST, ((Integer)ConfigurationHandler.SPAWN.weight.get()).intValue(), ((Integer)ConfigurationHandler.SPAWN.min.get()).intValue(), ((Integer)ConfigurationHandler.SPAWN.max.get()).intValue()));
        }
    }
}

