/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.handlers;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.entity.MagicalPredatorEntity;
import by.jackraidenph.dragonsurvival.handlers.BlockInit;
import by.jackraidenph.dragonsurvival.handlers.EntityTypesInit;
import by.jackraidenph.dragonsurvival.handlers.ItemsInit;
import by.jackraidenph.dragonsurvival.nest.NestEntity;
import by.jackraidenph.dragonsurvival.network.DiggingStatus;
import by.jackraidenph.dragonsurvival.network.RefreshDragons;
import by.jackraidenph.dragonsurvival.network.StartJump;
import by.jackraidenph.dragonsurvival.network.SynchronizeDragonCap;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneOreBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Food;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class EventHandler {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase == TickEvent.Phase.START) {
            PlayerEntity playerEntity = playerTickEvent.player;
            DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
                if (dragonStateHandler.isDragon()) {
                    for (int i = 0; i < playerEntity.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stack = playerEntity.field_71071_by.func_70301_a(i);
                        Item item = stack.func_77973_b();
                        if (!(item instanceof CrossbowItem) && !(item instanceof BowItem) && !(item instanceof ShieldItem)) continue;
                        playerEntity.func_146097_a(playerEntity.field_71071_by.func_70304_b(i), true, false);
                    }
                    if (playerEntity instanceof ServerPlayerEntity) {
                        PlayerInteractionManager interactionManager = ((ServerPlayerEntity)playerEntity).field_71134_c;
                        Field field = PlayerInteractionManager.class.getDeclaredFields()[4];
                        field.setAccessible(true);
                        if (field.getType() == Boolean.TYPE) {
                            try {
                                boolean isMining = field.getBoolean(interactionManager);
                                DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new DiggingStatus(playerEntity.func_145782_y(), isMining));
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
    }

    @Deprecated
    public static void setPlayerContainer(PlayerEntity playerEntity) {
        Field field = PlayerEntity.class.getDeclaredFields()[15];
        if (field.getType() == PlayerContainer.class) {
            field.setAccessible(true);
            try {
                PlayerContainer playerContainer = new PlayerContainer(playerEntity.field_71071_by, playerEntity.field_70170_p.field_72995_K, playerEntity);
                field.set(playerEntity, playerContainer);
                playerEntity.field_71070_bA = playerContainer;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onJoin(EntityJoinWorldEvent joinWorldEvent) {
        Entity entity = joinWorldEvent.getEntity();
        if ((!(entity instanceof MonsterEntity) && !(entity instanceof VillagerEntity) && !(entity instanceof GolemEntity) && !(entity instanceof HorseEntity)) & entity instanceof CreatureEntity) {
            ((MobEntity)entity).field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)entity, PlayerEntity.class, livingEntity -> DragonStateProvider.isDragon((Entity)((PlayerEntity)livingEntity)), 20.0f, (double)1.3f, 1.5, EntityPredicates.field_188444_d));
        }
        if (entity instanceof HorseEntity) {
            HorseEntity horseEntity = (HorseEntity)entity;
            horseEntity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)horseEntity, PlayerEntity.class, 0, true, false, livingEntity -> ((DragonStateHandler)livingEntity.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElseGet(null)).getLevel() != DragonLevel.ADULT));
            horseEntity.field_70715_bh.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)horseEntity, PlayerEntity.class, livingEntity -> ((DragonStateHandler)livingEntity.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElse(null)).getLevel() == DragonLevel.ADULT, 20.0f, 1.3, 1.5, EntityPredicates.field_188444_d::test));
        }
    }

    @SubscribeEvent
    public static void onCapabilityAttachment(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("dragonsurvival", "playerstatehandler"), (ICapabilityProvider)new DragonStateProvider());
            DragonSurvivalMod.LOGGER.info("Successfully attached capability to the " + ((Entity)event.getObject()).getClass().getSimpleName());
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent e) {
        LivingEntity livingEntity = e.getEntityLiving();
        if (livingEntity instanceof PlayerEntity || livingEntity instanceof MagicalPredatorEntity) {
            return;
        }
        if (livingEntity instanceof AnimalEntity && livingEntity.field_70170_p.func_201674_k().nextInt(30) == 0) {
            MagicalPredatorEntity beast = (MagicalPredatorEntity)EntityTypesInit.MAGICAL_BEAST.func_200721_a(livingEntity.field_70170_p);
            livingEntity.field_70170_p.func_217376_c((Entity)beast);
            beast.func_70634_a(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_());
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone e) {
        DragonStateProvider.getCap((Entity)e.getPlayer()).ifPresent(capNew -> DragonStateProvider.getCap((Entity)e.getOriginal()).ifPresent(capOld -> {
            if (capOld.isDragon()) {
                capNew.setIsDragon(true);
                DragonStateHandler.DragonMovementData movementData = capOld.getMovementData();
                capNew.setMovementData(movementData.bodyYaw, movementData.headYaw, movementData.headPitch);
                capNew.setLevel(capOld.getLevel());
                capNew.setType(capOld.getType());
                capNew.setHasWings(capOld.hasWings());
                e.getPlayer().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(e.getOriginal().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
            }
        }));
    }

    @SubscribeEvent
    public static void changedDimension(PlayerEvent.PlayerChangedDimensionEvent changedDimensionEvent) {
        PlayerEntity playerEntity = changedDimensionEvent.getPlayer();
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SynchronizeDragonCap(playerEntity.func_145782_y(), dragonStateHandler.isHiding(), dragonStateHandler.getType(), dragonStateHandler.getLevel(), dragonStateHandler.isDragon(), dragonStateHandler.getHealth(), dragonStateHandler.hasWings()));
            DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDragons(playerEntity.func_145782_y()));
        });
    }

    @SubscribeEvent
    public static void modifyBreakSpeed(PlayerEvent.BreakSpeed breakSpeedEvent) {
        PlayerEntity playerEntity = breakSpeedEvent.getPlayer();
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            ItemStack mainStack;
            Item item;
            if (dragonStateHandler.isDragon() && ((item = (mainStack = playerEntity.func_184614_ca()).func_77973_b()) instanceof ToolItem || item instanceof SwordItem || item instanceof ShearsItem)) {
                breakSpeedEvent.setNewSpeed(breakSpeedEvent.getOriginalSpeed() * 0.7f);
            }
        });
    }

    @SubscribeEvent
    public static void disableMounts(EntityMountEvent mountEvent) {
        Entity mounting = mountEvent.getEntityMounting();
        DragonStateProvider.getCap(mounting).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon() && mountEvent.getEntityBeingMounted() instanceof AbstractHorseEntity) {
                mountEvent.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void onItemDestroyed(LivingEntityUseItemEvent.Finish destroyItemEvent) {
        ItemStack itemStack = destroyItemEvent.getItem();
        Item item = itemStack.func_77973_b();
        LivingEntity livingEntity = destroyItemEvent.getEntityLiving();
        DragonStateProvider.getCap((Entity)livingEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                PlayerEntity playerEntity = (PlayerEntity)livingEntity;
                if (item.func_219971_r()) {
                    Food food = item.func_219967_s();
                    assert (food != null);
                    boolean bad = false;
                    if (item != Items.field_226638_pX_ && item != Items.field_222070_lD && item != Items.field_151153_ao && item != Items.field_151117_aB && item != Items.field_196100_at) {
                        bad = true;
                    }
                    switch (dragonStateHandler.getType()) {
                        case FOREST: {
                            if (food != Foods.field_221417_E && food != Foods.field_221419_G && food != Foods.field_221432_h && food != Foods.field_221427_c && food != Foods.field_221413_A && food != Foods.field_221449_y) break;
                            bad = false;
                            livingEntity.func_195063_d(Effects.field_76438_s);
                            if (food == Foods.field_221432_h) {
                                playerEntity.func_71024_bL().func_75122_a(0, 5.8f);
                                break;
                            }
                            if (food == Foods.field_221413_A || food == Foods.field_221427_c) {
                                playerEntity.func_71024_bL().func_75122_a(-1, 6.4f);
                                break;
                            }
                            if (food == Foods.field_221419_G) {
                                playerEntity.func_71024_bL().func_75122_a(-1, 2.2f);
                                break;
                            }
                            if (food != Foods.field_221417_E) break;
                            playerEntity.func_71024_bL().func_75122_a(2, 11.2f);
                            break;
                        }
                        case SEA: {
                            if (food != Foods.field_221420_H && food != Foods.field_221424_L && food != Foods.field_221434_j && food != Foods.field_221415_C && food != Foods.field_221443_s) break;
                            bad = false;
                            livingEntity.func_195063_d(Effects.field_76438_s);
                            livingEntity.func_195063_d(Effects.field_76431_k);
                            livingEntity.func_195063_d(Effects.field_76436_u);
                            if (food == Foods.field_221424_L) {
                                playerEntity.func_71024_bL().func_75122_a(1, 6.8f);
                                break;
                            }
                            if (food == Foods.field_221420_H) {
                                playerEntity.func_71024_bL().func_75122_a(0, 6.8f);
                                break;
                            }
                            if (food == Foods.field_221434_j) {
                                playerEntity.func_71024_bL().func_75122_a(0, 6.6f);
                                break;
                            }
                            if (food == Foods.field_221415_C) {
                                playerEntity.func_71024_bL().func_75122_a(9, 12.8f);
                                break;
                            }
                            playerEntity.func_71024_bL().func_75122_a(1, 2.4f);
                            break;
                        }
                        case CAVE: {
                            if (item != ItemsInit.chargedCoal && item != ItemsInit.charredMeat) break;
                            bad = false;
                        }
                    }
                    if (bad) {
                        livingEntity.func_195064_c(new EffectInstance(Effects.field_76438_s, 1200, 0));
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void consumeSpecialFood(PlayerInteractEvent.RightClickItem rightClickItem) {
        PlayerEntity playerEntity = rightClickItem.getPlayer();
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon() && playerEntity.func_71024_bL().func_75121_c()) {
                ItemStack itemStack = rightClickItem.getItemStack();
                Item item = itemStack.func_77973_b();
                if (dragonStateHandler.getType() == DragonType.CAVE) {
                    if (item == Items.field_151044_h) {
                        itemStack.func_190918_g(1);
                        playerEntity.func_71024_bL().func_75122_a(1, 1.0f);
                    } else if (item == Items.field_196155_l) {
                        itemStack.func_190918_g(1);
                        playerEntity.func_71024_bL().func_75122_a(1, 2.0f);
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent jumpEvent) {
        LivingEntity livingEntity = jumpEvent.getEntityLiving();
        DragonStateProvider.getCap((Entity)livingEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                switch (dragonStateHandler.getLevel()) {
                    case BABY: {
                        livingEntity.func_70024_g(0.0, 0.025, 0.0);
                        break;
                    }
                    case YOUNG: {
                        livingEntity.func_70024_g(0.0, 0.1, 0.0);
                        break;
                    }
                    case ADULT: {
                        livingEntity.func_70024_g(0.0, 0.15, 0.0);
                    }
                }
                if (livingEntity instanceof ServerPlayerEntity) {
                    if (livingEntity.func_184102_h().func_71264_H()) {
                        DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StartJump(livingEntity.func_145782_y(), 42));
                    } else {
                        DragonSurvivalMod.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StartJump(livingEntity.func_145782_y(), 21));
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void sleepCheck(SleepingLocationCheckEvent sleepingLocationCheckEvent) {
        BlockPos sleepingLocation = sleepingLocationCheckEvent.getSleepingLocation();
        World world = sleepingLocationCheckEvent.getEntity().field_70170_p;
        if (world.func_226690_K_() && world.func_175625_s(sleepingLocation) instanceof NestEntity) {
            sleepingLocationCheckEvent.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void dropDragonDust(BlockEvent.BreakEvent breakEvent) {
        IWorld world;
        if (!breakEvent.isCanceled() && (world = breakEvent.getWorld()) instanceof ServerWorld) {
            boolean suitableOre;
            BlockState blockState = breakEvent.getState();
            BlockPos blockPos = breakEvent.getPos();
            PlayerEntity playerEntity = breakEvent.getPlayer();
            Block block = blockState.func_177230_c();
            boolean bl = suitableOre = block instanceof RedstoneOreBlock || block == Blocks.field_150412_bA || block == Blocks.field_150482_ag || block == Blocks.field_150369_x || block == Blocks.field_150365_q || block == Blocks.field_196766_fg;
            if (suitableOre) {
                int random;
                if (DragonStateProvider.isDragon((Entity)playerEntity)) {
                    random = playerEntity.func_70681_au().nextInt(100);
                    if (random < 80) {
                        world.func_217376_c((Entity)new ItemEntity((World)world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, new ItemStack((IItemProvider)ItemsInit.elderDragonDust)));
                    }
                    if (random == 0) {
                        world.func_217376_c((Entity)new ItemEntity((World)world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, new ItemStack((IItemProvider)ItemsInit.elderDragonBone)));
                    }
                } else {
                    random = playerEntity.func_70681_au().nextInt(300);
                }
                if (random == 0) {
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, new ItemStack((IItemProvider)ItemsInit.elderDragonDust)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void createAltar(PlayerInteractEvent.RightClickBlock rightClickBlock) {
        ItemStack itemStack = rightClickBlock.getItemStack();
        if (itemStack.func_77973_b() == ItemsInit.elderDragonBone) {
            World world = rightClickBlock.getWorld();
            BlockPos blockPos = rightClickBlock.getPos();
            BlockState blockState = world.func_180495_p(blockPos);
            Block block = blockState.func_177230_c();
            boolean replace = false;
            if (block == Blocks.field_150348_b) {
                world.func_175656_a(blockPos, BlockInit.dragon_altar3.func_176223_P());
                replace = true;
            } else if (block == Blocks.field_150322_A) {
                world.func_175656_a(blockPos, BlockInit.dragon_altar4.func_176223_P());
                replace = true;
            } else if (block == Blocks.field_150341_Y) {
                world.func_175656_a(blockPos, BlockInit.dragon_altar.func_176223_P());
                replace = true;
            } else if (block == Blocks.field_196617_K) {
                world.func_175656_a(blockPos, BlockInit.dragon_altar2.func_176223_P());
                replace = true;
            }
            if (replace) {
                itemStack.func_190918_g(1);
                rightClickBlock.setCanceled(true);
                world.func_184133_a(rightClickBlock.getPlayer(), blockPos, SoundEvents.field_187845_fY, SoundCategory.PLAYERS, 1.0f, 1.0f);
                rightClickBlock.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void reduceFallDistance(LivingFallEvent livingFallEvent) {
        LivingEntity livingEntity = livingFallEvent.getEntityLiving();
        if (DragonStateProvider.isDragon((Entity)livingEntity)) {
            livingFallEvent.setDistance(livingFallEvent.getDistance() - 1.0f);
        }
    }
}

