/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.nest;

import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.handlers.BlockInit;
import by.jackraidenph.dragonsurvival.handlers.TileEntityTypesInit;
import by.jackraidenph.dragonsurvival.nest.NestBlock;
import by.jackraidenph.dragonsurvival.nest.NestEntity;
import by.jackraidenph.dragonsurvival.nest.NestPlaceHolder;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MediumNestBlock
extends NestBlock {
    static final BooleanProperty PRIMARY_BLOCK = BooleanProperty.func_177716_a((String)"primary");

    public MediumNestBlock(Block.Properties properties) {
        super(properties);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{PRIMARY_BLOCK});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        PlayerEntity playerEntity;
        Direction direction;
        BlockPos blockPos = context.func_195995_a();
        World world = context.func_195991_k();
        if (world.func_175623_d(blockPos.func_177972_a(direction = (playerEntity = context.func_195999_j()).func_174811_aO())) && world.func_175623_d(blockPos.func_177972_a(direction.func_176735_f())) && world.func_175623_d(blockPos.func_177972_a(direction).func_177972_a(direction.func_176735_f()))) {
            return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)field_185512_D, (Comparable)direction.func_176734_d());
        }
        return null;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (!((Boolean)state.func_177229_b((IProperty)PRIMARY_BLOCK)).booleanValue()) {
            return TileEntityTypesInit.nestPlaceHolder.func_200968_a();
        }
        return super.createTileEntity(state, world);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        DragonStateHandler dragonStateHandler = (DragonStateHandler)player.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElse(null);
        DragonLevel dragonLevel = dragonStateHandler.getLevel();
        BlockPos rootPos = null;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof NestEntity) {
            rootPos = pos;
        } else if (tileEntity instanceof NestPlaceHolder) {
            rootPos = ((NestPlaceHolder)tileEntity).rootPos;
        }
        DragonType dragonType = dragonStateHandler.getType();
        NestEntity nest = (NestEntity)worldIn.func_175625_s(rootPos);
        if (dragonStateHandler.isDragon() && dragonLevel == DragonLevel.ADULT && nest.ownerUUID.equals(player.func_110124_au()) && state.func_177230_c().getClass() == MediumNestBlock.class) {
            Direction playerDirection = player.func_174811_aO();
            if (worldIn.func_175623_d(rootPos.func_177972_a(playerDirection.func_176734_d())) && worldIn.func_175623_d(rootPos.func_177972_a(playerDirection).func_177972_a(playerDirection.func_176746_e())) && worldIn.func_175623_d(rootPos.func_177972_a(playerDirection.func_176746_e())) && worldIn.func_175623_d(rootPos.func_177972_a(playerDirection.func_176734_d()).func_177972_a(playerDirection.func_176735_f())) && worldIn.func_175623_d(rootPos.func_177972_a(playerDirection.func_176734_d()).func_177972_a(playerDirection.func_176746_e()))) {
                CompoundNBT compoundNBT = nest.func_189515_b(new CompoundNBT());
                Direction placementDirection = playerDirection.func_176734_d();
                switch (dragonType) {
                    case SEA: {
                        worldIn.func_175656_a(rootPos, (BlockState)BlockInit.bigSeaNest.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)placementDirection));
                        break;
                    }
                    case FOREST: {
                        worldIn.func_175656_a(rootPos, (BlockState)BlockInit.bigForestNest.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)placementDirection));
                        break;
                    }
                    case CAVE: {
                        worldIn.func_175656_a(rootPos, (BlockState)BlockInit.bigCaveNest.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)placementDirection));
                    }
                }
                NestEntity nestEntity = this.getBlockEntity(worldIn, rootPos);
                nestEntity.func_145839_a(compoundNBT);
                BlockState blockState = worldIn.func_180495_p(rootPos);
                blockState.func_177230_c().func_180633_a(worldIn, rootPos, blockState, (LivingEntity)player, player.func_184586_b(handIn));
                return ActionResultType.SUCCESS;
            }
            if (worldIn.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("ds.space.occupied", new Object[0]));
            }
            return ActionResultType.CONSUME;
        }
        if (!((Boolean)state.func_177229_b((IProperty)PRIMARY_BLOCK)).booleanValue()) {
            NestPlaceHolder placeHolder = (NestPlaceHolder)worldIn.func_175625_s(pos);
            BlockPos root = placeHolder.rootPos;
            if (worldIn.func_175625_s(root) == null) {
                worldIn.func_175655_b(pos, false);
                return ActionResultType.SUCCESS;
            }
            return super.func_225533_a_(worldIn.func_180495_p(root), worldIn, root, player, handIn, hit);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (placer != null) {
            Direction direction = placer.func_174811_aO();
            worldIn.func_175656_a(pos.func_177972_a(direction), (BlockState)state.func_206870_a((IProperty)PRIMARY_BLOCK, (Comparable)Boolean.valueOf(false)));
            NestPlaceHolder placeHolder = (NestPlaceHolder)worldIn.func_175625_s(pos.func_177972_a(direction));
            placeHolder.rootPos = pos;
            worldIn.func_175656_a(pos.func_177972_a(direction.func_176735_f()), (BlockState)state.func_206870_a((IProperty)PRIMARY_BLOCK, (Comparable)Boolean.valueOf(false)));
            NestPlaceHolder placeHolder2 = (NestPlaceHolder)worldIn.func_175625_s(pos.func_177972_a(direction.func_176735_f()));
            placeHolder2.rootPos = pos;
            worldIn.func_175656_a(pos.func_177972_a(direction).func_177972_a(direction.func_176735_f()), (BlockState)state.func_206870_a((IProperty)PRIMARY_BLOCK, (Comparable)Boolean.valueOf(false)));
            NestPlaceHolder placeHolder3 = (NestPlaceHolder)worldIn.func_175625_s(pos.func_177972_a(direction).func_177972_a(direction.func_176735_f()));
            placeHolder3.rootPos = pos;
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)PRIMARY_BLOCK) != false ? BlockRenderType.MODEL : BlockRenderType.INVISIBLE;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
        if (((Boolean)state.func_177229_b((IProperty)PRIMARY_BLOCK)).booleanValue()) {
            Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
            worldIn.func_175655_b(pos.func_177972_a(direction.func_176734_d()), false);
            worldIn.func_175655_b(pos.func_177972_a(direction.func_176734_d()).func_177972_a(direction.func_176746_e()), false);
            worldIn.func_175655_b(pos.func_177972_a(direction.func_176746_e()), false);
        }
    }
}

