/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.nest;

import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.handlers.BlockInit;
import by.jackraidenph.dragonsurvival.handlers.TileEntityTypesInit;
import by.jackraidenph.dragonsurvival.nest.NestEntity;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class NestBlock
extends HorizontalBlock {
    public static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.1, (double)1.0);
    public static final VoxelShape OUTLINE = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);

    public NestBlock(Block.Properties properties) {
        super(properties);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{field_185512_D});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return TileEntityTypesInit.nestEntityTile.func_200968_a();
    }

    public NestEntity getBlockEntity(World world, BlockPos pos) {
        return (NestEntity)world.func_175625_s(pos);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return 0.0f;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        UUID uuid = player.func_110124_au();
        DragonStateHandler dragonStateHandler = (DragonStateHandler)player.getCapability(DragonStateProvider.DRAGON_CAPABILITY).orElse(null);
        DragonLevel dragonLevel = dragonStateHandler.getLevel();
        DragonType dragonType = dragonStateHandler.getType();
        TileEntity blockEntity = worldIn.func_175625_s(pos);
        if (blockEntity instanceof NestEntity && uuid.equals(((NestEntity)blockEntity).ownerUUID)) {
            Direction playerHorizontalFacing = player.func_174811_aO();
            Direction placementDirection = playerHorizontalFacing.func_176734_d();
            if (state.func_177230_c().getClass() == NestBlock.class && dragonLevel == DragonLevel.YOUNG) {
                if (worldIn.func_175623_d(pos.func_177972_a(playerHorizontalFacing)) && worldIn.func_175623_d(pos.func_177972_a(playerHorizontalFacing.func_176735_f())) && worldIn.func_175623_d(pos.func_177972_a(playerHorizontalFacing).func_177972_a(playerHorizontalFacing.func_176735_f()))) {
                    CompoundNBT compoundNBT = blockEntity.func_189515_b(new CompoundNBT());
                    switch (dragonType) {
                        case SEA: {
                            worldIn.func_175656_a(pos, (BlockState)BlockInit.mediumSeaNest.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)placementDirection));
                            break;
                        }
                        case FOREST: {
                            worldIn.func_175656_a(pos, (BlockState)BlockInit.mediumForestNest.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)placementDirection));
                            break;
                        }
                        case CAVE: {
                            worldIn.func_175656_a(pos, (BlockState)BlockInit.mediumCaveNest.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)placementDirection));
                        }
                    }
                    NestEntity nestEntity = this.getBlockEntity(worldIn, pos);
                    nestEntity.func_145839_a(compoundNBT);
                    BlockState blockState = worldIn.func_180495_p(pos);
                    blockState.func_177230_c().func_180633_a(worldIn, pos, blockState, (LivingEntity)player, player.func_184586_b(handIn));
                    return ActionResultType.SUCCESS;
                }
                if (worldIn.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("ds.space.occupied", new Object[0]));
                }
                return ActionResultType.CONSUME;
            }
            if (state.func_177230_c().getClass() == NestBlock.class && dragonLevel == DragonLevel.ADULT) {
                if (worldIn.func_175623_d(pos.func_177978_c()) && worldIn.func_175623_d(pos.func_177968_d()) && worldIn.func_175623_d(pos.func_177976_e()) && worldIn.func_175623_d(pos.func_177974_f()) && worldIn.func_175623_d(pos.func_177978_c().func_177976_e()) && worldIn.func_175623_d(pos.func_177978_c().func_177974_f()) && worldIn.func_175623_d(pos.func_177968_d().func_177974_f()) && worldIn.func_175623_d(pos.func_177968_d().func_177976_e())) {
                    CompoundNBT compoundNBT = blockEntity.func_189515_b(new CompoundNBT());
                    switch (dragonType) {
                        case SEA: {
                            worldIn.func_175656_a(pos, (BlockState)BlockInit.bigSeaNest.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)placementDirection));
                            break;
                        }
                        case FOREST: {
                            worldIn.func_175656_a(pos, (BlockState)BlockInit.bigForestNest.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)placementDirection));
                            break;
                        }
                        case CAVE: {
                            worldIn.func_175656_a(pos, (BlockState)BlockInit.bigCaveNest.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)placementDirection));
                        }
                    }
                    NestEntity nestEntity = this.getBlockEntity(worldIn, pos);
                    nestEntity.func_145839_a(compoundNBT);
                    BlockState blockState = worldIn.func_180495_p(pos);
                    blockState.func_177230_c().func_180633_a(worldIn, pos, blockState, (LivingEntity)player, player.func_184586_b(handIn));
                    return ActionResultType.SUCCESS;
                }
                if (worldIn.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("ds.space.occupied", new Object[0]));
                }
                return ActionResultType.CONSUME;
            }
        }
        if (player instanceof ServerPlayerEntity && player.func_110124_au().equals(this.getBlockEntity((World)worldIn, (BlockPos)pos).ownerUUID)) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.getBlockEntity(worldIn, pos), packetBuffer -> packetBuffer.func_179255_a(pos));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        NestEntity nestEntity = this.getBlockEntity(worldIn, pos);
        if (placer != null) {
            DragonStateProvider.getCap((Entity)placer).ifPresent(dragonStateHandler -> {
                if (dragonStateHandler.isDragon()) {
                    if (nestEntity.ownerUUID == null) {
                        nestEntity.ownerUUID = placer.func_110124_au();
                    }
                    if (nestEntity.field_200663_e == DragonType.NONE) {
                        nestEntity.field_200663_e = dragonStateHandler.getType();
                    }
                }
            });
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return OUTLINE;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public boolean isBed(BlockState state, IBlockReader world, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public void setBedOccupied(BlockState state, IWorldReader world, BlockPos pos, LivingEntity sleeper, boolean occupied) {
    }
}

