/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.nest;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.Functions;
import by.jackraidenph.dragonsurvival.nest.DismantleNest;
import by.jackraidenph.dragonsurvival.nest.NestContainer;
import by.jackraidenph.dragonsurvival.nest.NestEntity;
import by.jackraidenph.dragonsurvival.nest.SleepInNest;
import by.jackraidenph.dragonsurvival.nest.ToggleRegeneration;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class NestScreen
extends ContainerScreen<NestContainer> {
    static final ResourceLocation BACKGROUND = new ResourceLocation("dragonsurvival", "textures/ui/nest_ui.png");
    static final ResourceLocation CAVE_NEST0 = new ResourceLocation("dragonsurvival", "textures/ui/cave_nest_0.png");
    static final ResourceLocation CAVE_NEST1 = new ResourceLocation("dragonsurvival", "textures/ui/cave_nest_1.png");
    static final ResourceLocation FOREST_NEST0 = new ResourceLocation("dragonsurvival", "textures/ui/forest_nest_0.png");
    static final ResourceLocation FOREST_NEST1 = new ResourceLocation("dragonsurvival", "textures/ui/forest_nest_1.png");
    static final ResourceLocation SEA_NEST0 = new ResourceLocation("dragonsurvival", "textures/ui/sea_nest_0.png");
    static final ResourceLocation SEA_NEST1 = new ResourceLocation("dragonsurvival", "textures/ui/sea_nest_1.png");
    static final ResourceLocation RED_HEART = new ResourceLocation("dragonsurvival", "textures/ui/red_heart.png");
    private final NestEntity nestEntity;
    private final PlayerEntity playerEntity;

    public NestScreen(NestContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.nestEntity = screenContainer.nestEntity;
        this.playerEntity = inv.field_70458_d;
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        super.render(p_render_1_, p_render_2_, p_render_3_);
        this.func_191948_b(p_render_1_, p_render_2_);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        TextureManager textureManager = this.minecraft.func_110434_K();
        textureManager.func_110577_a(BACKGROUND);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.nestEntity.energy == 64) {
            switch (this.nestEntity.field_200663_e) {
                case CAVE: {
                    textureManager.func_110577_a(CAVE_NEST1);
                    break;
                }
                case FOREST: {
                    textureManager.func_110577_a(FOREST_NEST1);
                    break;
                }
                case SEA: {
                    textureManager.func_110577_a(SEA_NEST1);
                }
            }
        } else {
            switch (this.nestEntity.field_200663_e) {
                case CAVE: {
                    textureManager.func_110577_a(CAVE_NEST0);
                    break;
                }
                case FOREST: {
                    textureManager.func_110577_a(FOREST_NEST0);
                    break;
                }
                case SEA: {
                    textureManager.func_110577_a(SEA_NEST0);
                }
            }
        }
        NestScreen.blit((int)(this.field_147003_i + 8), (int)(this.field_147009_r + 8), (float)0.0f, (float)0.0f, (int)160, (int)49, (int)160, (int)49);
        textureManager.func_110577_a(RED_HEART);
        Functions.blit(this.field_147003_i + 122, this.field_147009_r + 12 + 35, 0.0f, 0.0f, 38, (int)(-35.0f * ((float)this.nestEntity.energy / 64.0f)), 38, 35);
    }

    protected void init() {
        super.init();
        ExtendedButton sleep = (ExtendedButton)this.addButton((Widget)new ExtendedButton(this.field_147003_i + 8, this.field_147009_r + 60, 33, 18, "", p_onPress_1_ -> {}){

            public void renderButton(int mouseX, int mouseY, float partial) {
            }

            public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
                NestScreen.this.playerEntity.func_71053_j();
                DragonSurvivalMod.CHANNEL.sendToServer((Object)new SleepInNest(NestScreen.this.nestEntity.func_174877_v()));
                return true;
            }
        });
        ExtendedButton regenerate = (ExtendedButton)this.addButton((Widget)new ExtendedButton(sleep.x + sleep.getWidth() + 4, this.field_147009_r + 60, 33, 18, "", p_onPress_1_ -> {}){

            public void renderButton(int mouseX, int mouseY, float partial) {
            }

            public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
                ((NestScreen)NestScreen.this).nestEntity.regenerationMode = !((NestScreen)NestScreen.this).nestEntity.regenerationMode;
                DragonSurvivalMod.CHANNEL.sendToServer((Object)new ToggleRegeneration(NestScreen.this.nestEntity.func_174877_v(), ((NestScreen)NestScreen.this).nestEntity.regenerationMode));
                if (((NestScreen)NestScreen.this).nestEntity.regenerationMode) {
                    NestScreen.this.playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("ds.regen.on", new Object[0]));
                } else {
                    NestScreen.this.playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("ds.regen.off", new Object[0]));
                }
                return true;
            }
        });
        this.addButton((Widget)new ExtendedButton(regenerate.x + regenerate.getWidth() + 4, this.field_147009_r + 60, 33, 18, "", p_onPress_1_ -> {}){

            public void renderButton(int mouseX, int mouseY, float partial) {
            }

            public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
                NestScreen.this.playerEntity.func_71053_j();
                DragonSurvivalMod.CHANNEL.sendToServer((Object)new DismantleNest(NestScreen.this.nestEntity.func_174877_v()));
                return true;
            }
        });
    }
}

