/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.shader;

import by.jackraidenph.dragonsurvival.DragonSurvivalMod;
import by.jackraidenph.dragonsurvival.shader.ShaderCallback;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.IShaderManager;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.shader.ShaderLoader;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import org.lwjgl.system.MemoryUtil;

public final class ShaderHelper {
    public static final FloatBuffer FLOAT_BUF = MemoryUtil.memAllocFloat((int)1);
    private static final Map<BotaniaShader, ShaderProgram> PROGRAMS = new EnumMap<BotaniaShader, ShaderProgram>(BotaniaShader.class);
    private static boolean hasIncompatibleMods = false;
    private static boolean checkedIncompatibility = false;

    public static void initShaders() {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().func_195551_G() instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)((IResourceManagerReloadListener)manager -> {
                PROGRAMS.values().forEach(ShaderLinkHelper::func_148077_a);
                PROGRAMS.clear();
                ShaderHelper.loadShaders(manager);
            }));
        }
    }

    private static void loadShaders(IResourceManager manager) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        for (BotaniaShader shader : BotaniaShader.values()) {
            ShaderHelper.createProgram(manager, shader);
        }
    }

    public static void useShader(BotaniaShader shader, @Nullable ShaderCallback callback) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        ShaderProgram prog = PROGRAMS.get((Object)shader);
        if (prog == null) {
            return;
        }
        int program = prog.func_147986_h();
        ShaderLinkHelper.func_227804_a_((int)program);
        int time = GlStateManager.func_227680_b_((int)program, (CharSequence)"time");
        GlStateManager.func_227718_f_((int)time, (int)((int)(System.currentTimeMillis() / 50L)));
        if (callback != null) {
            callback.call(program);
        }
    }

    public static void useShader(BotaniaShader shader) {
        ShaderHelper.useShader(shader, null);
    }

    public static void releaseShader() {
        ShaderLinkHelper.func_227804_a_((int)0);
    }

    public static boolean useShaders() {
        return true;
    }

    private static boolean checkIncompatibleMods() {
        if (!checkedIncompatibility) {
            hasIncompatibleMods = ModList.get().isLoaded("optifine");
            checkedIncompatibility = true;
        }
        return !hasIncompatibleMods;
    }

    private static void createProgram(IResourceManager manager, BotaniaShader shader) {
        try {
            ShaderLoader vert = ShaderHelper.createShader(manager, shader.vertexShaderPath, ShaderLoader.ShaderType.VERTEX);
            ShaderLoader frag = ShaderHelper.createShader(manager, shader.fragmentShaderPath, ShaderLoader.ShaderType.FRAGMENT);
            int progId = ShaderLinkHelper.func_148078_c();
            ShaderProgram prog = new ShaderProgram(progId, vert, frag);
            ShaderLinkHelper.func_148075_b((IShaderManager)prog);
            PROGRAMS.put(shader, prog);
        }
        catch (IOException ex) {
            DragonSurvivalMod.LOGGER.error("Failed to load program {}", (Object)shader.name(), (Object)ex);
        }
    }

    private static ShaderLoader createShader(IResourceManager manager, String filename, ShaderLoader.ShaderType shaderType) throws IOException {
        ResourceLocation loc = new ResourceLocation("dragonsurvival", filename);
        try (BufferedInputStream is = new BufferedInputStream(manager.func_199002_a(loc).func_199027_b());){
            ShaderLoader shaderLoader = ShaderLoader.func_216534_a((ShaderLoader.ShaderType)shaderType, (String)loc.toString(), (InputStream)is);
            return shaderLoader;
        }
    }

    private static class ShaderProgram
    implements IShaderManager {
        private final int program;
        private final ShaderLoader vert;
        private final ShaderLoader frag;

        private ShaderProgram(int program, ShaderLoader vert, ShaderLoader frag) {
            this.program = program;
            this.vert = vert;
            this.frag = frag;
        }

        public int func_147986_h() {
            return this.program;
        }

        public void func_147985_d() {
        }

        public ShaderLoader func_147989_e() {
            return this.vert;
        }

        public ShaderLoader func_147994_f() {
            return this.frag;
        }
    }

    public static enum BotaniaShader {
        COLOR_CYCLE("shaders/bloom.vert", "shaders/bloom.frag");

        public final String vertexShaderPath;
        public final String fragmentShaderPath;

        private BotaniaShader(String vertexShaderPath, String fragmentShaderPath) {
            this.vertexShaderPath = vertexShaderPath;
            this.fragmentShaderPath = fragmentShaderPath;
        }
    }
}

