/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.util;

import by.jackraidenph.dragonsurvival.util.BiomeDictionaryHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigurationHandler {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final Spawn SPAWN = new Spawn(BUILDER);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static ForgeConfigSpec.DoubleValue maxFlightSpeed;
    public static ForgeConfigSpec.DoubleValue predatorDamageFactor;
    public static ForgeConfigSpec.DoubleValue predatorHealthFactor;

    public static class Spawn {
        public final ForgeConfigSpec.IntValue min;
        public final ForgeConfigSpec.IntValue max;
        public final ForgeConfigSpec.IntValue weight;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> include;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> exclude;

        Spawn(ForgeConfigSpec.Builder builder) {
            builder.push("Predator spawn chances");
            builder.comment("Configure predator spawn weight & min/max group size. Set weight to 0 to disable.");
            this.min = builder.defineInRange("minimum", 1, 0, 64);
            this.max = builder.defineInRange("maximum", 3, 0, 64);
            this.weight = builder.defineInRange("weight", 4, 0, 100);
            builder.pop();
            builder.push("Predator spawn biomes");
            builder.comment("Biome types to include & exclude.");
            this.include = builder.defineList("include", Arrays.asList(BiomeDictionary.Type.FOREST.toString(), BiomeDictionary.Type.PLAINS.toString(), BiomeDictionary.Type.HILLS.toString(), BiomeDictionary.Type.SWAMP.toString(), BiomeDictionary.Type.SANDY.toString(), BiomeDictionary.Type.SNOWY.toString(), BiomeDictionary.Type.WASTELAND.toString(), BiomeDictionary.Type.BEACH.toString()), o -> BiomeDictionary.Type.getAll().contains(BiomeDictionaryHelper.getType(String.valueOf(o))));
            this.exclude = builder.defineList("exclude", Arrays.asList(BiomeDictionary.Type.MOUNTAIN.toString(), BiomeDictionary.Type.NETHER.toString()), o -> BiomeDictionary.Type.getAll().contains(BiomeDictionaryHelper.getType(String.valueOf(o))));
            builder.pop();
        }
    }

    public static class General {
        General(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            maxFlightSpeed = builder.defineInRange("Flight speed limiter", 0.3, 0.1, 1.0);
            predatorDamageFactor = builder.defineInRange("Predator damage factor", 1.0, 0.5, 10.0);
            predatorHealthFactor = builder.defineInRange("Predator health factor", 1.0, 0.2, 5.0);
            builder.pop();
        }
    }
}

