/*
 * Decompiled with CFR 0.152.
 */
package com.dusk.event;

import com.dusk.Dusk;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    private static int tickCounter = 0;
    private static double spawnModifier = 1.0;
    private static final int MONSTER_MAX_DEFAULT = EntityClassification.MONSTER.field_75606_e;
    private static final int RAISE_START = 12000;
    private static final int RAISE_STOP = 16000;
    private static final int DROP_START = 20000;
    private static final double INTERVAL = 20000.0;

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.func_201670_d() || event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.world.func_234923_W_() != World.field_234918_g_) {
            return;
        }
        if (++tickCounter != 20) {
            return;
        }
        tickCounter = 0;
        EventHandler.adjustSpawnModifier(event.world.func_72820_D());
    }

    private static void adjustClassification() {
        EntityClassification.MONSTER.field_75606_e = (int)((double)MONSTER_MAX_DEFAULT * spawnModifier);
    }

    private static void adjustSpawnModifier(long time) {
        if (time <= 16000L && time >= 12000L) {
            spawnModifier += (double)((Integer)Dusk.config.getCommonConfig().nightSpawnMod.get()).intValue() / 20000.0;
            EventHandler.adjustClassification();
        } else if (spawnModifier > 1.0 && (time > 20000L || time < 12000L)) {
            spawnModifier -= (double)((Integer)Dusk.config.getCommonConfig().nightSpawnMod.get()).intValue() / 20000.0;
            spawnModifier = Math.max(spawnModifier, 1.0);
            EventHandler.adjustClassification();
        }
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent event) {
        if (((Boolean)Dusk.config.getCommonConfig().disableSleep.get()).booleanValue()) {
            event.setResult(PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
        }
    }
}

