/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation;

import maninhouse.epicfight.animation.Pose;
import maninhouse.epicfight.animation.types.DynamicAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;

public class AnimationPlayer {
    private float elapsedTime;
    private float prevElapsedTime;
    private float exceedTime;
    private boolean isEnd;
    private boolean doNotResetNext;
    private DynamicAnimation play;

    public AnimationPlayer() {
        this.resetPlayer();
    }

    public AnimationPlayer(DynamicAnimation animation) {
        this.setPlayAnimation(animation);
    }

    public void update(float updateTime) {
        this.prevElapsedTime = this.elapsedTime;
        this.elapsedTime += updateTime;
        if (this.elapsedTime >= this.play.getTotalTime()) {
            if (this.play.isRepeat()) {
                this.prevElapsedTime = 0.0f;
                this.elapsedTime %= this.play.getTotalTime();
            } else {
                this.exceedTime = this.elapsedTime - this.play.getTotalTime();
                this.elapsedTime = this.play.getTotalTime();
                this.isEnd = true;
            }
        } else if (this.elapsedTime < 0.0f) {
            if (this.play.isRepeat()) {
                this.prevElapsedTime = this.play.getTotalTime();
                this.elapsedTime = this.play.getTotalTime() + this.elapsedTime;
            } else {
                this.elapsedTime = 0.0f;
                this.isEnd = true;
            }
        }
    }

    public void synchronize(AnimationPlayer animationPlayer) {
        this.play = animationPlayer.play;
        this.elapsedTime = animationPlayer.elapsedTime;
        this.prevElapsedTime = animationPlayer.prevElapsedTime;
        this.exceedTime = animationPlayer.exceedTime;
        this.isEnd = animationPlayer.isEnd;
    }

    public void resetPlayer() {
        this.elapsedTime = 0.0f;
        this.prevElapsedTime = 0.0f;
        this.exceedTime = 0.0f;
        this.isEnd = false;
    }

    public void setPlayAnimation(DynamicAnimation animation) {
        if (this.doNotResetNext) {
            this.doNotResetNext = false;
        } else {
            this.resetPlayer();
        }
        this.play = animation;
    }

    public void setEmpty() {
        this.resetPlayer();
        this.play = null;
    }

    public Pose getCurrentPose(LivingData<?> entitydata, float partialTicks) {
        return this.play.getPoseByTime(entitydata, this.prevElapsedTime + (this.elapsedTime - this.prevElapsedTime) * partialTicks);
    }

    public float getElapsedTime() {
        return this.elapsedTime;
    }

    public float getPrevElapsedTime() {
        return this.prevElapsedTime;
    }

    public void setElapsedTime(float elapsedTime) {
        this.elapsedTime = elapsedTime;
        this.prevElapsedTime = elapsedTime;
        this.exceedTime = 0.0f;
        this.isEnd = false;
    }

    public DynamicAnimation getPlay() {
        return this.play;
    }

    public float getExceedTime() {
        return this.exceedTime;
    }

    public void markNoReset() {
        this.doNotResetNext = true;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public boolean isEmpty() {
        return this.play == null;
    }
}

