/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation;

import maninhouse.epicfight.animation.AnimationPlayer;
import maninhouse.epicfight.animation.Joint;
import maninhouse.epicfight.animation.JointTransform;
import maninhouse.epicfight.animation.Pose;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;

public abstract class Animator {
    protected LivingData<?> entitydata;

    public abstract void playAnimation(int var1, float var2);

    public abstract void playAnimation(StaticAnimation var1, float var2);

    public abstract void vacateCurrentPlay();

    public abstract void update();

    public abstract void onEntityDeath();

    public abstract AnimationPlayer getPlayer();

    public abstract void reserveAnimation(StaticAnimation var1);

    public abstract AnimationPlayer getPlayerFor(StaticAnimation var1);

    public boolean isReverse() {
        return false;
    }

    public void playDeathAnimation() {
        this.playAnimation(Animations.BIPED_DEATH, 0.0f);
    }

    public VisibleMatrix4f getJointTransformByIndex(Pose pose, Joint joint, VisibleMatrix4f parentTransform, int indexer) {
        JointTransform jt = pose.getTransformByName(joint.getName());
        VisibleMatrix4f currentLocalTransform = jt.toTransformMatrix();
        VisibleMatrix4f.mul(joint.getLocalTrasnform(), currentLocalTransform, currentLocalTransform);
        VisibleMatrix4f bindTransform = VisibleMatrix4f.mul(parentTransform, currentLocalTransform, null);
        VisibleMatrix4f.mul(bindTransform, joint.getAnimatedTransform(), bindTransform);
        indexer >>= 5;
        if (jt.getCustomRotation() != null) {
            float x = bindTransform.m30;
            float y = bindTransform.m31;
            float z = bindTransform.m32;
            bindTransform.m30 = 0.0f;
            bindTransform.m31 = 0.0f;
            bindTransform.m32 = 0.0f;
            VisibleMatrix4f.mul(jt.getCustomRotation().toRotationMatrix(), bindTransform, bindTransform);
            bindTransform.m30 = x;
            bindTransform.m31 = y;
            bindTransform.m32 = z;
        }
        if (indexer == 0) {
            return bindTransform;
        }
        return this.getJointTransformByIndex(pose, joint.getSubJoints().get((indexer & 0x1F) - 1), bindTransform, indexer);
    }
}

