/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation;

import maninhouse.epicfight.animation.Quaternion;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;

public class JointTransform {
    public static final JointTransform defaultTransform = new JointTransform(new Vec3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, 1.0f), new Vec3f(1.0f, 1.0f, 1.0f));
    private Vec3f position;
    private Vec3f scale;
    private Quaternion rotation;
    private Quaternion customRotation;

    public JointTransform(Vec3f position, Quaternion rotation, Vec3f scale) {
        this.position = position;
        this.rotation = rotation;
        this.scale = scale;
    }

    public JointTransform(Vec3f position, Quaternion rotation, Quaternion customRotation, Vec3f scale) {
        this.position = position;
        this.rotation = rotation;
        this.scale = scale;
        this.customRotation = customRotation;
    }

    public Vec3f getPosition() {
        return this.position;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public Quaternion getCustomRotation() {
        return this.customRotation;
    }

    public Vec3f getScale() {
        return this.scale;
    }

    public void setRotation(Quaternion quat) {
        this.rotation = quat;
    }

    public void setCustomRotation(Quaternion quat) {
        this.customRotation = quat;
    }

    public VisibleMatrix4f toTransformMatrix() {
        VisibleMatrix4f matrix = new VisibleMatrix4f();
        matrix.translate(this.position);
        VisibleMatrix4f.mul(matrix, this.rotation.toRotationMatrix(), matrix);
        matrix.scale(this.scale);
        return matrix;
    }

    public static JointTransform interpolate(JointTransform prev, JointTransform next, float progression) {
        if (prev == null || next == null) {
            return defaultTransform;
        }
        Vec3f pos = JointTransform.interpolate(prev.position, next.position, progression);
        Quaternion rot = Quaternion.interpolate(prev.rotation, next.rotation, progression);
        Vec3f scale = JointTransform.interpolate(prev.scale, next.scale, progression);
        if (prev.customRotation != null || next.customRotation != null) {
            if (prev.customRotation == null) {
                prev.customRotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
            }
            if (next.customRotation == null) {
                next.customRotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
            }
            return new JointTransform(pos, rot, Quaternion.interpolate(prev.customRotation, next.customRotation, progression), scale);
        }
        return new JointTransform(pos, rot, scale);
    }

    private static Vec3f interpolate(Vec3f start, Vec3f end, float progression) {
        float x = start.x + (end.x - start.x) * progression;
        float y = start.y + (end.y - start.y) * progression;
        float z = start.z + (end.z - start.z) * progression;
        return new Vec3f(x, y, z);
    }
}

