/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation.types;

import javax.annotation.Nullable;
import maninhouse.epicfight.animation.Pose;
import maninhouse.epicfight.animation.property.Property;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.animation.types.LinkAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.physics.Collider;
import net.minecraft.util.Hand;

public class AAAnimation
extends AttackAnimation {
    public AAAnimation(int id, float convertTime, float antic, float contact, float recovery, @Nullable Collider collider, String index, String path) {
        this(id, convertTime, antic, antic, contact, recovery, collider, index, path);
    }

    public AAAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, String index, String path) {
        super(id, convertTime, antic, preDelay, contact, recovery, false, collider, index, path);
        this.addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true));
    }

    public AAAnimation(int id, float convertTime, float antic, float contact, float recovery, Hand hand, @Nullable Collider collider, String index, String path) {
        super(id, convertTime, antic, antic, contact, recovery, false, hand, collider, index, path);
        this.addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true));
    }

    public AAAnimation(int id, float convertTime, boolean affectY, String path, AttackAnimation.Phase ... phases) {
        super(id, convertTime, affectY, path, phases);
        this.addProperty(Property.AnimationProperty.DIRECTIONAL, Boolean.valueOf(true));
    }

    @Override
    public float getPlaySpeed(LivingData<?> entitydata) {
        if (entitydata instanceof PlayerData) {
            return this.totalTime * ((PlayerData)entitydata).getAttackSpeed();
        }
        return 1.0f;
    }

    @Override
    public void getLinkAnimation(Pose pose1, float timeModifier, LivingData<?> entitydata, LinkAnimation dest) {
        float extTime = Math.max(this.convertTime + timeModifier, 0.0f);
        if (entitydata instanceof PlayerData) {
            PlayerData playerdata = (PlayerData)entitydata;
            extTime *= this.totalTime * playerdata.getAttackSpeed();
        }
        extTime = Math.max(extTime - this.convertTime, 0.0f);
        super.getLinkAnimation(pose1, extTime, entitydata, dest);
    }
}

