/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation.types;

import java.util.Map;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.JointKeyframe;
import maninhouse.epicfight.animation.JointTransform;
import maninhouse.epicfight.animation.Pose;
import maninhouse.epicfight.animation.TransformSheet;
import maninhouse.epicfight.animation.types.DynamicAnimation;
import maninhouse.epicfight.animation.types.EntityState;
import maninhouse.epicfight.animation.types.ImmovableAnimation;
import maninhouse.epicfight.animation.types.LinkAnimation;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.entity.eventlistener.EntityEventListener;
import maninhouse.epicfight.entity.eventlistener.PlayerActionEvent;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.Vec4f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class ActionAnimation
extends ImmovableAnimation {
    protected final boolean breakMovement;
    protected final boolean affectYCoord;
    protected float delayTime;

    public ActionAnimation(int id, float convertTime, boolean breakMove, boolean affectY, String path) {
        this(id, convertTime, -1.0f, breakMove, affectY, path);
    }

    public ActionAnimation(int id, float convertTime, float postDelay, boolean breakMove, boolean affectY, String path) {
        super(id, convertTime, path);
        this.breakMovement = breakMove;
        this.affectYCoord = affectY;
        this.delayTime = postDelay;
    }

    @Override
    public void onActivate(LivingData<?> entity) {
        super.onActivate(entity);
        Object orgEntity = entity.getOriginalEntity();
        float yaw = ((Entity)orgEntity).field_70177_z;
        orgEntity.func_70034_d(yaw);
        orgEntity.func_181013_g(yaw);
        if (this.breakMovement) {
            entity.getOriginalEntity().func_213293_j(0.0, orgEntity.func_213322_ci().field_72448_b, 0.0);
        }
        if (entity instanceof ServerPlayerData) {
            ServerPlayerData playerdata = (ServerPlayerData)entity;
            playerdata.getEventListener().activateEvents(EntityEventListener.EventType.ACTION_EVENT, new PlayerActionEvent(playerdata));
        }
    }

    @Override
    public void onUpdate(LivingData<?> entitydata) {
        super.onUpdate(entitydata);
        this.move(entitydata, this);
    }

    @Override
    public void updateOnLinkAnimation(LivingData<?> entitydata, LinkAnimation linkAnimation) {
        this.move(entitydata, linkAnimation);
    }

    private void move(LivingData<?> entitydata, DynamicAnimation animation) {
        Object livingentity = entitydata.getOriginalEntity();
        if (entitydata.isRemote() ? !(livingentity instanceof ClientPlayerEntity) : livingentity instanceof ServerPlayerEntity) {
            return;
        }
        if (entitydata.isInaction()) {
            Vec3f vec3 = this.getCoordVector(entitydata, animation);
            BlockPos blockpos = new BlockPos(livingentity.func_226277_ct_(), livingentity.func_174813_aQ().field_72338_b - 1.0, livingentity.func_226281_cx_());
            BlockState blockState = ((LivingEntity)livingentity).field_70170_p.func_180495_p(blockpos);
            ModifiableAttributeInstance attribute = livingentity.func_110148_a(Attributes.field_233821_d_);
            boolean soulboost = blockState.func_235714_a_((ITag)BlockTags.field_232876_aq_) && EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_234847_l_, livingentity) > 0;
            double speedFactor = soulboost ? 1.0 : (double)((LivingEntity)livingentity).field_70170_p.func_180495_p(blockpos).func_177230_c().func_226891_m_();
            double moveMultiplier = attribute.func_111126_e() / attribute.func_111125_b() * speedFactor;
            livingentity.func_213315_a(MoverType.SELF, new Vector3d((double)vec3.x * moveMultiplier, (double)vec3.y, (double)vec3.z * moveMultiplier));
        }
    }

    @Override
    public EntityState getState(float time) {
        if (time < this.delayTime) {
            return EntityState.PRE_DELAY;
        }
        return EntityState.FREE;
    }

    @Override
    public Pose getPoseByTime(DynamicAnimation animation, LivingData<?> entitydata, float time) {
        Pose pose = new Pose();
        for (String jointName : animation.jointTransforms.keySet()) {
            JointTransform jt = animation.jointTransforms.get(jointName).getInterpolatedTransform(time);
            if (jointName.equals("Root")) {
                Vec3f vec = jt.getPosition();
                vec.x = 0.0f;
                vec.y = this.affectYCoord && vec.y > 0.0f ? 0.0f : vec.y;
                vec.z = 0.0f;
            }
            pose.putJointData(jointName, jt);
        }
        return pose;
    }

    @Override
    public StaticAnimation bindFull(Armature armature) {
        super.bindFull(armature);
        if (this.delayTime < 0.0f) {
            this.delayTime = this.totalTime;
        }
        return this;
    }

    @Override
    public void getLinkAnimation(Pose pose1, float timeModifier, LivingData<?> entitydata, LinkAnimation dest) {
        float nextStart;
        float totalTime = timeModifier > 0.0f ? timeModifier + this.convertTime : this.convertTime;
        float updatePerTicks = this.getPlaySpeed(entitydata) * 0.05f;
        for (nextStart = 0.0f; nextStart < totalTime; nextStart += updatePerTicks) {
        }
        nextStart -= totalTime;
        if (timeModifier < 0.0f) {
            dest.startsAt = nextStart -= timeModifier;
        }
        dest.getTransfroms().clear();
        dest.setTotalTime(totalTime);
        dest.setNextAnimation(this);
        Map<String, JointTransform> data1 = pose1.getJointTransformData();
        Pose startPose = new Pose();
        for (String jointName : this.jointTransforms.keySet()) {
            startPose.putJointData(jointName, ((TransformSheet)this.jointTransforms.get(jointName)).getInterpolatedTransform(nextStart));
        }
        Map<String, JointTransform> data2 = startPose.getJointTransformData();
        for (String jointName : data1.keySet()) {
            JointKeyframe[] keyframes = new JointKeyframe[]{new JointKeyframe(0.0f, data1.get(jointName)), new JointKeyframe(totalTime, data2.get(jointName))};
            TransformSheet sheet = new TransformSheet(keyframes);
            dest.addSheet(jointName, sheet);
        }
    }

    protected Vec3f getCoordVector(LivingData<?> entitydata, DynamicAnimation animation) {
        if (animation.jointTransforms.containsKey("Root")) {
            Object elb = entitydata.getOriginalEntity();
            JointTransform jt = animation.jointTransforms.get("Root").getInterpolatedTransform(((Animator)entitydata.getAnimator()).getPlayer().getElapsedTime());
            JointTransform prevJt = animation.jointTransforms.get("Root").getInterpolatedTransform(((Animator)entitydata.getAnimator()).getPlayer().getPrevElapsedTime());
            Vec4f currentPos = new Vec4f(jt.getPosition().x, jt.getPosition().y, jt.getPosition().z, 1.0f);
            Vec4f prevPos = new Vec4f(prevJt.getPosition().x, prevJt.getPosition().y, prevJt.getPosition().z, 1.0f);
            VisibleMatrix4f mat = entitydata.getModelMatrix(1.0f);
            mat.m30 = 0.0f;
            mat.m31 = 0.0f;
            mat.m32 = 0.0f;
            VisibleMatrix4f.transform(mat, currentPos, currentPos);
            VisibleMatrix4f.transform(mat, prevPos, prevPos);
            boolean hasNoGravity = entitydata.getOriginalEntity().func_189652_ae();
            float dx = prevPos.x - currentPos.x;
            float dy = this.affectYCoord && currentPos.y > 0.0f || hasNoGravity ? currentPos.y - prevPos.y : 0.0f;
            float dz = prevPos.z - currentPos.z;
            if (this.affectYCoord && currentPos.y > 0.0f && !hasNoGravity) {
                Vector3d motion = elb.func_213322_ci();
                elb.func_213293_j(motion.field_72450_a, motion.field_72448_b + 0.08, motion.field_72449_c);
            }
            return new Vec3f(dx, dy, dz);
        }
        return new Vec3f(0.0f, 0.0f, 0.0f);
    }
}

