/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation.types;

import maninhouse.epicfight.animation.AnimationPlayer;
import maninhouse.epicfight.animation.JointTransform;
import maninhouse.epicfight.animation.Pose;
import maninhouse.epicfight.animation.Quaternion;
import maninhouse.epicfight.animation.TransformSheet;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.collada.AnimationDataExtractor;
import maninhouse.epicfight.model.Armature;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class AimingAnimation
extends StaticAnimation {
    public StaticAnimation lookUp;
    public StaticAnimation lookDown;

    public AimingAnimation(int id, float convertTime, boolean repeatPlay, String path1, String path2, String path3) {
        super(id, convertTime, repeatPlay, path1);
        this.lookUp = new StaticAnimation(path2);
        this.lookDown = new StaticAnimation(path3);
    }

    @Override
    public void onUpdate(LivingData<?> entitydata) {
        AnimationPlayer player;
        super.onUpdate(entitydata);
        AnimatorClient animator = entitydata.getClientAnimator();
        if (animator.mixLayerActivated && (player = animator.getMixLayerPlayer()).getElapsedTime() >= this.totalTime - 0.06f) {
            animator.mixLayer.pause = true;
        }
    }

    @Override
    public Pose getPoseByTime(LivingData<?> entitydata, float time) {
        if (entitydata.isFirstPerson()) {
            return super.getPoseByTime(entitydata, time);
        }
        float pitch = entitydata.getOriginalEntity().func_195050_f(Minecraft.func_71410_x().func_184121_ak());
        StaticAnimation interpolateAnimation = pitch > 0.0f ? this.lookDown : this.lookUp;
        Pose pose1 = this.getPoseByTime(time);
        Pose pose2 = interpolateAnimation.getPoseByTime(entitydata, time);
        Pose interpolatedPose = Pose.interpolatePose(pose1, pose2, Math.abs(pitch) / 90.0f);
        JointTransform chest = interpolatedPose.getTransformByName("Chest");
        JointTransform head = interpolatedPose.getTransformByName("Head");
        float f = 90.0f;
        float ratio = (f - Math.abs(((LivingEntity)entitydata.getOriginalEntity()).field_70125_A)) / f;
        float yawOffset = entitydata.getOriginalEntity().func_184187_bx() != null ? ((LivingEntity)entitydata.getOriginalEntity()).field_70177_z : ((LivingEntity)entitydata.getOriginalEntity()).field_70761_aq;
        head.setRotation(Quaternion.rotate((float)(-Math.toRadians((yawOffset - ((LivingEntity)entitydata.getOriginalEntity()).field_70177_z) * ratio)), new Vec3f(0.0f, 1.0f, 0.0f), head.getRotation()));
        chest.setCustomRotation(Quaternion.rotate((float)(-Math.toRadians((((LivingEntity)entitydata.getOriginalEntity()).field_70177_z - yawOffset) * ratio)), new Vec3f(0.0f, 1.0f, 0.0f), null));
        return interpolatedPose;
    }

    private Pose getPoseByTime(float time) {
        Pose pose = new Pose();
        for (String jointName : this.jointTransforms.keySet()) {
            pose.putJointData(jointName, ((TransformSheet)this.jointTransforms.get(jointName)).getInterpolatedTransform(time));
        }
        return pose;
    }

    @Override
    public StaticAnimation bindFull(Armature armature) {
        if (this.animationDataPath != null) {
            AnimationDataExtractor.extractAnimation(new ResourceLocation("epicfight", this.animationDataPath), this, armature);
            this.animationDataPath = null;
            AnimationDataExtractor.extractAnimation(new ResourceLocation("epicfight", this.lookUp.animationDataPath), this.lookUp, armature);
            this.lookUp.animationDataPath = null;
            AnimationDataExtractor.extractAnimation(new ResourceLocation("epicfight", this.lookDown.animationDataPath), this.lookDown, armature);
            this.lookDown.animationDataPath = null;
        }
        return this;
    }
}

