/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation.types;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.JointTransform;
import maninhouse.epicfight.animation.Pose;
import maninhouse.epicfight.animation.Quaternion;
import maninhouse.epicfight.animation.property.Property;
import maninhouse.epicfight.animation.types.ActionAnimation;
import maninhouse.epicfight.animation.types.DynamicAnimation;
import maninhouse.epicfight.animation.types.EntityState;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.MobData;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.entity.eventlistener.EntityEventListener;
import maninhouse.epicfight.entity.eventlistener.PlayerAttackEndEvent;
import maninhouse.epicfight.entity.eventlistener.PlayerDealtDamageEvent;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.utils.game.AttackResult;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.ExtraDamageCalculator;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fml.RegistryObject;

public class AttackAnimation
extends ActionAnimation {
    protected final Map<Property.AnimationProperty<?>, Object> properties = new HashMap();
    public final Phase[] phases;

    public AttackAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, boolean affectY, @Nullable Collider collider, String index, String path) {
        this(id, convertTime, affectY, path, new Phase(antic, preDelay, contact, recovery, index, collider));
    }

    public AttackAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, boolean affectY, Hand hand, @Nullable Collider collider, String index, String path) {
        this(id, convertTime, affectY, path, new Phase(antic, preDelay, contact, recovery, hand, index, collider));
    }

    public AttackAnimation(int id, float convertTime, boolean affectY, String path, Phase ... phases) {
        super(id, convertTime, true, affectY, path);
        this.phases = phases;
    }

    @Override
    public void onUpdate(LivingData<?> entitydata) {
        block7: {
            Phase phase;
            EntityState prevState;
            EntityState state;
            float prevElapsedTime;
            float elapsedTime;
            block8: {
                super.onUpdate(entitydata);
                if (entitydata.isRemote()) break block7;
                elapsedTime = ((Animator)entitydata.getAnimator()).getPlayer().getElapsedTime();
                prevElapsedTime = ((Animator)entitydata.getAnimator()).getPlayer().getPrevElapsedTime();
                state = this.getState(elapsedTime);
                prevState = this.getState(prevElapsedTime);
                phase = this.getPhaseByTime(elapsedTime);
                if (state != EntityState.FREE_CAMERA) break block8;
                if (!(entitydata instanceof MobData)) break block7;
                ((MobEntity)entitydata.getOriginalEntity()).func_70661_as().func_75499_g();
                LivingEntity target = entitydata.getAttackTarget();
                if (target == null) break block7;
                entitydata.rotateTo((Entity)target, 60.0f, false);
                break block7;
            }
            if (state.shouldDetectCollision() || prevState.getLevel() < 2 && state.getLevel() > 2) {
                if (!prevState.shouldDetectCollision()) {
                    entitydata.playSound(this.getSwingSound(entitydata, phase), 0.0f, 0.0f);
                    entitydata.currentlyAttackedEntity.clear();
                }
                Collider collider = this.getCollider(entitydata, elapsedTime);
                Object entity = entitydata.getOriginalEntity();
                entitydata.getEntityModel(Models.LOGICAL_SERVER).getArmature().initializeTransform();
                collider.updateTransform(entitydata, this, prevElapsedTime, elapsedTime, phase.jointIndexer);
                List list = ((LivingEntity)entity).field_70170_p.func_72839_b(entity, collider.getHitboxAABB());
                collider.extractHitEntities(list);
                if (list.size() > 0) {
                    AttackResult attackResult = new AttackResult(entitydata, list, phase.getProperty(Property.PhaseProperty.TARGET_PRIORITY).orElse(AttackResult.Priority.DISTANCE));
                    boolean flag1 = true;
                    int maxStrikes = this.getMaxStrikes(entitydata, phase);
                    while (entitydata.currentlyAttackedEntity.size() < maxStrikes && attackResult.next()) {
                        Entity e = attackResult.getEntity();
                        LivingEntity trueEntity = this.getTrueEntity(e);
                        if (entitydata.currentlyAttackedEntity.contains(trueEntity) || entitydata.isTeam(e) || !(e instanceof LivingEntity) && !(e instanceof PartEntity) || ((LivingEntity)entity).field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(e.func_226277_ct_(), e.func_226278_cu_() + (double)e.func_70047_e(), e.func_226281_cx_()), new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() * 0.5f), entity.func_226281_cx_()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity)).func_216346_c() != RayTraceResult.Type.MISS) continue;
                        IExtendedDamageSource source = this.getDamageSourceExt(entitydata, e, phase);
                        if (entitydata.hurtEntity(e, phase.hand, source, this.getDamageAmount(entitydata, trueEntity, phase))) {
                            if (entitydata instanceof ServerPlayerData) {
                                ServerPlayerData playerdata = (ServerPlayerData)entitydata;
                                playerdata.getEventListener().activateEvents(EntityEventListener.EventType.DEALT_DAMAGE_EVENT, new PlayerDealtDamageEvent(playerdata, trueEntity, source));
                            }
                            e.field_70172_ad = 0;
                            e.field_70170_p.func_184148_a(null, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), this.getHitSound(entitydata, phase), e.func_184176_by(), 1.0f, 1.0f);
                            this.spawnHitParticle((ServerWorld)e.field_70170_p, entitydata, e, phase);
                            if (flag1 && entitydata instanceof PlayerData) {
                                entitydata.getOriginalEntity().func_184586_b(phase.hand).func_77961_a(trueEntity, (PlayerEntity)((PlayerData)entitydata).getOriginalEntity());
                                flag1 = false;
                            }
                        }
                        entitydata.currentlyAttackedEntity.add(trueEntity);
                    }
                }
            }
        }
    }

    @Override
    public void onFinish(LivingData<?> entitydata, boolean isEnd) {
        MobEntity entity;
        super.onFinish(entitydata, isEnd);
        if (entitydata instanceof ServerPlayerData && isEnd) {
            ServerPlayerData playerdata = (ServerPlayerData)entitydata;
            playerdata.getEventListener().activateEvents(EntityEventListener.EventType.ATTACK_ANIMATION_END_EVENT, new PlayerAttackEndEvent(playerdata, entitydata.currentlyAttackedEntity, this.getId()));
        }
        entitydata.currentlyAttackedEntity.clear();
        if (entitydata instanceof BipedMobData && entitydata.isRemote() && (entity = (MobEntity)entitydata.getOriginalEntity()).func_70638_az() != null && !entity.func_70638_az().func_70089_S()) {
            entity.func_70624_b((LivingEntity)null);
        }
    }

    @Override
    public EntityState getState(float time) {
        Phase phase = this.getPhaseByTime(time);
        boolean lockCameraRotation = this.getProperty(Property.AnimationProperty.LOCK_ROTATION).orElse(false);
        if (phase.antic >= time) {
            return EntityState.FREE_CAMERA;
        }
        if (phase.antic < time && phase.preDelay > time) {
            return EntityState.FREE_CAMERA;
        }
        if (phase.preDelay <= time && phase.contact >= time) {
            return lockCameraRotation ? EntityState.CONTACT : EntityState.ROTATABLE_CONTACT;
        }
        if (phase.recovery > time) {
            return lockCameraRotation ? EntityState.POST_DELAY : EntityState.ROTATABLE_POST_DELAY;
        }
        return EntityState.POST_FREE;
    }

    @Override
    protected Vec3f getCoordVector(LivingData<?> entitydata, DynamicAnimation dynamicAnimation) {
        EntityState state;
        Vec3f vec3 = super.getCoordVector(entitydata, dynamicAnimation);
        if (!this.getProperty(Property.AnimationProperty.FIXED_MOVE_DISTANCE).isPresent() && (state = this.getState(((Animator)entitydata.getAnimator()).getPlayer().getElapsedTime())).getLevel() < 3) {
            float multiplier;
            Object orgEntity = entitydata.getOriginalEntity();
            LivingEntity target = entitydata.getAttackTarget();
            float f = multiplier = orgEntity instanceof PlayerEntity ? 2.0f : 1.0f;
            if (target != null) {
                float distance = Math.max(Math.min(orgEntity.func_70032_d((Entity)target) - (orgEntity.func_213311_cf() + target.func_213311_cf()) * 0.8f, multiplier), 0.0f);
                vec3.x *= distance;
                vec3.z *= distance;
            }
        }
        return vec3;
    }

    public Collider getCollider(LivingData<?> entitydata, float elapsedTime) {
        Phase phase = this.getPhaseByTime(elapsedTime);
        return phase.collider != null ? phase.collider : entitydata.getColliderMatching(phase.hand);
    }

    public LivingEntity getTrueEntity(Entity entity) {
        Entity parentEntity;
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        if (entity instanceof PartEntity && (parentEntity = ((PartEntity)entity).getParent()) instanceof LivingEntity) {
            return (LivingEntity)parentEntity;
        }
        return null;
    }

    protected int getMaxStrikes(LivingData<?> entitydata, Phase phase) {
        return phase.getProperty(Property.PhaseProperty.MAX_STRIKES).map(valueCorrector -> Float.valueOf(valueCorrector.get(entitydata.getHitEnemies(phase.hand)))).orElse(new Float(entitydata.getHitEnemies(phase.hand))).intValue();
    }

    protected float getDamageAmount(LivingData<?> entitydata, LivingEntity target, Phase phase) {
        float totalDamage = phase.getProperty(Property.PhaseProperty.DAMAGE).map(valueCorrector -> Float.valueOf(valueCorrector.get(entitydata.getDamageToEntity((Entity)target, phase.hand)))).orElse(new Float(entitydata.getDamageToEntity((Entity)target, phase.hand))).floatValue();
        ExtraDamageCalculator extraCalculator = phase.getProperty(Property.PhaseProperty.EXTRA_DAMAGE).orElse(null);
        if (extraCalculator != null) {
            totalDamage += extraCalculator.get((LivingEntity)entitydata.getOriginalEntity(), target);
        }
        return totalDamage;
    }

    protected SoundEvent getSwingSound(LivingData<?> entitydata, Phase phase) {
        return phase.getProperty(Property.PhaseProperty.SWING_SOUND).orElse(entitydata.getSwingSound(phase.hand));
    }

    protected SoundEvent getHitSound(LivingData<?> entitydata, Phase phase) {
        return phase.getProperty(Property.PhaseProperty.HIT_SOUND).orElse(entitydata.getWeaponHitSound(phase.hand));
    }

    protected IExtendedDamageSource getDamageSourceExt(LivingData<?> entitydata, Entity target, Phase phase) {
        IExtendedDamageSource.DamageType dmgType = phase.getProperty(Property.PhaseProperty.DAMAGE_TYPE).orElse(IExtendedDamageSource.DamageType.PHYSICAL);
        IExtendedDamageSource.StunType stunType = phase.getProperty(Property.PhaseProperty.STUN_TYPE).orElse(IExtendedDamageSource.StunType.SHORT);
        IExtendedDamageSource extDmgSource = entitydata.getDamageSource(stunType, dmgType, this.getId(), phase.hand);
        phase.getProperty(Property.PhaseProperty.ARMOR_NEGATION).ifPresent(opt -> extDmgSource.setArmorNegation(opt.get(extDmgSource.getArmorNegation())));
        phase.getProperty(Property.PhaseProperty.IMPACT).ifPresent(opt -> extDmgSource.setImpact(opt.get(extDmgSource.getImpact())));
        return extDmgSource;
    }

    protected void spawnHitParticle(ServerWorld world, LivingData<?> attacker, Entity hit, Phase phase) {
        Optional<RegistryObject<HitParticleType>> particleOptional = phase.getProperty(Property.PhaseProperty.PARTICLE);
        HitParticleType particle = particleOptional.isPresent() ? (HitParticleType)particleOptional.get().get() : attacker.getWeaponHitParticle(phase.hand);
        particle.spawnParticleWithArgument(world, null, null, hit, (Entity)attacker.getOriginalEntity());
    }

    @Override
    public Pose getPoseByTime(LivingData<?> entitydata, float time) {
        Pose pose = super.getPoseByTime(entitydata, time);
        this.getProperty(Property.AnimationProperty.DIRECTIONAL).ifPresent(b -> {
            float pitch = entitydata.getAttackDirectionPitch();
            JointTransform chest = pose.getTransformByName("Chest");
            chest.setCustomRotation(Quaternion.rotate((float)Math.toRadians(pitch), new Vec3f(1.0f, 0.0f, 0.0f), null));
            if (entitydata instanceof PlayerData) {
                JointTransform head = pose.getTransformByName("Head");
                head.setRotation(Quaternion.rotate((float)(-Math.toRadians(pitch)), new Vec3f(1.0f, 0.0f, 0.0f), head.getRotation()));
            }
        });
        return pose;
    }

    public <V> AttackAnimation addProperty(Property.AnimationProperty<V> propertyType, V value) {
        this.properties.put(propertyType, value);
        return this;
    }

    public <V> AttackAnimation addProperty(Property.PhaseProperty<V> propertyType, V value) {
        return this.addProperty(propertyType, value, 0);
    }

    public <V> AttackAnimation addProperty(Property.PhaseProperty<V> propertyType, V value, int index) {
        this.phases[index].addProperty(propertyType, value);
        return this;
    }

    protected <V> Optional<V> getProperty(Property.AnimationProperty<V> propertyType) {
        return Optional.ofNullable(this.properties.get(propertyType));
    }

    public int getIndexer(float elapsedTime) {
        return this.getPhaseByTime((float)elapsedTime).jointIndexer;
    }

    public Phase getPhaseByTime(float elapsedTime) {
        Phase currentPhase = null;
        Phase[] phaseArray = this.phases;
        int n = phaseArray.length;
        for (int i = 0; i < n; ++i) {
            Phase phase;
            currentPhase = phase = phaseArray[i];
            if (phase.recovery > elapsedTime) break;
        }
        return currentPhase;
    }

    @Deprecated
    public void changeCollider(Collider newCollider, int index) {
        this.phases[index].collider = newCollider;
    }

    public static class Phase {
        protected final Map<Property.PhaseProperty<?>, Object> properties = new HashMap();
        protected final float antic;
        protected final float preDelay;
        protected final float contact;
        protected final float recovery;
        protected final int jointIndexer;
        protected final Hand hand;
        protected Collider collider;

        public Phase(float antic, float preDelay, float contact, float recovery, String indexer, Collider collider) {
            this(antic, preDelay, contact, recovery, Hand.MAIN_HAND, indexer, collider);
        }

        public Phase(float antic, float preDelay, float contact, float recovery, Hand hand, String indexer, Collider collider) {
            this.antic = antic;
            this.preDelay = preDelay;
            this.contact = contact;
            this.recovery = recovery;
            this.collider = collider;
            this.hand = hand;
            int coded = 0;
            if (indexer.length() == 0) {
                this.jointIndexer = -1;
            } else {
                for (int i = 0; i < indexer.length(); ++i) {
                    int value = indexer.charAt(i) - 48;
                    coded |= value;
                    coded <<= 5;
                }
                this.jointIndexer = coded;
            }
        }

        public <V> Phase addProperty(Property.PhaseProperty<V> propertyType, V value) {
            this.properties.put(propertyType, value);
            return this;
        }

        public void addProperties(Set<Map.Entry<Property.PhaseProperty<?>, Object>> set) {
            for (Map.Entry<Property.PhaseProperty<?>, Object> entry : set) {
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }

        protected <V> Optional<V> getProperty(Property.PhaseProperty<V> propertyType) {
            return Optional.ofNullable(this.properties.get(propertyType));
        }
    }
}

