/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation.types;

import maninhouse.epicfight.animation.types.ActionAnimation;
import maninhouse.epicfight.animation.types.EntityState;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.utils.math.Formulars;
import net.minecraft.entity.EntitySize;

public class DodgingAnimation
extends ActionAnimation {
    private final EntitySize size;

    public DodgingAnimation(int id, float convertTime, boolean affectVelocity, String path, float width, float height) {
        this(id, convertTime, 0.0f, affectVelocity, path, width, height);
    }

    public DodgingAnimation(int id, float convertTime, float delayTime, boolean affectVelocity, String path, float width, float height) {
        super(id, convertTime, delayTime, affectVelocity, false, path);
        this.size = width > 0.0f || height > 0.0f ? EntitySize.func_220314_b((float)width, (float)height) : null;
    }

    @Override
    public void onUpdate(LivingData<?> entitydata) {
        super.onUpdate(entitydata);
        if (this.size != null) {
            entitydata.resetSize(this.size);
        }
    }

    @Override
    public void onFinish(LivingData<?> entitydata, boolean isEnd) {
        super.onFinish(entitydata, isEnd);
        if (this.size != null) {
            entitydata.getOriginalEntity().func_213323_x_();
        }
    }

    @Override
    public float getPlaySpeed(LivingData<?> entitydata) {
        return Formulars.getRollAnimationSpeedPenalty((float)entitydata.getWeight(), entitydata);
    }

    @Override
    public EntityState getState(float time) {
        if (time < this.delayTime) {
            return EntityState.PRE_DELAY;
        }
        return EntityState.DODGE;
    }
}

