/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation.types;

import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.Pose;
import maninhouse.epicfight.animation.types.DynamicAnimation;
import maninhouse.epicfight.animation.types.EntityState;
import maninhouse.epicfight.capabilities.entity.LivingData;

public class LinkAnimation
extends DynamicAnimation {
    protected DynamicAnimation nextAnimation;
    protected float startsAt;

    @Override
    public void onUpdate(LivingData<?> entitydata) {
        this.nextAnimation.updateOnLinkAnimation(entitydata, this);
    }

    @Override
    public void onFinish(LivingData<?> entitydata, boolean isEnd) {
        if (!isEnd) {
            this.nextAnimation.onFinish(entitydata, isEnd);
        } else if (this.startsAt > 0.0f) {
            ((Animator)entitydata.getAnimator()).getPlayer().setElapsedTime(this.startsAt);
            ((Animator)entitydata.getAnimator()).getPlayer().markNoReset();
            this.startsAt = 0.0f;
        }
    }

    @Override
    public Pose getPoseByTime(DynamicAnimation animation, LivingData<?> entitydata, float time) {
        return this.nextAnimation.getPoseByTime(this, entitydata, time);
    }

    @Override
    public EntityState getState(float time) {
        return this.nextAnimation.getState(0.0f);
    }

    @Override
    public float getPlaySpeed(LivingData<?> entitydata) {
        return this.nextAnimation.getPlaySpeed(entitydata);
    }

    public void setNextAnimation(DynamicAnimation animation) {
        this.nextAnimation = animation;
    }

    public DynamicAnimation getNextAnimation() {
        return this.nextAnimation;
    }

    public String toString() {
        return "NextAnimation " + this.nextAnimation;
    }
}

