/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation.types;

import javax.annotation.Nullable;
import maninhouse.epicfight.animation.property.Property;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.utils.math.ExtraDamageCalculator;
import maninhouse.epicfight.utils.math.ValueCorrector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;

public class SpecialAttackAnimation
extends AttackAnimation {
    public SpecialAttackAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, boolean affectY, @Nullable Collider collider, String index, String path) {
        this(id, convertTime, affectY, path, new AttackAnimation.Phase(antic, preDelay, contact, recovery, index, collider));
    }

    public SpecialAttackAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, boolean affectY, Hand hand, @Nullable Collider collider, String index, String path) {
        this(id, convertTime, affectY, path, new AttackAnimation.Phase(antic, preDelay, contact, recovery, hand, index, collider));
    }

    public SpecialAttackAnimation(int id, float convertTime, boolean affectY, String path, AttackAnimation.Phase ... phases) {
        super(id, convertTime, affectY, path, phases);
    }

    @Override
    protected float getDamageAmount(LivingData<?> entitydata, LivingEntity target, AttackAnimation.Phase phase) {
        float f = entitydata.getDamageToEntity((Entity)target, phase.hand);
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_191530_r, entitydata.getOriginalEntity());
        ValueCorrector cor = new ValueCorrector(0.0f, i > 0 ? (float)i / ((float)i + 1.0f) : 0.0f, 0.0f);
        phase.getProperty(Property.PhaseProperty.DAMAGE).ifPresent(opt -> cor.merge((ValueCorrector)opt));
        float totalDamage = cor.get(f);
        ExtraDamageCalculator extraCalculator = phase.getProperty(Property.PhaseProperty.EXTRA_DAMAGE).orElse(null);
        if (extraCalculator != null) {
            totalDamage += extraCalculator.get((LivingEntity)entitydata.getOriginalEntity(), target);
        }
        return totalDamage;
    }
}

