/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.animation.types;

import com.google.common.collect.Lists;
import java.util.List;
import maninhouse.epicfight.animation.AnimationPlayer;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.types.DynamicAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.collada.AnimationDataExtractor;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.model.Armature;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;

public class StaticAnimation
extends DynamicAnimation {
    protected String animationDataPath;
    protected final int animationId;
    public List<SoundKey> soundStream;

    public StaticAnimation() {
        this.animationId = -1;
    }

    public StaticAnimation(int id, float convertTime, boolean isRepeat, String path) {
        super(convertTime, isRepeat);
        if (Animations.animationTable.keySet().contains(id)) {
            System.err.println("[ModError] : Duplicated Animation Key " + id);
        }
        this.animationDataPath = "models/animations/" + path;
        this.totalTime = 0.0f;
        this.animationId = id;
        if (id >= 0) {
            Animations.animationTable.put(id, this);
        }
    }

    public StaticAnimation(String path) {
        this();
        this.animationDataPath = "models/animations/" + path;
    }

    public StaticAnimation(float convertTime, boolean repeatPlay, String path) {
        super(convertTime, repeatPlay);
        this.animationId = -1;
        this.animationDataPath = "models/animations/" + path;
    }

    public StaticAnimation(int id, boolean repeatPlay, String path) {
        this(id, 0.16f, repeatPlay, path);
    }

    public StaticAnimation bindFull(Armature armature) {
        if (this.animationDataPath != null) {
            AnimationDataExtractor.extractAnimation(new ResourceLocation("epicfight", this.animationDataPath), this, armature);
            this.animationDataPath = null;
        }
        if (this.soundStream != null) {
            this.soundStream.sort(null);
        }
        return this;
    }

    public StaticAnimation bindOnlyClient(Armature armature, Dist dist) {
        if (dist == Dist.CLIENT) {
            this.bindFull(armature);
        }
        return this;
    }

    @Override
    public void onUpdate(LivingData<?> entitydata) {
        if (this.soundStream != null) {
            AnimationPlayer player = ((Animator)entitydata.getAnimator()).getPlayerFor(this);
            float prevElapsed = player.getPrevElapsedTime();
            float elapsed = player.getElapsedTime();
            for (SoundKey key : this.soundStream) {
                if (key.time < prevElapsed || key.time >= elapsed || entitydata.isRemote() != key.isRemote) continue;
                entitydata.playSound(key.sound, 0.0f, 0.0f);
            }
        }
    }

    @Override
    public int getId() {
        return this.animationId;
    }

    public StaticAnimation registerSound(float time, SoundEvent sound, boolean isRemote) {
        if (this.soundStream == null) {
            this.soundStream = Lists.newArrayList();
        }
        this.soundStream.add(new SoundKey(time, sound, isRemote));
        return this;
    }

    public String toString() {
        return String.valueOf(this.getId());
    }

    protected static class SoundKey
    implements Comparable<SoundKey> {
        float time;
        SoundEvent sound;
        boolean isRemote;

        protected SoundKey(float time, SoundEvent sound, boolean isRemote) {
            this.time = time;
            this.sound = sound;
            this.isRemote = isRemote;
        }

        @Override
        public int compareTo(SoundKey arg0) {
            if (this.time == arg0.time) {
                return 0;
            }
            return this.time > arg0.time ? 1 : -1;
        }
    }
}

