/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.CapabilityEntity;
import maninhouse.epicfight.capabilities.entity.mob.CaveSpiderData;
import maninhouse.epicfight.capabilities.entity.mob.CreeperData;
import maninhouse.epicfight.capabilities.entity.mob.DrownedData;
import maninhouse.epicfight.capabilities.entity.mob.EndermanData;
import maninhouse.epicfight.capabilities.entity.mob.EvokerData;
import maninhouse.epicfight.capabilities.entity.mob.HoglinData;
import maninhouse.epicfight.capabilities.entity.mob.IronGolemData;
import maninhouse.epicfight.capabilities.entity.mob.PiglinBruteData;
import maninhouse.epicfight.capabilities.entity.mob.PiglinData;
import maninhouse.epicfight.capabilities.entity.mob.PillagerData;
import maninhouse.epicfight.capabilities.entity.mob.RavagerData;
import maninhouse.epicfight.capabilities.entity.mob.SkeletonData;
import maninhouse.epicfight.capabilities.entity.mob.SpiderData;
import maninhouse.epicfight.capabilities.entity.mob.StrayData;
import maninhouse.epicfight.capabilities.entity.mob.VexData;
import maninhouse.epicfight.capabilities.entity.mob.VindicatorData;
import maninhouse.epicfight.capabilities.entity.mob.WitchData;
import maninhouse.epicfight.capabilities.entity.mob.WitherSkeletonData;
import maninhouse.epicfight.capabilities.entity.mob.ZoglinData;
import maninhouse.epicfight.capabilities.entity.mob.ZombieData;
import maninhouse.epicfight.capabilities.entity.mob.ZombieVillagerData;
import maninhouse.epicfight.capabilities.entity.mob.ZombifiedPiglinData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninhouse.epicfight.client.capabilites.entity.RemoteClientPlayerData;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public class ProviderEntity
implements ICapabilityProvider,
NonNullSupplier<CapabilityEntity<?>> {
    private static final Map<EntityType<?>, Function<Entity, Supplier<CapabilityEntity<?>>>> capabilityMap = new HashMap();
    private CapabilityEntity<?> capability;
    private LazyOptional<CapabilityEntity<?>> optional = LazyOptional.of((NonNullSupplier)this);

    public static void makeMap() {
        capabilityMap.put(EntityType.field_200729_aH, entityIn -> ServerPlayerData::new);
        capabilityMap.put(EntityType.field_200725_aD, entityIn -> ZombieData::new);
        capabilityMap.put(EntityType.field_200797_k, entityIn -> CreeperData::new);
        capabilityMap.put(EntityType.field_200803_q, entityIn -> EndermanData::new);
        capabilityMap.put(EntityType.field_200741_ag, entityIn -> SkeletonData::new);
        capabilityMap.put(EntityType.field_200722_aA, entityIn -> WitherSkeletonData::new);
        capabilityMap.put(EntityType.field_200750_ap, entityIn -> StrayData::new);
        capabilityMap.put(EntityType.field_233592_ba_, entityIn -> ZombifiedPiglinData::new);
        capabilityMap.put(EntityType.field_200727_aF, entityIn -> ZombieVillagerData::new);
        capabilityMap.put(EntityType.field_200763_C, entityIn -> ZombieData::new);
        capabilityMap.put(EntityType.field_200748_an, entityIn -> SpiderData::new);
        capabilityMap.put(EntityType.field_200794_h, entityIn -> CaveSpiderData::new);
        capabilityMap.put(EntityType.field_200757_aw, entityIn -> IronGolemData::new);
        capabilityMap.put(EntityType.field_200758_ax, entityIn -> VindicatorData::new);
        capabilityMap.put(EntityType.field_200806_t, entityIn -> EvokerData::new);
        capabilityMap.put(EntityType.field_200759_ay, entityIn -> WitchData::new);
        capabilityMap.put(EntityType.field_204724_o, entityIn -> DrownedData::new);
        capabilityMap.put(EntityType.field_220350_aJ, entityIn -> PillagerData::new);
        capabilityMap.put(EntityType.field_220352_aU, entityIn -> RavagerData::new);
        capabilityMap.put(EntityType.field_200755_au, entityIn -> VexData::new);
        capabilityMap.put(EntityType.field_233591_ai_, entityIn -> PiglinData::new);
        capabilityMap.put(EntityType.field_242287_aj, entityIn -> PiglinBruteData::new);
        capabilityMap.put(EntityType.field_233588_G_, entityIn -> HoglinData::new);
        capabilityMap.put(EntityType.field_233590_aW_, entityIn -> ZoglinData::new);
    }

    public static void makeMapClient() {
        capabilityMap.put(EntityType.field_200729_aH, entityIn -> {
            if (entityIn instanceof ClientPlayerEntity) {
                return ClientPlayerData::new;
            }
            if (entityIn instanceof RemoteClientPlayerEntity) {
                return RemoteClientPlayerData::new;
            }
            if (entityIn instanceof ServerPlayerEntity) {
                return ServerPlayerData::new;
            }
            return () -> null;
        });
    }

    public ProviderEntity(Entity entity) {
        if (capabilityMap.containsKey(entity.func_200600_R())) {
            this.capability = capabilityMap.get(entity.func_200600_R()).apply(entity).get();
        }
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    public CapabilityEntity<?> get() {
        return this.capability;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == ModCapabilities.CAPABILITY_ENTITY ? this.optional.cast() : LazyOptional.empty();
    }
}

