/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.item.ArmorCapability;
import maninhouse.epicfight.capabilities.item.AxeCapability;
import maninhouse.epicfight.capabilities.item.BowCapability;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.capabilities.item.CrossbowCapability;
import maninhouse.epicfight.capabilities.item.HoeCapability;
import maninhouse.epicfight.capabilities.item.PickaxeCapability;
import maninhouse.epicfight.capabilities.item.ShovelCapability;
import maninhouse.epicfight.capabilities.item.SwordCapability;
import maninhouse.epicfight.capabilities.item.TridentCapability;
import maninhouse.epicfight.capabilities.item.VanillaArmorCapability;
import maninhouse.epicfight.config.CapabilityConfig;
import maninhouse.epicfight.main.EpicFightMod;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;

public class ProviderItem
implements ICapabilityProvider,
NonNullSupplier<CapabilityItem> {
    private static final Map<Item, CapabilityItem> CAPABILITY_BY_INSTANCE = new HashMap<Item, CapabilityItem>();
    private static final Map<Class<? extends Item>, Function<Item, CapabilityItem>> CAPABILITY_BY_CLASS = new HashMap<Class<? extends Item>, Function<Item, CapabilityItem>>();
    private CapabilityItem capability;
    private LazyOptional<CapabilityItem> optional = LazyOptional.of((NonNullSupplier)this);

    public static void makeMap() {
        ProviderItem.addCustomItemCapabilities();
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151053_p, AxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151049_t, AxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151036_c, AxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151006_E, AxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151056_x, AxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_234757_kL_, AxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151039_o, PickaxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151050_s, PickaxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151035_b, PickaxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151005_D, PickaxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151046_w, PickaxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_234756_kK_, PickaxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151017_I, HoeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151018_J, HoeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151019_K, HoeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151013_M, HoeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151012_L, HoeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_234758_kU_, HoeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151038_n, ShovelCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151051_r, ShovelCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151037_a, ShovelCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151011_C, ShovelCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151047_v, ShovelCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_234755_kJ_, ShovelCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151041_m, SwordCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151052_q, SwordCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151040_l, SwordCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151010_B, SwordCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151048_u, SwordCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_234754_kI_, SwordCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151021_T, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151027_R, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151024_Q, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151026_S, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151151_aj, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151171_ah, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151169_ag, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151149_ai, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151029_X, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151023_V, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151020_U, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151022_W, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151167_ab, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151030_Z, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151028_Y, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151165_aa, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151175_af, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151163_ad, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151161_ac, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151173_ae, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_234766_lv_, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_234764_lt_, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_234763_ls_, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_234765_lu_, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151031_f, BowCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_222114_py, CrossbowCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_203184_eO, TridentCapability::new);
        CAPABILITY_BY_CLASS.put(ArmorItem.class, ArmorCapability::new);
        CAPABILITY_BY_CLASS.put(SwordItem.class, SwordCapability::new);
        CAPABILITY_BY_CLASS.put(PickaxeItem.class, PickaxeCapability::new);
        CAPABILITY_BY_CLASS.put(AxeItem.class, AxeCapability::new);
        CAPABILITY_BY_CLASS.put(ShovelItem.class, ShovelCapability::new);
        CAPABILITY_BY_CLASS.put(HoeItem.class, HoeCapability::new);
        CAPABILITY_BY_CLASS.put(BowItem.class, BowCapability::new);
        CAPABILITY_BY_CLASS.put(CrossbowItem.class, CrossbowCapability::new);
    }

    public static void addInstance(Item item, CapabilityItem cap) {
        CAPABILITY_BY_INSTANCE.put(item, cap);
    }

    public static void addCustomItemCapabilities() {
        CapabilityItem cap;
        Item item;
        for (CapabilityConfig.CustomWeaponConfig customWeaponConfig : CapabilityConfig.CUSTOM_WEAPON_LISTS) {
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(customWeaponConfig.getRegistryName()));
            if (item != null) {
                EpicFightMod.LOGGER.info("Register Custom Capaiblity for " + customWeaponConfig.getRegistryName());
                cap = customWeaponConfig.getWeaponType().get(item);
                cap.setCustomWeapon(customWeaponConfig.getArmorIgnoranceOnehand(), customWeaponConfig.getImpactOnehand(), customWeaponConfig.getMaxStrikesOnehand(), customWeaponConfig.getArmorIgnoranceTwohand(), customWeaponConfig.getImpactTwohand(), customWeaponConfig.getMaxStrikesTwohand());
                CAPABILITY_BY_INSTANCE.put(item, cap);
                continue;
            }
            EpicFightMod.LOGGER.warn("Failed to load custom item " + customWeaponConfig.getRegistryName() + ". Item not exist!");
        }
        for (CapabilityConfig.CustomArmorConfig customArmorConfig : CapabilityConfig.CUSTOM_ARMOR_LISTS) {
            try {
                item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(customArmorConfig.getRegistryName()));
                if (item != null && item instanceof ArmorItem) {
                    cap = new ArmorCapability(item, customArmorConfig.getWeight(), customArmorConfig.getStunArmor());
                    CAPABILITY_BY_INSTANCE.put(item, cap);
                    EpicFightMod.LOGGER.info("Register Custom Capaiblity for " + customArmorConfig.getRegistryName());
                    continue;
                }
                if (item == null) {
                    EpicFightMod.LOGGER.warn("Failed to load custom item " + customArmorConfig.getRegistryName() + ". Item not exist!");
                    continue;
                }
                if (item instanceof ArmorItem) continue;
                EpicFightMod.LOGGER.warn("Failed to load custom item " + customArmorConfig.getRegistryName() + ". Item is not armor!");
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.warn("Failed to load custom item " + customArmorConfig.getRegistryName());
                System.err.println(e);
            }
        }
    }

    public ProviderItem(Item item, boolean autogenerate) {
        this.capability = CAPABILITY_BY_INSTANCE.get(item);
        if (this.capability == null && autogenerate) {
            this.capability = this.makeCustomCapability(item);
            if (this.capability != null) {
                CAPABILITY_BY_INSTANCE.put(item, this.capability);
            }
        }
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    private CapabilityItem makeCustomCapability(Item item) {
        CapabilityItem cap = null;
        for (Class<?> clazz = item.getClass(); clazz != null && cap == null; clazz = clazz.getSuperclass()) {
            cap = CAPABILITY_BY_CLASS.getOrDefault(clazz, argIn -> null).apply(item);
        }
        return cap;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == ModCapabilities.CAPABILITY_ITEM ? this.optional.cast() : LazyOptional.empty();
    }

    public CapabilityItem get() {
        return this.capability;
    }
}

