/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.projectile.ArrowData;
import maninhouse.epicfight.capabilities.entity.projectile.CapabilityProjectile;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public class ProviderProjectile<P extends ProjectileEntity>
implements ICapabilityProvider,
NonNullSupplier<CapabilityProjectile<?>> {
    private static final Map<EntityType<?>, Supplier<CapabilityProjectile<?>>> CAPABILITY_BY_TYPE = new HashMap();
    private static final Map<Class<? extends ProjectileEntity>, Supplier<CapabilityProjectile<?>>> CAPABILITY_BY_CLASS = new HashMap();
    private CapabilityProjectile<?> capability;
    private LazyOptional<CapabilityProjectile<?>> optional = LazyOptional.of((NonNullSupplier)this);

    public static void makeMap() {
        CAPABILITY_BY_TYPE.computeIfAbsent(EntityType.field_200790_d, type -> ArrowData::new);
        CAPABILITY_BY_CLASS.put(AbstractArrowEntity.class, ArrowData::new);
    }

    public ProviderProjectile(P projectile) {
        if (CAPABILITY_BY_TYPE.containsKey(projectile.func_200600_R())) {
            this.capability = CAPABILITY_BY_TYPE.get(projectile.func_200600_R()).get();
        } else {
            Supplier<CapabilityProjectile<?>> capSupplier = this.makeCustomCapability(projectile);
            CAPABILITY_BY_TYPE.put(projectile.func_200600_R(), capSupplier);
            this.capability = capSupplier.get();
        }
    }

    private Supplier<CapabilityProjectile<?>> makeCustomCapability(P projectileEntity) {
        Supplier<CapabilityProjectile<?>> cap = () -> null;
        for (Class<?> clazz = projectileEntity.getClass(); clazz != null && cap.get() == null; clazz = clazz.getSuperclass()) {
            cap = CAPABILITY_BY_CLASS.getOrDefault(clazz, () -> null);
        }
        return cap;
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    public CapabilityProjectile<?> get() {
        return this.capability;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == ModCapabilities.CAPABILITY_PROJECTILE ? this.optional.cast() : LazyOptional.empty();
    }
}

