/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity;

import java.util.ArrayList;
import java.util.List;
import maninhouse.epicfight.animation.Animator;
import maninhouse.epicfight.animation.AnimatorServer;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.EntityState;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.CapabilityEntity;
import maninhouse.epicfight.capabilities.entity.DataKeys;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.main.EpicFightMod;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCPlayAnimation;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.MathUtils;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class LivingData<T extends LivingEntity>
extends CapabilityEntity<T> {
    private float stunTimeReduction;
    protected boolean inaction = false;
    public LivingMotion currentMotion = LivingMotion.IDLE;
    public LivingMotion currentMixMotion = LivingMotion.NONE;
    protected Animator animator;
    public List<LivingEntity> currentlyAttackedEntity;

    @Override
    public void onEntityConstructed(T entityIn) {
        super.onEntityConstructed(entityIn);
        if (((LivingEntity)this.orgEntity).field_70170_p.field_72995_K) {
            this.animator = new AnimatorClient(this);
            this.initAnimator(this.getClientAnimator());
        } else {
            this.animator = new AnimatorServer(this);
        }
        this.inaction = false;
        this.currentlyAttackedEntity = new ArrayList<LivingEntity>();
    }

    @Override
    public void onEntityJoinWorld(T entityIn) {
        this.initAttributes();
    }

    protected abstract void initAnimator(AnimatorClient var1);

    public abstract void updateMotion();

    public abstract <M extends Model> M getEntityModel(Models<M> var1);

    protected void initAttributes() {
        ((LivingEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.WEIGHT.get()).func_111128_a(((LivingEntity)this.orgEntity).func_110148_a(Attributes.field_233818_a_).func_111125_b() * 2.0);
        ((LivingEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.MAX_STRIKES.get()).func_111128_a(1.0);
        ((LivingEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.ARMOR_NEGATION.get()).func_111128_a(0.0);
        ((LivingEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.IMPACT.get()).func_111128_a(0.5);
    }

    @Override
    protected void updateOnClient() {
        AnimatorClient animator = this.getClientAnimator();
        if (this.inaction) {
            this.currentMotion = LivingMotion.IDLE;
        } else {
            this.updateMotion();
            if (!animator.compareMotion(this.currentMotion)) {
                animator.playLoopMotion();
            }
            if (!animator.compareMixMotion(this.currentMixMotion)) {
                animator.playMixLoopMotion();
            }
        }
    }

    @Override
    protected void updateOnServer() {
        if (this.stunTimeReduction > 0.0f) {
            this.stunTimeReduction = Math.max(0.0f, this.stunTimeReduction - 0.05f);
        }
    }

    @Override
    public void update() {
        this.updateInactionState();
        if (this.isRemote()) {
            this.updateOnClient();
        } else {
            this.updateOnServer();
        }
        this.animator.update();
        if (((LivingEntity)this.orgEntity).field_70725_aQ == 19) {
            this.aboutToDeath();
        }
    }

    public void updateInactionState() {
        EntityState state = this.getEntityState();
        this.inaction = state.isCameraRotationLocked() || state.isMovementLocked();
    }

    protected final void commonBipedCreatureAnimatorInit(AnimatorClient animatorClient) {
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.BIPED_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.BIPED_WALK);
        animatorClient.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animatorClient.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
    }

    protected final void commonCreatureUpdateMotion() {
        this.currentMotion = ((LivingEntity)this.orgEntity).func_110143_aJ() <= 0.0f ? LivingMotion.DEATH : (((LivingEntity)this.orgEntity).func_184187_bx() != null ? LivingMotion.MOUNT : (((LivingEntity)this.orgEntity).func_213322_ci().field_72448_b < (double)-0.55f ? LivingMotion.FALL : (((LivingEntity)this.orgEntity).field_70721_aZ > 0.01f ? LivingMotion.WALKING : LivingMotion.IDLE)));
    }

    public void cancelUsingItem() {
        ((LivingEntity)this.orgEntity).func_184602_cy();
        ForgeEventFactory.onUseItemStop((LivingEntity)((LivingEntity)this.orgEntity), (ItemStack)((LivingEntity)this.orgEntity).func_184607_cu(), (int)((LivingEntity)this.orgEntity).func_184605_cv());
    }

    public CapabilityItem getHeldItemCapability(Hand hand) {
        return ModCapabilities.stackCapabilityGetter(((LivingEntity)this.orgEntity).func_184586_b(hand));
    }

    public CapabilityItem getAdvancedHeldItemCapability(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return this.getHeldItemCapability(hand);
        }
        return this.isValidOffhandItem() ? this.getHeldItemCapability(hand) : null;
    }

    public boolean isInaction() {
        return this.inaction;
    }

    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        return !this.getEntityState().isInvincible() || !(damageSource instanceof EntityDamageSource) || damageSource.func_94541_c() || damageSource.func_82725_o();
    }

    public IExtendedDamageSource getDamageSource(IExtendedDamageSource.StunType stunType, IExtendedDamageSource.DamageType damageType, int animationId, Hand hand) {
        return IExtendedDamageSource.causeMobDamage((LivingEntity)this.orgEntity, stunType, damageType, animationId);
    }

    public float getDamageToEntity(Entity targetEntity, Hand hand) {
        float damage = 0.0f;
        damage = hand == Hand.MAIN_HAND ? (float)((LivingEntity)this.orgEntity).func_233637_b_(Attributes.field_233823_f_) : (this.isValidOffhandItem() ? (float)((LivingEntity)this.orgEntity).func_233637_b_((Attribute)ModAttributes.OFFHAND_ATTACK_DAMAGE.get()) : (float)((LivingEntity)this.orgEntity).func_110148_a(Attributes.field_233823_f_).func_111125_b());
        float bonus = targetEntity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)this.getAdvancedHeldItem(hand), (CreatureAttribute)((LivingEntity)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)this.getAdvancedHeldItem(hand), (CreatureAttribute)CreatureAttribute.field_223222_a_);
        return damage + bonus;
    }

    public boolean hurtEntity(Entity hitTarget, Hand handIn, IExtendedDamageSource source, float amount) {
        int resistTime = hitTarget.field_70172_ad;
        hitTarget.field_70172_ad = 0;
        boolean succed = hitTarget.func_70097_a((DamageSource)source, amount);
        if (succed) {
            int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)this.getAdvancedHeldItem(handIn));
            if (hitTarget instanceof LivingEntity && j > 0 && !hitTarget.func_70027_ad()) {
                hitTarget.func_70015_d(j * 4);
            }
        }
        hitTarget.field_70172_ad = resistTime;
        return succed;
    }

    public void gatherDamageDealt(IExtendedDamageSource source, float amount) {
    }

    public void setStunTimeReduction() {
        this.stunTimeReduction += (1.0f - this.stunTimeReduction) * 0.8f;
    }

    public float getStunTimeTimeReduction() {
        return this.stunTimeReduction;
    }

    public void knockBackEntity(Entity entityIn, float power) {
        double d1 = entityIn.func_226277_ct_() - ((LivingEntity)this.orgEntity).func_226277_ct_();
        double d0 = entityIn.func_226281_cx_() - ((LivingEntity)this.orgEntity).func_226281_cx_();
        while (d1 * d1 + d0 * d0 < 1.0E-4) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d0 = (Math.random() - Math.random()) * 0.01;
        }
        if (((LivingEntity)this.orgEntity).func_70681_au().nextDouble() >= ((LivingEntity)this.orgEntity).func_233637_b_(Attributes.field_233820_c_)) {
            Vector3d vec = ((LivingEntity)this.orgEntity).func_213322_ci();
            ((LivingEntity)this.orgEntity).field_70160_al = true;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0));
            double x = vec.field_72450_a;
            double y = vec.field_72448_b;
            double z = vec.field_72449_c;
            x /= 2.0;
            z /= 2.0;
            x -= d1 / (double)f * (double)power;
            z -= d0 / (double)f * (double)power;
            if (!((LivingEntity)this.orgEntity).func_233570_aj_()) {
                y /= 2.0;
                if ((y += (double)power) > (double)0.4f) {
                    y = 0.4f;
                }
            }
            ((LivingEntity)this.orgEntity).func_213293_j(x, y, z);
            ((LivingEntity)this.orgEntity).field_70133_I = true;
        }
    }

    public float getMaxStunArmor() {
        ModifiableAttributeInstance stun_resistance = ((LivingEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.MAX_STUN_ARMOR.get());
        return (float)(stun_resistance == null ? 0.0 : stun_resistance.func_111126_e());
    }

    public float getStunArmor() {
        return this.getMaxStunArmor() == 0.0f ? 0.0f : ((Float)((LivingEntity)this.orgEntity).func_184212_Q().func_187225_a(DataKeys.STUN_ARMOR)).floatValue();
    }

    public void setStunArmor(float value) {
        float f1 = Math.max(Math.min(value, this.getMaxStunArmor()), 0.0f);
        ((LivingEntity)this.orgEntity).func_184212_Q().func_187227_b(DataKeys.STUN_ARMOR, (Object)Float.valueOf(f1));
    }

    public double getWeight() {
        return ((LivingEntity)this.orgEntity).func_233637_b_((Attribute)ModAttributes.WEIGHT.get());
    }

    public void rotateTo(float degree, float limit, boolean partialSync) {
        float amount;
        T entity = this.getOriginalEntity();
        for (amount = MathHelper.func_76142_g((float)(degree - ((LivingEntity)entity).field_70177_z)); amount < -180.0f; amount += 360.0f) {
        }
        while (amount > 180.0f) {
            amount -= 360.0f;
        }
        if (amount > limit) {
            amount = limit;
        }
        if (amount < -limit) {
            amount = -limit;
        }
        float f1 = ((LivingEntity)entity).field_70177_z + amount;
        if (partialSync) {
            ((LivingEntity)entity).field_70126_B = f1;
            ((LivingEntity)entity).field_70758_at = f1;
            ((LivingEntity)entity).field_70760_ar = f1;
        }
        ((LivingEntity)entity).field_70177_z = f1;
        ((LivingEntity)entity).field_70759_as = f1;
        ((LivingEntity)entity).field_70761_aq = f1;
    }

    public void rotateTo(Entity target, float limit, boolean partialSync) {
        double d0 = target.func_226277_ct_() - ((LivingEntity)this.orgEntity).func_226277_ct_();
        double d1 = target.func_226281_cx_() - ((LivingEntity)this.orgEntity).func_226281_cx_();
        float degree = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
        this.rotateTo(degree, limit, partialSync);
    }

    public void playSound(SoundEvent sound, float minPitch, float maxPitch) {
        float randPitch = ((LivingEntity)this.orgEntity).func_70681_au().nextFloat() * 2.0f - 1.0f;
        randPitch = Math.min(Math.max(randPitch, minPitch), maxPitch);
        if (!this.isRemote()) {
            ((LivingEntity)this.orgEntity).field_70170_p.func_184148_a(null, ((LivingEntity)this.orgEntity).func_226277_ct_(), ((LivingEntity)this.orgEntity).func_226278_cu_(), ((LivingEntity)this.orgEntity).func_226281_cx_(), sound, ((LivingEntity)this.orgEntity).func_184176_by(), 1.0f, 1.0f + randPitch);
        } else {
            ((LivingEntity)this.orgEntity).field_70170_p.func_184134_a(((LivingEntity)this.orgEntity).func_226277_ct_(), ((LivingEntity)this.orgEntity).func_226278_cu_(), ((LivingEntity)this.orgEntity).func_226281_cx_(), sound, ((LivingEntity)this.orgEntity).func_184176_by(), 1.0f, 1.0f + randPitch, false);
        }
    }

    public LivingEntity getAttackTarget() {
        return ((LivingEntity)this.orgEntity).func_110144_aD();
    }

    public float getAttackDirectionPitch() {
        float partialTicks = EpicFightMod.isPhysicalClient() ? Minecraft.func_71410_x().func_184121_ak() : 1.0f;
        float pitch = -this.getOriginalEntity().func_195050_f(partialTicks);
        float correct = pitch > 0.0f ? 0.03333f * (float)Math.pow(pitch, 2.0) : -0.03333f * (float)Math.pow(pitch, 2.0);
        return MathHelper.func_76131_a((float)correct, (float)-30.0f, (float)30.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public VisibleMatrix4f getHeadMatrix(float partialTicks) {
        float f2;
        if (this.inaction) {
            f2 = 0.0f;
        } else {
            float f = MathUtils.interpolateRotation(((LivingEntity)this.orgEntity).field_70760_ar, ((LivingEntity)this.orgEntity).field_70761_aq, partialTicks);
            float f1 = MathUtils.interpolateRotation(((LivingEntity)this.orgEntity).field_70758_at, ((LivingEntity)this.orgEntity).field_70759_as, partialTicks);
            f2 = f1 - f;
            if (((LivingEntity)this.orgEntity).func_184187_bx() != null) {
                if (f2 > 45.0f) {
                    f2 = 45.0f;
                } else if (f2 < -45.0f) {
                    f2 = -45.0f;
                }
            }
        }
        return MathUtils.getModelMatrixIntegrated(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((LivingEntity)this.orgEntity).field_70127_C, ((LivingEntity)this.orgEntity).field_70125_A, f2, f2, partialTicks, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public VisibleMatrix4f getModelMatrix(float partialTicks) {
        float rotyaw;
        float prevRotYaw;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        float scaleZ = 1.0f;
        if (((LivingEntity)this.orgEntity).func_184187_bx() instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)((LivingEntity)this.orgEntity).func_184187_bx();
            prevRotYaw = ridingEntity.field_70760_ar;
            rotyaw = ridingEntity.field_70761_aq;
        } else {
            prevRotYaw = this.inaction ? ((LivingEntity)this.orgEntity).field_70177_z : ((LivingEntity)this.orgEntity).field_70760_ar;
            float f = rotyaw = this.inaction ? ((LivingEntity)this.orgEntity).field_70177_z : ((LivingEntity)this.orgEntity).field_70761_aq;
        }
        if (((LivingEntity)this.orgEntity).func_70631_g_()) {
            scaleX *= 0.5f;
            scaleY *= 0.5f;
            scaleZ *= 0.5f;
        }
        return MathUtils.getModelMatrixIntegrated((float)((LivingEntity)this.orgEntity).field_70142_S, (float)((LivingEntity)this.orgEntity).func_226277_ct_(), (float)((LivingEntity)this.orgEntity).field_70137_T, (float)((LivingEntity)this.orgEntity).func_226278_cu_(), (float)((LivingEntity)this.orgEntity).field_70136_U, (float)((LivingEntity)this.orgEntity).func_226281_cx_(), 0.0f, 0.0f, prevRotYaw, rotyaw, partialTicks, scaleX, scaleY, scaleZ);
    }

    public void resetLivingMixLoop() {
        this.currentMixMotion = LivingMotion.NONE;
        this.getClientAnimator().resetMixMotion();
    }

    public void reserverAnimationSynchronize(StaticAnimation animation) {
        this.animator.reserveAnimation(animation);
        ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(animation.getId(), ((LivingEntity)this.orgEntity).func_145782_y(), 0.0f), this.orgEntity);
    }

    public void playAnimationSynchronize(int id, float modifyTime) {
        this.animator.playAnimation(id, modifyTime);
        ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(id, ((LivingEntity)this.orgEntity).func_145782_y(), modifyTime), this.orgEntity);
    }

    public void playAnimationSynchronize(StaticAnimation animation, float modifyTime) {
        this.playAnimationSynchronize(animation.getId(), modifyTime);
    }

    public void resetSize(EntitySize size) {
        EntitySize entitysize1;
        EntitySize entitysize = ((LivingEntity)this.orgEntity).field_213325_aI;
        ((LivingEntity)this.orgEntity).field_213325_aI = entitysize1 = size;
        if (entitysize1.field_220315_a < entitysize.field_220315_a) {
            double d0 = (double)entitysize1.field_220315_a / 2.0;
            ((LivingEntity)this.orgEntity).func_174826_a(new AxisAlignedBB(((LivingEntity)this.orgEntity).func_226277_ct_() - d0, ((LivingEntity)this.orgEntity).func_226278_cu_(), ((LivingEntity)this.orgEntity).func_226281_cx_() - d0, ((LivingEntity)this.orgEntity).func_226277_ct_() + d0, ((LivingEntity)this.orgEntity).func_226278_cu_() + (double)entitysize1.field_220316_b, ((LivingEntity)this.orgEntity).func_226281_cx_() + d0));
        } else {
            AxisAlignedBB axisalignedbb = ((LivingEntity)this.orgEntity).func_174813_aQ();
            ((LivingEntity)this.orgEntity).func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)entitysize1.field_220315_a, axisalignedbb.field_72338_b + (double)entitysize1.field_220316_b, axisalignedbb.field_72339_c + (double)entitysize1.field_220315_a));
            if (entitysize1.field_220315_a > entitysize.field_220315_a && !((LivingEntity)this.orgEntity).field_70170_p.field_72995_K) {
                float f = entitysize.field_220315_a - entitysize1.field_220315_a;
                ((LivingEntity)this.orgEntity).func_213315_a(MoverType.SELF, new Vector3d((double)f, 0.0, (double)f));
            }
        }
    }

    public void onArmorSlotChanged(CapabilityItem fromCap, CapabilityItem toCap, EquipmentSlotType slotType) {
    }

    public <A extends Animator> A getAnimator() {
        return (A)this.animator;
    }

    public AnimatorClient getClientAnimator() {
        return (AnimatorClient)this.getAnimator();
    }

    public AnimatorServer getServerAnimator() {
        return (AnimatorServer)this.getAnimator();
    }

    public abstract StaticAnimation getHitAnimation(IExtendedDamageSource.StunType var1);

    @Override
    public void aboutToDeath() {
        this.animator.onEntityDeath();
    }

    @Override
    public T getOriginalEntity() {
        return (T)((LivingEntity)this.orgEntity);
    }

    public SoundEvent getWeaponHitSound(Hand hand) {
        CapabilityItem cap = this.getAdvancedHeldItemCapability(hand);
        if (cap != null) {
            return cap.getHitSound();
        }
        return Sounds.BLUNT_HIT;
    }

    public SoundEvent getSwingSound(Hand hand) {
        CapabilityItem cap = this.getAdvancedHeldItemCapability(hand);
        if (cap != null) {
            return cap.getSmashingSound();
        }
        return Sounds.WHOOSH;
    }

    public HitParticleType getWeaponHitParticle(Hand hand) {
        CapabilityItem cap = this.getAdvancedHeldItemCapability(hand);
        if (cap != null) {
            return cap.getHitParticle();
        }
        return (HitParticleType)Particles.HIT_BLUNT.get();
    }

    public Collider getColliderMatching(Hand hand) {
        CapabilityItem itemCap = this.getAdvancedHeldItemCapability(hand);
        return itemCap != null ? itemCap.getWeaponCollider() : Colliders.fist;
    }

    public int getHitEnemies(Hand hand) {
        return (int)(hand == Hand.MAIN_HAND ? ((LivingEntity)this.orgEntity).func_233637_b_((Attribute)ModAttributes.MAX_STRIKES.get()) : (this.isValidOffhandItem() ? ((LivingEntity)this.orgEntity).func_233637_b_((Attribute)ModAttributes.OFFHAND_MAX_STRIKES.get()) : ((LivingEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.MAX_STRIKES.get()).func_111125_b()));
    }

    public float getArmorNegation(Hand hand) {
        return (float)(hand == Hand.MAIN_HAND ? ((LivingEntity)this.orgEntity).func_233637_b_((Attribute)ModAttributes.ARMOR_NEGATION.get()) : (this.isValidOffhandItem() ? ((LivingEntity)this.orgEntity).func_233637_b_((Attribute)ModAttributes.OFFHAND_ARMOR_NEGATION.get()) : ((LivingEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.ARMOR_NEGATION.get()).func_111125_b()));
    }

    public float getImpact(Hand hand) {
        return (float)(hand == Hand.MAIN_HAND ? ((LivingEntity)this.orgEntity).func_233637_b_((Attribute)ModAttributes.IMPACT.get()) : (this.isValidOffhandItem() ? ((LivingEntity)this.orgEntity).func_233637_b_((Attribute)ModAttributes.OFFHAND_IMPACT.get()) : ((LivingEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.IMPACT.get()).func_111125_b()));
    }

    public ItemStack getAdvancedHeldItem(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return ((LivingEntity)this.orgEntity).func_184586_b(hand);
        }
        return this.isValidOffhandItem() ? ((LivingEntity)this.orgEntity).func_184586_b(hand) : ItemStack.field_190927_a;
    }

    public boolean isValidOffhandItem() {
        CapabilityItem mainhandItem = this.getHeldItemCapability(Hand.MAIN_HAND);
        if (this.getHeldItemCapability(Hand.MAIN_HAND) == null) {
            return this.getHeldItemCapability(Hand.OFF_HAND) == null;
        }
        return mainhandItem.isValidOffhandItem(((LivingEntity)this.orgEntity).func_184592_cb());
    }

    public boolean isTeam(Entity entityIn) {
        if (((LivingEntity)this.orgEntity).func_184187_bx() != null && ((LivingEntity)this.orgEntity).func_184187_bx().equals((Object)entityIn)) {
            return true;
        }
        if (this.isRideOrBeingRidden(entityIn)) {
            return true;
        }
        return ((LivingEntity)this.orgEntity).func_184191_r(entityIn);
    }

    private boolean isRideOrBeingRidden(Entity entityIn) {
        T orgEntity = this.getOriginalEntity();
        for (Entity passanger : orgEntity.func_184188_bt()) {
            if (!passanger.equals((Object)entityIn)) continue;
            return true;
        }
        for (Entity passanger : entityIn.func_184188_bt()) {
            if (!passanger.equals(orgEntity)) continue;
            return true;
        }
        return false;
    }

    public boolean isFirstPerson() {
        return false;
    }

    public boolean shouldSkipRender() {
        return false;
    }

    public EntityState getEntityState() {
        return this.animator.getPlayer().getPlay().getState(this.animator.getPlayer().getElapsedTime());
    }
}

