/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.CapabilityEntity;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.entity.ai.ArcherGoal;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import maninhouse.epicfight.entity.ai.RangeAttackMobGoal;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.main.EpicFightMod;
import maninhouse.epicfight.network.server.STCMobInitialSetting;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public abstract class MobData<T extends MobEntity>
extends LivingData<T> {
    protected final Faction mobFaction;

    public MobData() {
        this.mobFaction = Faction.NATURAL;
    }

    public MobData(Faction faction) {
        this.mobFaction = faction;
    }

    @Override
    public void onEntityJoinWorld(T entityIn) {
        super.onEntityJoinWorld(entityIn);
        this.initAI();
    }

    protected void initAI() {
        this.resetCombatAI();
    }

    protected void resetCombatAI() {
        Set goals = ((MobEntity)this.orgEntity).field_70714_bg.field_220892_d;
        Iterator iterator = goals.iterator();
        ArrayList toRemove = Lists.newArrayList();
        while (iterator.hasNext()) {
            PrioritizedGoal goal = (PrioritizedGoal)iterator.next();
            Goal inner = goal.func_220772_j();
            if (!(inner instanceof MeleeAttackGoal) && !(inner instanceof RangedBowAttackGoal) && !(inner instanceof ArcherGoal) && !(inner instanceof ChasingGoal) && !(inner instanceof RangedAttackGoal) && !(inner instanceof RangeAttackMobGoal) && !(inner instanceof AttackPatternGoal) && !(inner instanceof RangedCrossbowAttackGoal)) continue;
            toRemove.add(inner);
        }
        for (Goal AI : toRemove) {
            ((MobEntity)this.orgEntity).field_70714_bg.func_85156_a(AI);
        }
    }

    public STCMobInitialSetting sendInitialInformationToClient() {
        return null;
    }

    public void clientInitialSettings(ByteBuf buf) {
    }

    @Override
    public void onArmorSlotChanged(CapabilityItem fromCap, CapabilityItem toCap, EquipmentSlotType slotType) {
        if (((MobEntity)this.orgEntity).func_233645_dx_().func_233790_b_((Attribute)ModAttributes.MAX_STUN_ARMOR.get())) {
            if (fromCap != null) {
                ((MobEntity)this.orgEntity).func_233645_dx_().func_233785_a_(fromCap.getAttributeModifiers(slotType, this));
            }
            if (toCap != null) {
                ((MobEntity)this.orgEntity).func_233645_dx_().func_233793_b_(toCap.getAttributeModifiers(slotType, this));
            }
            this.setStunArmor((float)((MobEntity)this.orgEntity).func_233637_b_((Attribute)ModAttributes.MAX_STUN_ARMOR.get()));
        }
    }

    @Override
    public boolean isTeam(Entity entityIn) {
        CapabilityEntity cap = (CapabilityEntity)entityIn.getCapability(ModCapabilities.CAPABILITY_ENTITY).orElse(null);
        if (cap != null && cap instanceof MobData && ((MobData)cap).mobFaction.equals((Object)this.mobFaction)) {
            Optional<LivingEntity> opt = Optional.ofNullable(this.getAttackTarget());
            return opt.map(attackTarget -> !attackTarget.func_70028_i(entityIn)).orElse(true);
        }
        return super.isTeam(entityIn);
    }

    @Override
    public LivingEntity getAttackTarget() {
        return ((MobEntity)this.orgEntity).func_70638_az();
    }

    @Override
    public float getAttackDirectionPitch() {
        LivingEntity attackTarget = this.getAttackTarget();
        if (attackTarget != null) {
            float partialTicks = EpicFightMod.isPhysicalClient() ? Minecraft.func_71410_x().func_184121_ak() : 1.0f;
            Vector3d target = attackTarget.func_174824_e(partialTicks);
            Vector3d vector3d = ((MobEntity)this.orgEntity).func_174824_e(partialTicks);
            double d0 = target.field_72450_a - vector3d.field_72450_a;
            double d1 = target.field_72448_b - vector3d.field_72448_b;
            double d2 = target.field_72449_c - vector3d.field_72449_c;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            return MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875))), (float)-30.0f, (float)30.0f);
        }
        return super.getAttackDirectionPitch();
    }
}

