/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import java.util.Iterator;
import java.util.Set;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.MobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.CreeperSwellStoppableGoal;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.entity.ai.goal.CreeperSwellGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.util.math.MathHelper;

public class CreeperData
extends MobData<CreeperEntity> {
    public CreeperData() {
        super(Faction.NATURAL);
    }

    @Override
    protected void initAI() {
        Set goals = ((CreeperEntity)this.orgEntity).field_70714_bg.field_220892_d;
        Iterator iterator = goals.iterator();
        Goal toRemove = null;
        while (iterator.hasNext()) {
            PrioritizedGoal goal = (PrioritizedGoal)iterator.next();
            Goal inner = goal.func_220772_j();
            if (!(inner instanceof CreeperSwellGoal)) continue;
            toRemove = inner;
            break;
        }
        if (toRemove != null) {
            ((CreeperEntity)this.orgEntity).field_70714_bg.func_85156_a(toRemove);
        }
        ((CreeperEntity)this.orgEntity).field_70714_bg.func_75776_a(2, (Goal)new CreeperSwellStoppableGoal(this, (CreeperEntity)this.orgEntity));
    }

    @Override
    protected void initAnimator(AnimatorClient animator) {
        animator.addLivingAnimation(LivingMotion.IDLE, Animations.CREEPER_IDLE);
        animator.addLivingAnimation(LivingMotion.WALKING, Animations.CREEPER_WALK);
        animator.addLivingAnimation(LivingMotion.DEATH, Animations.CREEPER_DEATH);
        animator.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public VisibleMatrix4f getModelMatrix(float partialTicks) {
        VisibleMatrix4f mat = super.getModelMatrix(partialTicks);
        if (this.isRemote()) {
            float f = ((CreeperEntity)this.orgEntity).func_70831_j(partialTicks);
            float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
            f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f2 = (1.0f + f * 0.4f) * f1;
            float f3 = (1.0f + f * 0.1f) / f1;
            VisibleMatrix4f.scale(new Vec3f(f2, f3, f2), mat, mat);
        }
        return mat;
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (stunType == IExtendedDamageSource.StunType.LONG) {
            return Animations.CREEPER_HIT_LONG;
        }
        return Animations.CREEPER_HIT_SHORT;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_CREEPER;
    }
}

