/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import java.util.EnumSet;
import java.util.Random;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.AttackAnimation;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.DataKeys;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.effects.ModEffects;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.AttackPatternPercentGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCPlayAnimationTP;
import maninhouse.epicfight.network.server.STCPlayAnimationTarget;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.Vec3f;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;

public class EndermanData
extends BipedMobData<EndermanEntity> {
    private int deathTimerExt = 0;
    private boolean onRage;
    private Goal normalAttack1;
    private Goal normalAttack2;
    private Goal normalAttack3;
    private Goal normalAttack4;
    private Goal normalAttack5;
    private Goal rageTarget;
    private Goal rageChase;

    public EndermanData() {
        super(Faction.ENDERLAND);
    }

    @Override
    public void onEntityConstructed(EndermanEntity entityIn) {
        super.onEntityConstructed(entityIn);
        ((EndermanEntity)this.orgEntity).func_184212_Q().func_187214_a(DataKeys.STUN_ARMOR, (Object)Float.valueOf(6.0f));
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((EndermanEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.MAX_STUN_ARMOR.get()).func_111128_a(6.0);
        ((EndermanEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.IMPACT.get()).func_111128_a((double)1.8f);
    }

    @Override
    public void postInit() {
        super.postInit();
        if (this.isRemote()) {
            if (this.isRaging()) {
                this.getClientAnimator().addLivingAnimation(LivingMotion.IDLE, Animations.ENDERMAN_RAGE_IDLE);
                this.getClientAnimator().addLivingAnimation(LivingMotion.WALKING, Animations.ENDERMAN_RAGE_WALK);
                this.onRage = true;
            } else {
                this.getClientAnimator().addLivingAnimation(LivingMotion.IDLE, Animations.ENDERMAN_IDLE);
                this.getClientAnimator().addLivingAnimation(LivingMotion.WALKING, Animations.ENDERMAN_WALK);
                this.onRage = false;
            }
        }
    }

    @Override
    protected void initAI() {
        super.initAI();
        this.normalAttack1 = new AttackPatternPercentGoal(this, (MobEntity)this.orgEntity, 0.0, 1.23, 0.4f, true, MobAttackPatterns.ENDERMAN_PATTERN1);
        this.normalAttack2 = new AttackPatternPercentGoal(this, (MobEntity)this.orgEntity, 0.0, 1.9, 0.4f, true, MobAttackPatterns.ENDERMAN_PATTERN2);
        this.normalAttack3 = new AttackPatternPercentGoal(this, (MobEntity)this.orgEntity, 3.0, 4.0, 0.1f, true, MobAttackPatterns.ENDERMAN_PATTERN3);
        this.normalAttack4 = new AttackPatternPercentGoal(this, (MobEntity)this.orgEntity, 0.0, 2.0, 0.2f, true, MobAttackPatterns.ENDERMAN_PATTERN4);
        this.normalAttack5 = new AIEndermanTeleportKick(this, (MobEntity)this.orgEntity);
        this.rageTarget = new NearestAttackableTargetGoal((MobEntity)this.orgEntity, PlayerEntity.class, true);
        this.rageChase = new AIEndermanRush(this, (MobEntity)this.orgEntity);
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.ENDERMAN_DEATH);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.ENDERMAN_WALK);
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.ENDERMAN_IDLE);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public void updateOnServer() {
        super.updateOnServer();
        if (this.isRaging() && !this.onRage && ((EndermanEntity)this.orgEntity).field_70173_aa > 5) {
            this.convertRage();
        } else if (this.onRage && !this.isRaging()) {
            this.convertNormal();
        }
    }

    @Override
    public void update() {
        if (((EndermanEntity)this.orgEntity).func_110143_aJ() <= 0.0f) {
            ((EndermanEntity)this.orgEntity).field_70125_A = 0.0f;
            if (((EndermanEntity)this.orgEntity).field_70725_aQ > 1 && this.deathTimerExt < 20) {
                ++this.deathTimerExt;
                --((EndermanEntity)this.orgEntity).field_70725_aQ;
            }
        }
        super.update();
    }

    @Override
    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        if (damageSource instanceof EntityDamageSource && !this.isRaging()) {
            IExtendedDamageSource extDamageSource = null;
            if (damageSource instanceof IExtendedDamageSource) {
                extDamageSource = (IExtendedDamageSource)damageSource;
            }
            if (extDamageSource == null || extDamageSource.getStunType() != IExtendedDamageSource.StunType.HOLD) {
                int percentage;
                int n = percentage = this.animator.getPlayer().getPlay() instanceof AttackAnimation ? 10 : 3;
                if (((EndermanEntity)this.orgEntity).func_70681_au().nextInt(percentage) == 0) {
                    for (int i = 0; i < 9; ++i) {
                        if (!this.teleportRandomly()) continue;
                        if (damageSource.func_76346_g() instanceof LivingEntity) {
                            ((EndermanEntity)this.orgEntity).func_70604_c((LivingEntity)damageSource.func_76346_g());
                        }
                        if (this.inaction) {
                            this.playAnimationSynchronize(Animations.ENDERMAN_TP_EMERGENCE, 0.0f);
                        }
                        return false;
                    }
                }
            }
        }
        return super.attackEntityFrom(damageSource, amount);
    }

    protected boolean teleportRandomly() {
        if (!this.isRemote() && ((EndermanEntity)this.orgEntity).func_70089_S()) {
            double d0 = ((EndermanEntity)this.orgEntity).func_226277_ct_() + (((EndermanEntity)this.orgEntity).func_70681_au().nextDouble() - 0.5) * 64.0;
            double d1 = ((EndermanEntity)this.orgEntity).func_226278_cu_() + (double)(((EndermanEntity)this.orgEntity).func_70681_au().nextInt(64) - 32);
            double d2 = ((EndermanEntity)this.orgEntity).func_226281_cx_() + (((EndermanEntity)this.orgEntity).func_70681_au().nextDouble() - 0.5) * 64.0;
            return this.teleportTo(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTo(double x, double y, double z) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !((EndermanEntity)this.orgEntity).field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = ((EndermanEntity)this.orgEntity).field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            boolean flag2 = ((EndermanEntity)this.orgEntity).func_213373_a(x, y, z, true);
            if (flag2 && !((EndermanEntity)this.orgEntity).func_174814_R()) {
                ((EndermanEntity)this.orgEntity).field_70170_p.func_184148_a((PlayerEntity)null, ((EndermanEntity)this.orgEntity).field_70169_q, ((EndermanEntity)this.orgEntity).field_70167_r, ((EndermanEntity)this.orgEntity).field_70166_s, SoundEvents.field_187534_aX, ((EndermanEntity)this.orgEntity).func_184176_by(), 1.0f, 1.0f);
                ((EndermanEntity)this.orgEntity).func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    public boolean isRaging() {
        return ((EndermanEntity)this.orgEntity).func_110143_aJ() / ((EndermanEntity)this.orgEntity).func_110138_aP() < 0.33f;
    }

    protected void convertRage() {
        this.onRage = true;
        this.playAnimationSynchronize(Animations.ENDERMAN_HIT_RAGE, 0.0f);
        if (this.isRemote()) {
            this.getClientAnimator().addLivingAnimation(LivingMotion.IDLE, Animations.ENDERMAN_RAGE_IDLE);
            this.getClientAnimator().addLivingAnimation(LivingMotion.WALKING, Animations.ENDERMAN_RAGE_WALK);
        } else if (!((EndermanEntity)this.orgEntity).func_175446_cd()) {
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack1);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack2);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack3);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack4);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack5);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, this.rageChase);
            ((EndermanEntity)this.orgEntity).field_70715_bh.func_75776_a(3, this.rageTarget);
            ((EndermanEntity)this.orgEntity).func_184212_Q().func_187227_b(EndermanEntity.field_184719_bw, (Object)true);
            ((EndermanEntity)this.orgEntity).func_195064_c(new EffectInstance(ModEffects.STUN_IMMUNITY, 120000));
        }
    }

    protected void convertNormal() {
        this.onRage = false;
        if (this.isRemote()) {
            this.getClientAnimator().addLivingAnimation(LivingMotion.IDLE, Animations.ENDERMAN_IDLE);
            this.getClientAnimator().addLivingAnimation(LivingMotion.WALKING, Animations.ENDERMAN_WALK);
        } else if (!((EndermanEntity)this.orgEntity).func_175446_cd()) {
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack1);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack2);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack3);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack4);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(0, this.normalAttack5);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_85156_a(this.rageChase);
            ((EndermanEntity)this.orgEntity).field_70715_bh.func_85156_a(this.rageTarget);
            if (((EndermanEntity)this.orgEntity).func_70638_az() == null) {
                ((EndermanEntity)this.orgEntity).func_184212_Q().func_187227_b(EndermanEntity.field_184719_bw, (Object)false);
            }
            ((EndermanEntity)this.orgEntity).func_195063_d(ModEffects.STUN_IMMUNITY);
        }
    }

    @Override
    public void setAIAsUnarmed() {
        if (this.isRaging()) {
            ((EndermanEntity)this.orgEntity).field_70715_bh.func_75776_a(3, this.rageTarget);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, this.rageChase);
        } else {
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack1);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack2);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack3);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack4);
            ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(0, this.normalAttack5);
        }
        ((EndermanEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new ChasingGoal(this, (MobEntity)this.orgEntity, 0.75, false));
    }

    @Override
    public void setAIAsArmed() {
        this.setAIAsUnarmed();
    }

    @Override
    public void setAIAsMounted(Entity ridingEntity) {
    }

    @Override
    public void aboutToDeath() {
        ((EndermanEntity)this.orgEntity).func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        if (this.isRemote()) {
            for (int i = 0; i < 100; ++i) {
                Random rand = ((EndermanEntity)this.orgEntity).func_70681_au();
                Vec3f vec = new Vec3f(rand.nextInt(), rand.nextInt(), rand.nextInt());
                vec.normalise();
                vec.scale(0.5f);
                Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)Particles.PORTAL_STRAIGHT.get(), ((EndermanEntity)this.orgEntity).func_226277_ct_(), ((EndermanEntity)this.orgEntity).func_226278_cu_() + (double)(((EndermanEntity)this.orgEntity).func_213305_a((Pose)Pose.STANDING).field_220316_b / 2.0f), ((EndermanEntity)this.orgEntity).func_226281_cx_(), (double)vec.x, (double)vec.y, (double)vec.z);
            }
        }
        super.aboutToDeath();
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (stunType == IExtendedDamageSource.StunType.LONG) {
            return Animations.ENDERMAN_HIT_LONG;
        }
        return Animations.ENDERMAN_HIT_SHORT;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_ENDERMAN;
    }

    static class AIEndermanRush
    extends AttackPatternGoal {
        private float accelator;

        public AIEndermanRush(BipedMobData<?> mobdata, MobEntity attacker) {
            super(mobdata, attacker, 0.0, 1.8f, false, null);
        }

        @Override
        public boolean func_75250_a() {
            return this.isValidTarget(this.attacker.func_70638_az()) && !this.mobdata.isInaction();
        }

        @Override
        public boolean func_75253_b() {
            return this.isValidTarget(this.attacker.func_70638_az()) && !this.mobdata.isInaction();
        }

        @Override
        public void func_75249_e() {
            ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTarget(403, this.attacker.func_145782_y(), -1.0f, true, this.attacker.func_70638_az().func_145782_y()), (Entity)this.attacker);
            this.accelator = 0.0f;
        }

        @Override
        public void func_75251_c() {
        }

        @Override
        public void func_75246_d() {
            if (this.isTargetInRange(this.attacker.func_70638_az()) && this.canExecuteAttack()) {
                this.mobdata.getServerAnimator().playAnimation(Animations.ENDERMAN_GRASP, 0.0f);
                ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTarget(Animations.ENDERMAN_GRASP.getId(), this.attacker.func_145782_y(), 0.0f, this.attacker.func_70638_az().func_145782_y()), (Entity)this.attacker);
            }
            this.attacker.func_70661_as().func_75489_a((double)(0.025f * this.accelator * this.accelator + 1.0f));
            this.accelator = this.accelator > 2.0f ? this.accelator : this.accelator + 0.05f;
        }
    }

    static class AIEndermanTeleportKick
    extends AttackPatternPercentGoal {
        private int delayCounter;
        private int cooldownTime;

        public AIEndermanTeleportKick(BipedMobData<?> mobdata, MobEntity attacker) {
            super(mobdata, attacker, 8.0, 100.0, 0.1f, false, null);
            super.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            boolean b;
            boolean bl = b = this.cooldownTime <= 0;
            if (!b) {
                --this.cooldownTime;
            }
            return super.func_75250_a() && b;
        }

        @Override
        public boolean func_75253_b() {
            boolean b;
            LivingEntity LivingEntity2 = this.attacker.func_70638_az();
            boolean bl = b = this.cooldownTime <= 100;
            if (!b) {
                this.cooldownTime = 500;
            }
            return this.isValidTarget(LivingEntity2) && this.isTargetInRange(LivingEntity2) && b;
        }

        @Override
        public void func_75249_e() {
            this.delayCounter = 35 + this.attacker.func_70681_au().nextInt(10);
            this.cooldownTime = 0;
        }

        @Override
        public void func_75251_c() {
        }

        @Override
        public void func_75246_d() {
            LivingEntity target = this.attacker.func_70638_az();
            this.attacker.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            if (this.delayCounter-- < 0 && !this.mobdata.isInaction()) {
                Vec3f vec = new Vec3f((float)(this.attacker.func_226277_ct_() - target.func_226277_ct_()), 0.0f, (float)(this.attacker.func_226281_cx_() - target.func_226281_cx_()));
                vec.normalise();
                vec.scale(1.414f);
                boolean flag = this.attacker.func_213373_a(target.func_226277_ct_() + (double)vec.x, target.func_226278_cu_(), target.func_226281_cx_() + (double)vec.z, true);
                if (flag) {
                    this.mobdata.rotateTo((Entity)target, 360.0f, true);
                    AttackAnimation kickAnimation = this.attacker.func_70681_au().nextBoolean() ? (AttackAnimation)Animations.ENDERMAN_TP_KICK1 : (AttackAnimation)Animations.ENDERMAN_TP_KICK2;
                    this.mobdata.getServerAnimator().playAnimation(kickAnimation, 0.0f);
                    ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTP(kickAnimation.getId(), this.attacker.func_145782_y(), 0.0f, this.attacker.func_70638_az().func_145782_y(), this.attacker.func_226277_ct_(), this.attacker.func_226278_cu_(), this.attacker.func_226281_cx_(), this.attacker.field_70177_z), (Entity)this.attacker);
                    this.attacker.field_70170_p.func_184148_a((PlayerEntity)null, this.attacker.field_70169_q, this.attacker.field_70167_r, this.attacker.field_70166_s, SoundEvents.field_187534_aX, this.attacker.func_184176_by(), 1.0f, 1.0f);
                    this.attacker.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                    this.cooldownTime = 0;
                } else {
                    ++this.cooldownTime;
                }
            }
        }
    }
}

