/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.DataKeys;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.entity.ai.brain.BrainRemodeler;
import maninhouse.epicfight.entity.ai.brain.task.AttackWithPatternTask;
import maninhouse.epicfight.entity.ai.brain.task.CrossBowAttackTask;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.client.CTSReqSpawnInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.ShootTargetTask;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;

public class PiglinData
extends BipedMobData<PiglinEntity> {
    public PiglinData() {
        super(Faction.PIGLIN_ARMY);
    }

    @Override
    public void onEntityConstructed(PiglinEntity entityIn) {
        super.onEntityConstructed(entityIn);
        ((PiglinEntity)this.orgEntity).func_184212_Q().func_187214_a(DataKeys.STUN_ARMOR, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void onEntityJoinWorld(PiglinEntity entityIn) {
        super.onEntityJoinWorld(entityIn);
        BrainRemodeler.replaceTask(((PiglinEntity)this.orgEntity).func_213375_cj(), Activity.field_234621_k_, 13, AttackTargetTask.class, new AttackWithPatternTask(this, MobAttackPatterns.BIPED_ARMED_ONEHAND, 0.0, 2.0));
        BrainRemodeler.replaceTask(((PiglinEntity)this.orgEntity).func_213375_cj(), Activity.field_234621_k_, 14, ShootTargetTask.class, new CrossBowAttackTask());
        BrainRemodeler.removeTask(((PiglinEntity)this.orgEntity).func_213375_cj(), Activity.field_234622_l_, 15, FirstShuffledTask.class);
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((PiglinEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.IMPACT.get()).func_111128_a(1.0);
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        StaticAnimation randomCelebrate = Animations.findAnimationDataById(Animations.PIGLIN_CELEBRATE1.getId() + ((PiglinEntity)this.orgEntity).func_70681_au().nextInt(3));
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.PIGLIN_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animatorClient.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animatorClient.addLivingAnimation(LivingMotion.CELEBRATE, randomCelebrate);
        animatorClient.addLivingAnimation(LivingMotion.ADMIRE, Animations.PIGLIN_ADMIRE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.PIGLIN_WALK);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.PIGLIN_DEATH);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void postInit() {
        super.postInit();
        if (this.isRemote()) {
            AnimatorClient animator = this.getClientAnimator();
            if (((PiglinEntity)this.orgEntity).func_70631_g_()) {
                animator.addLivingAnimation(LivingMotion.WALKING, Animations.BIPED_RUN);
            }
            ModNetworkManager.sendToServer(new CTSReqSpawnInfo(((PiglinEntity)this.orgEntity).func_145782_y()));
        }
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
        if (((PiglinEntity)this.getOriginalEntity()).func_184592_cb().func_77973_b().func_206844_a((ITag)ItemTags.field_232903_N_)) {
            this.currentMotion = LivingMotion.ADMIRE;
        } else if (((PiglinEntity)this.orgEntity).func_234425_eN_()) {
            this.currentMotion = LivingMotion.CELEBRATE;
        }
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_PIGLIN;
    }

    @Override
    public void setAIAsUnarmed() {
    }

    @Override
    public void setAIAsArmed() {
    }

    @Override
    public void setAIAsMounted(Entity ridingEntity) {
    }

    @Override
    public void setAIAsRange() {
    }
}

