/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.MobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.AttackPatternPercentGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;

public class RavagerData
extends MobData<RavagerEntity> {
    public RavagerData() {
        super(Faction.ILLAGER);
    }

    @Override
    public void onEntityJoinWorld(RavagerEntity entityIn) {
        super.onEntityJoinWorld(entityIn);
        ((RavagerEntity)this.orgEntity).field_70144_Y = 0.2f;
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((RavagerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.MAX_STRIKES.get()).func_111128_a(8.0);
        ((RavagerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.IMPACT.get()).func_111128_a(10.0);
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.RAVAGER_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.RAVAGER_WALK);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.RAVAGER_DEATH);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((RavagerEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new ChasingGoal(this, (MobEntity)this.orgEntity, 1.0, false));
        ((RavagerEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternPercentGoal(this, (MobEntity)this.orgEntity, 0.0, 2.25, 0.1f, true, MobAttackPatterns.RAVAGER_PATTERN2));
        ((RavagerEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new AttackPatternGoal(this, (MobEntity)this.orgEntity, 1.0, 2.4, true, MobAttackPatterns.RAVAGER_PATTERN1));
    }

    @Override
    public boolean hurtEntity(Entity hitTarget, Hand handIn, IExtendedDamageSource source, float amount) {
        boolean succed = hitTarget.func_70097_a((DamageSource)source, amount);
        if (!succed && ((RavagerEntity)this.orgEntity).field_213692_bA > 0) {
            this.playAnimationSynchronize(Animations.RAVAGER_STUN, 0.0f);
        }
        return succed;
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        return null;
    }

    @Override
    public SoundEvent getWeaponHitSound(Hand hand) {
        return Sounds.BLUNT_HIT_HARD;
    }

    @Override
    public SoundEvent getSwingSound(Hand hand) {
        return Sounds.WHOOSH_BIG;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_RAVAGER;
    }
}

