/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.MobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCPlayAnimationTarget;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.MathUtils;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;

public class VexData
extends MobData<VexEntity> {
    private float prevPitchToTarget;
    private float pitchToTarget;

    public VexData() {
        super(Faction.ILLAGER);
    }

    @Override
    protected void initAI() {
        super.initAI();
        Set goals = ((VexEntity)this.orgEntity).field_70714_bg.field_220892_d;
        Iterator iterator = goals.iterator();
        Goal toRemove = null;
        int iterCount = 0;
        while (iterator.hasNext()) {
            PrioritizedGoal goal = (PrioritizedGoal)iterator.next();
            Goal inner = goal.func_220772_j();
            if (iterCount == 1) {
                toRemove = inner;
                break;
            }
            ++iterCount;
        }
        if (toRemove != null) {
            ((VexEntity)this.orgEntity).field_70714_bg.func_85156_a(toRemove);
        }
        ((VexEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new ChargeAttackGoal());
        ((VexEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new StopStandGoal());
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        animatorClient.mixLayer.setJointMask("Chest", "Wing_L", "Wing_R");
        animatorClient.addLivingAnimation(LivingMotion.FLOATING, Animations.VEX_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.VEX_DEATH);
        animatorClient.addLivingMixAnimation(LivingMotion.IDLE, Animations.VEX_FLIPPING);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void update() {
        this.prevPitchToTarget = this.pitchToTarget;
        super.update();
    }

    @Override
    public void updateMotion() {
        if (((VexEntity)this.orgEntity).func_110143_aJ() <= 0.0f) {
            this.currentMotion = LivingMotion.DEATH;
        } else {
            this.currentMotion = LivingMotion.FLOATING;
            this.currentMixMotion = LivingMotion.IDLE;
        }
    }

    @Override
    public void playAnimationSynchronize(int id, float modifyTime) {
        this.animator.playAnimation(id, modifyTime);
        ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTarget(id, ((VexEntity)this.orgEntity).func_145782_y(), modifyTime, this.getAttackTarget().func_145782_y()), this.orgEntity);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_VEX;
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        return Animations.VEX_HIT;
    }

    @Override
    public VisibleMatrix4f getModelMatrix(float partialTicks) {
        VisibleMatrix4f mat = super.getModelMatrix(partialTicks);
        if (((VexEntity)this.orgEntity).func_190647_dj()) {
            if (this.pitchToTarget == 0.0f && this.getAttackTarget() != null) {
                LivingEntity target = this.getAttackTarget();
                double d0 = ((VexEntity)this.orgEntity).func_226277_ct_() - target.func_226277_ct_();
                double d1 = ((VexEntity)this.orgEntity).func_226278_cu_() - (target.func_226278_cu_() + (double)target.func_213302_cg() * 0.5);
                double d2 = ((VexEntity)this.orgEntity).func_226281_cx_() - target.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                this.pitchToTarget = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
            }
        } else {
            this.pitchToTarget = 0.0f;
        }
        VisibleMatrix4f.rotate((float)Math.toRadians(MathUtils.interpolateRotation(this.prevPitchToTarget, this.pitchToTarget, partialTicks)), new Vec3f(1.0f, 0.0f, 0.0f), mat, mat);
        return mat;
    }

    class ChargeAttackGoal
    extends Goal {
        private int chargingCounter;

        public ChargeAttackGoal() {
            this.func_220684_a(EnumSet.noneOf(Goal.Flag.class));
        }

        public boolean func_75250_a() {
            if (((VexEntity)VexData.this.orgEntity).func_70638_az() != null && !VexData.this.inaction && ((VexEntity)VexData.this.orgEntity).func_70681_au().nextInt(10) == 0) {
                double distance = ((VexEntity)VexData.this.orgEntity).func_70068_e((Entity)((VexEntity)VexData.this.orgEntity).func_70638_az());
                return distance < 50.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.chargingCounter > 0;
        }

        public void func_75249_e() {
            LivingEntity target = VexData.this.getAttackTarget();
            VexData.this.playAnimationSynchronize(Animations.VEX_CHARGING, 0.0f);
            ((VexEntity)VexData.this.orgEntity).func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
            ((VexEntity)VexData.this.orgEntity).func_190648_a(true);
            double d0 = ((VexEntity)VexData.this.orgEntity).func_226277_ct_() - target.func_226277_ct_();
            double d1 = ((VexEntity)VexData.this.orgEntity).func_226278_cu_() - (target.func_226278_cu_() + (double)target.func_213302_cg() * 0.5);
            double d2 = ((VexEntity)VexData.this.orgEntity).func_226281_cx_() - target.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            VexData.this.pitchToTarget = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
            this.chargingCounter = 20;
        }

        public void func_75251_c() {
            ((VexEntity)VexData.this.orgEntity).func_190648_a(false);
            VexData.this.pitchToTarget = 0.0f;
        }

        public void func_75246_d() {
            --this.chargingCounter;
        }
    }

    class StopStandGoal
    extends Goal {
        public StopStandGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return VexData.this.inaction;
        }

        public void func_75249_e() {
            ((VexEntity)VexData.this.orgEntity).func_213293_j(0.0, 0.0, 0.0);
            ((VexEntity)VexData.this.orgEntity).func_70661_as().func_75499_g();
        }
    }
}

