/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.DataKeys;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.capabilities.entity.mob.SkeletonData;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.Vec3f;
import maninhouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;

public class WitherSkeletonData
extends SkeletonData<WitherSkeletonEntity> {
    public WitherSkeletonData() {
        super(Faction.WITHER_ARMY);
    }

    @Override
    public void onEntityJoinWorld(WitherSkeletonEntity entityIn) {
        super.onEntityJoinWorld(entityIn);
        ((WitherSkeletonEntity)this.orgEntity).func_184212_Q().func_187227_b(DataKeys.STUN_ARMOR, (Object)Float.valueOf(4.0f));
    }

    @Override
    public void postInit() {
        super.resetCombatAI();
        super.postInit();
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((WitherSkeletonEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.MAX_STUN_ARMOR.get()).func_111128_a(4.0);
    }

    @Override
    protected void initAnimator(AnimatorClient animator) {
        animator.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animator.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animator.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
        animator.addLivingAnimation(LivingMotion.IDLE, Animations.WITHER_SKELETON_IDLE);
        animator.addLivingAnimation(LivingMotion.WALKING, Animations.WITHER_SKELETON_WALK);
        animator.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public boolean hurtEntity(Entity hitTarget, Hand handIn, IExtendedDamageSource source, float amount) {
        boolean succed = super.hurtEntity(hitTarget, handIn, source, amount);
        if (succed && hitTarget instanceof LivingEntity && ((WitherSkeletonEntity)this.orgEntity).func_70681_au().nextInt(10) == 0) {
            ((LivingEntity)hitTarget).func_195064_c(new EffectInstance(Effects.field_82731_v, 200));
        }
        return succed;
    }

    @Override
    public void setAIAsArmed() {
        ((WitherSkeletonEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternGoal(this, (MobEntity)this.orgEntity, 0.0, 1.8, true, MobAttackPatterns.WITHER_SKELETON_PATTERN));
        ((WitherSkeletonEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new ChasingGoal(this, (MobEntity)this.orgEntity, 1.2, true, Animations.WITHER_SKELETON_CHASE, Animations.WITHER_SKELETON_WALK));
    }

    @Override
    public VisibleMatrix4f getModelMatrix(float partialTicks) {
        VisibleMatrix4f mat = super.getModelMatrix(partialTicks);
        return VisibleMatrix4f.scale(new Vec3f(1.2f, 1.2f, 1.2f), mat, mat);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_SKELETON;
    }
}

