/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import java.util.Optional;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.MobData;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.entity.ai.brain.BrainRemodeler;
import maninhouse.epicfight.entity.ai.brain.task.AttackWithPatternTask;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;

public class ZoglinData
extends MobData<ZoglinEntity> {
    @Override
    public void onEntityJoinWorld(ZoglinEntity entityIn) {
        super.onEntityJoinWorld(entityIn);
        BrainRemodeler.replaceTask(((ZoglinEntity)this.orgEntity).func_213375_cj(), Activity.field_234621_k_, 11, SupplementedTask.class, new AttackWithPatternTask(this, MobAttackPatterns.HOGLIN_PATTERN, 0.0, 4.0));
        BrainRemodeler.removeTask(((ZoglinEntity)this.orgEntity).func_213375_cj(), Activity.field_234621_k_, 12, SupplementedTask.class);
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.HOGLIN_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.HOGLIN_WALK);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.HOGLIN_DEATH);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((ZoglinEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.MAX_STRIKES.get()).func_111128_a(4.0);
        ((ZoglinEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.IMPACT.get()).func_111128_a(5.0);
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_HOGLIN;
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        return null;
    }

    @Override
    public SoundEvent getWeaponHitSound(Hand hand) {
        return Sounds.BLUNT_HIT_HARD;
    }

    @Override
    public SoundEvent getSwingSound(Hand hand) {
        return Sounds.WHOOSH_BIG;
    }

    @Override
    public LivingEntity getAttackTarget() {
        Optional opt = ((ZoglinEntity)this.orgEntity).func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
        return opt.orElse(null);
    }
}

