/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import io.netty.buffer.ByteBuf;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.DataKeys;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.client.CTSReqSpawnInfo;
import maninhouse.epicfight.network.server.STCMobInitialSetting;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;

public class ZombieData<T extends ZombieEntity>
extends BipedMobData<T> {
    public ZombieData() {
        super(Faction.UNDEAD);
    }

    @Override
    public void onEntityConstructed(T entityIn) {
        super.onEntityConstructed(entityIn);
        ((ZombieEntity)this.orgEntity).func_184212_Q().func_187214_a(DataKeys.STUN_ARMOR, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void postInit() {
        super.postInit();
        if (!this.isRemote()) {
            if (!((ZombieEntity)this.orgEntity).func_98052_bS()) {
                ((ZombieEntity)this.orgEntity).func_98053_h(this.isArmed());
            }
            if (((ZombieEntity)this.orgEntity).func_70631_g_() && ((ZombieEntity)this.orgEntity).func_184187_bx() instanceof ChickenEntity && ((ZombieEntity)this.orgEntity).func_184614_ca().func_77973_b() == Items.field_190931_a) {
                ((ZombieEntity)this.orgEntity).func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151052_q));
            }
        } else {
            ModNetworkManager.sendToServer(new CTSReqSpawnInfo(((ZombieEntity)this.orgEntity).func_145782_y()));
        }
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((ZombieEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.IMPACT.get()).func_111128_a(1.0);
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.ZOMBIE_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.ZOMBIE_WALK);
        animatorClient.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animatorClient.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public STCMobInitialSetting sendInitialInformationToClient() {
        STCMobInitialSetting packet = new STCMobInitialSetting(((ZombieEntity)this.orgEntity).func_145782_y());
        PacketBuffer buf = packet.getBuffer();
        buf.writeBoolean(((ZombieEntity)this.orgEntity).func_98052_bS());
        return packet;
    }

    @Override
    public void clientInitialSettings(ByteBuf buf) {
        AnimatorClient animator = this.getClientAnimator();
        if (buf.readBoolean()) {
            animator.addLivingAnimation(LivingMotion.IDLE, Animations.BIPED_IDLE);
            animator.addLivingAnimation(LivingMotion.WALKING, Animations.BIPED_WALK);
        }
    }

    @Override
    public void setAIAsUnarmed() {
        ((ZombieEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new ChasingGoal(this, (MobEntity)this.orgEntity, 1.0, false, Animations.ZOMBIE_CHASE, Animations.ZOMBIE_WALK, !((ZombieEntity)this.orgEntity).func_70631_g_()));
        ((ZombieEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternGoal(this, (MobEntity)this.orgEntity, 0.0, 1.8, true, MobAttackPatterns.ZOMBIE_NORAML));
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_BIPED_64_32_TEX;
    }
}

