/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.mob;

import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.entity.DataKeys;
import maninhouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninhouse.epicfight.capabilities.entity.mob.Faction;
import maninhouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.AttackPatternGoal;
import maninhouse.epicfight.entity.ai.ChasingGoal;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCLivingMotionChange;
import maninhouse.epicfight.network.server.STCMobInitialSetting;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;

public class ZombifiedPiglinData
extends BipedMobData<ZombifiedPiglinEntity> {
    public ZombifiedPiglinData() {
        super(Faction.NATURAL);
    }

    @Override
    public void onEntityConstructed(ZombifiedPiglinEntity entityIn) {
        super.onEntityConstructed(entityIn);
        ((ZombifiedPiglinEntity)this.orgEntity).func_184212_Q().func_187214_a(DataKeys.STUN_ARMOR, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.PIGLIN_IDLE_ZOMBIE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.PIGLIN_WALK_ZOMBIE);
        animatorClient.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animatorClient.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.PIGLIN_DEATH);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public STCMobInitialSetting sendInitialInformationToClient() {
        STCMobInitialSetting packet = new STCMobInitialSetting(((ZombifiedPiglinEntity)this.orgEntity).func_145782_y());
        PacketBuffer buf = packet.getBuffer();
        buf.writeBoolean(((ZombifiedPiglinEntity)this.orgEntity).func_98052_bS());
        return packet;
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public void setAIAsArmed() {
        ((ZombifiedPiglinEntity)this.orgEntity).field_70714_bg.func_75776_a(1, (Goal)new EntityAIPigmanChase(this, (MobEntity)this.orgEntity));
        ((ZombifiedPiglinEntity)this.orgEntity).field_70714_bg.func_75776_a(0, (Goal)new AttackPatternGoal(this, (MobEntity)this.orgEntity, 0.0, 1.5, true, MobAttackPatterns.BIPED_ARMED_ONEHAND));
    }

    @Override
    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        return !(damageSource.func_76346_g() instanceof ZombifiedPiglinEntity);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_PIGLIN;
    }

    static class EntityAIPigmanChase
    extends ChasingGoal {
        boolean angry;

        public EntityAIPigmanChase(BipedMobData<?> entitydata, MobEntity creature) {
            super(entitydata, creature, 1.35, false, Animations.PIGLIN_CHASE_ZOMBIE, Animations.PIGLIN_WALK_ZOMBIE);
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            if (!((ZombifiedPiglinEntity)this.attacker).func_213398_dR()) {
                if (this.angry) {
                    STCLivingMotionChange msg = new STCLivingMotionChange(this.attacker.func_145782_y(), 1);
                    msg.setMotions(LivingMotion.WALKING);
                    msg.setAnimations(this.walkingAnimation);
                    ModNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)this.attacker);
                    this.angry = false;
                }
            } else if (!this.angry) {
                STCLivingMotionChange msg = new STCLivingMotionChange(this.attacker.func_145782_y(), 1);
                msg.setMotions(LivingMotion.WALKING);
                msg.setAnimations(this.chasingAnimation);
                ModNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)this.attacker);
                this.angry = true;
            }
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.angry = true;
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.angry = false;
        }
    }
}

