/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.player;

import java.util.UUID;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.DataKeys;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninhouse.epicfight.client.animation.AnimatorClient;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.entity.eventlistener.EntityEventListener;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Models;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.model.Model;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;

public abstract class PlayerData<T extends PlayerEntity>
extends LivingData<T> {
    private static final UUID ACTION_EVENT_UUID = UUID.fromString("e6beeac4-77d2-11eb-9439-0242ac130002");
    protected float yaw;
    protected EntityEventListener eventListeners;
    protected int tickSinceLastAction;
    protected boolean isBattleMode;
    public SkillContainer[] skills;

    public PlayerData() {
        SkillSlot[] slots = SkillSlot.values();
        this.skills = new SkillContainer[SkillSlot.values().length];
        for (SkillSlot slot : slots) {
            this.skills[slot.getIndex()] = new SkillContainer(this);
        }
    }

    @Override
    public void onEntityConstructed(T entityIn) {
        super.onEntityConstructed(entityIn);
        ((PlayerEntity)this.orgEntity).func_184212_Q().func_187214_a(DataKeys.STUN_ARMOR, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void onEntityJoinWorld(T entityIn) {
        super.onEntityJoinWorld(entityIn);
        this.skills[SkillSlot.DODGE.getIndex()].setSkill(Skills.ROLL);
        this.tickSinceLastAction = 40;
        this.eventListeners = new EntityEventListener(this);
        this.eventListeners.addEventListener(EntityEventListener.EventType.ACTION_EVENT, ACTION_EVENT_UUID, event -> {
            ((ServerPlayerData)event.getPlayerData()).tickSinceLastAction = 0;
            return false;
        });
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((PlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_IMPACT.get()).func_111128_a(0.5);
    }

    @Override
    public void initAnimator(AnimatorClient animatorClient) {
        animatorClient.mixLayer.setJointMask("Root", "Torso");
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.BIPED_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.BIPED_WALK);
        animatorClient.addLivingAnimation(LivingMotion.RUNNING, Animations.BIPED_RUN);
        animatorClient.addLivingAnimation(LivingMotion.SNEAKING, Animations.BIPED_SNEAK);
        animatorClient.addLivingAnimation(LivingMotion.SWIMMING, Animations.BIPED_SWIM);
        animatorClient.addLivingAnimation(LivingMotion.FLOATING, Animations.BIPED_FLOAT);
        animatorClient.addLivingAnimation(LivingMotion.KNEELING, Animations.BIPED_KNEEL);
        animatorClient.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animatorClient.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animatorClient.addLivingAnimation(LivingMotion.FLYING, Animations.BIPED_FLYING);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
        animatorClient.addLivingAnimation(LivingMotion.JUMPING, Animations.BIPED_JUMP);
        animatorClient.addLivingAnimation(LivingMotion.CLIMB, Animations.BIPED_CLIMBING);
        animatorClient.addLivingAnimation(LivingMotion.SLEEP, Animations.BIPED_SLEEPING);
        animatorClient.addLivingMixAnimation(LivingMotion.BLOCKING, Animations.BIPED_BLOCK);
        animatorClient.addLivingMixAnimation(LivingMotion.AIMING, Animations.BIPED_BOW_AIM);
        animatorClient.addLivingMixAnimation(LivingMotion.RELOADING, Animations.BIPED_CROSSBOW_RELOAD);
        animatorClient.addLivingMixAnimation(LivingMotion.SHOTING, Animations.BIPED_BOW_REBOUND);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    public void changeYaw(float amount) {
        this.yaw = amount;
    }

    public void setBattleMode(boolean isBattleMode) {
        this.isBattleMode = isBattleMode;
    }

    public boolean isBattleMode() {
        return this.isBattleMode;
    }

    @Override
    public void updateOnServer() {
        super.updateOnServer();
        ++this.tickSinceLastAction;
        float stunArmor = this.getStunArmor();
        float maxStunArmor = this.getMaxStunArmor();
        if (stunArmor < maxStunArmor && this.tickSinceLastAction > 60) {
            float stunArmorFactor = 1.0f + stunArmor / maxStunArmor;
            float healthFactor = ((PlayerEntity)this.orgEntity).func_110143_aJ() / ((PlayerEntity)this.orgEntity).func_110138_aP();
            this.setStunArmor(stunArmor + maxStunArmor * 0.01f * healthFactor * stunArmorFactor);
        }
        if (maxStunArmor < stunArmor) {
            this.setStunArmor(maxStunArmor);
        }
    }

    @Override
    public void update() {
        if (((PlayerEntity)this.orgEntity).func_184187_bx() == null) {
            for (SkillContainer container : this.skills) {
                if (container == null) continue;
                container.update();
            }
        }
        super.update();
    }

    public SkillContainer getSkill(SkillSlot slot) {
        return this.skills[slot.getIndex()];
    }

    public SkillContainer getSkill(int slotIndex) {
        return this.skills[slotIndex];
    }

    public float getAttackSpeed() {
        return (float)((PlayerEntity)this.orgEntity).func_233637_b_(Attributes.field_233825_h_);
    }

    public EntityEventListener getEventListener() {
        return this.eventListeners;
    }

    @Override
    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        if (super.attackEntityFrom(damageSource, amount)) {
            this.tickSinceLastAction = 0;
            return true;
        }
        return false;
    }

    @Override
    public IExtendedDamageSource getDamageSource(IExtendedDamageSource.StunType stunType, IExtendedDamageSource.DamageType damageType, int id, Hand hand) {
        return IExtendedDamageSource.causePlayerDamage((PlayerEntity)this.orgEntity, stunType, damageType, id, hand);
    }

    public void discard() {
        super.aboutToDeath();
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (((PlayerEntity)this.orgEntity).func_184187_bx() != null) {
            return Animations.BIPED_HIT_ON_MOUNT;
        }
        switch (stunType) {
            case LONG: {
                return Animations.BIPED_HIT_LONG;
            }
            case SHORT: {
                return Animations.BIPED_HIT_SHORT;
            }
            case HOLD: {
                return Animations.BIPED_HIT_SHORT;
            }
        }
        return null;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_BIPED;
    }
}

