/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.entity.player;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.entity.eventlistener.EntityEventListener;
import maninhouse.epicfight.entity.eventlistener.PlayerHitEvent;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.server.STCLivingMotionChange;
import maninhouse.epicfight.network.server.STCNotifyPlayerYawChanged;
import maninhouse.epicfight.network.server.STCPlayAnimation;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.utils.game.IExtendedDamageSource;
import maninhouse.epicfight.utils.math.Formulars;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;

public class ServerPlayerData
extends PlayerData<ServerPlayerEntity> {
    private LivingEntity attackTarget;
    private Map<LivingMotion, StaticAnimation> livingMotionMap = Maps.newHashMap();
    private Map<LivingMotion, StaticAnimation> defaultLivingAnimations = Maps.newHashMap();
    private List<LivingMotion> modifiedLivingMotions = Lists.newArrayList();
    public static final UUID WEIGHT_PENALTY_MODIFIIER = UUID.fromString("414fed9e-e5e3-11ea-adc1-0242ac120002");
    public static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");

    @Override
    public void gatherDamageDealt(IExtendedDamageSource source, float amount) {
        if (source.getSkillId() > Animations.BASIC_ATTACK_MIN && source.getSkillId() < Animations.BASIC_ATTACK_MAX) {
            float value;
            SkillContainer container = this.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK);
            CapabilityItem itemCap = this.getHeldItemCapability(Hand.MAIN_HAND);
            if (!container.isFull() && itemCap != null && container.hasSkill(itemCap.getSpecialAttack(this)) && (value = container.getRemainCooldown() + amount) > 0.0f) {
                this.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK).getContaining().setCooldownSynchronize(this, value);
            }
        }
    }

    @Override
    public void onEntityJoinWorld(ServerPlayerEntity entityIn) {
        super.onEntityJoinWorld(entityIn);
        this.livingMotionMap.put(LivingMotion.IDLE, Animations.BIPED_IDLE);
        this.livingMotionMap.put(LivingMotion.WALKING, Animations.BIPED_WALK);
        this.livingMotionMap.put(LivingMotion.RUNNING, Animations.BIPED_RUN);
        this.livingMotionMap.put(LivingMotion.SNEAKING, Animations.BIPED_SNEAK);
        this.livingMotionMap.put(LivingMotion.SWIMMING, Animations.BIPED_SWIM);
        this.livingMotionMap.put(LivingMotion.FLOATING, Animations.BIPED_FLOAT);
        this.livingMotionMap.put(LivingMotion.KNEELING, Animations.BIPED_KNEEL);
        this.livingMotionMap.put(LivingMotion.FALL, Animations.BIPED_FALL);
        this.livingMotionMap.put(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        this.livingMotionMap.put(LivingMotion.FLYING, Animations.BIPED_FLYING);
        this.livingMotionMap.put(LivingMotion.DEATH, Animations.BIPED_DEATH);
        this.livingMotionMap.put(LivingMotion.CLIMB, Animations.BIPED_CLIMBING);
        for (Map.Entry<LivingMotion, StaticAnimation> entry : this.livingMotionMap.entrySet()) {
            this.defaultLivingAnimations.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void updateMotion() {
    }

    public void onHeldItemChange(CapabilityItem toChange, ItemStack stack, Hand hand) {
        CapabilityItem mainHandCap;
        CapabilityItem capabilityItem = mainHandCap = hand == Hand.MAIN_HAND ? toChange : this.getHeldItemCapability(Hand.MAIN_HAND);
        if (mainHandCap != null) {
            mainHandCap.onHeld(this);
        } else {
            this.getSkill(SkillSlot.WEAPON_GIMMICK).setSkill(null);
        }
        if (hand == Hand.MAIN_HAND) {
            ((ServerPlayerEntity)this.orgEntity).func_110148_a(Attributes.field_233825_h_).func_188479_b(WEIGHT_PENALTY_MODIFIIER);
            float weaponSpeed = (float)((ServerPlayerEntity)this.orgEntity).func_110148_a(Attributes.field_233825_h_).func_111125_b();
            for (AttributeModifier attributeModifier : stack.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_)) {
                weaponSpeed = (float)((double)weaponSpeed + attributeModifier.func_111164_d());
            }
            ((ServerPlayerEntity)this.orgEntity).func_110148_a(Attributes.field_233825_h_).func_233767_b_(new AttributeModifier(WEIGHT_PENALTY_MODIFIIER, "weight penalty modifier", Formulars.getAttackSpeedPenalty(this.getWeight(), weaponSpeed, this), AttributeModifier.Operation.ADDITION));
        } else {
            ((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_ATTACK_SPEED.get()).func_188479_b(WEIGHT_PENALTY_MODIFIIER);
            float weaponSpeed = (float)((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_ATTACK_SPEED.get()).func_111125_b();
            for (AttributeModifier attributeModifier : stack.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_)) {
                weaponSpeed = (float)((double)weaponSpeed + attributeModifier.func_111164_d());
            }
            ((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_ATTACK_SPEED.get()).func_233767_b_(new AttributeModifier(WEIGHT_PENALTY_MODIFIIER, "weight penalty modifier", Formulars.getAttackSpeedPenalty(this.getWeight(), weaponSpeed, this), AttributeModifier.Operation.ADDITION));
            ((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_ATTACK_DAMAGE.get()).func_188479_b(ATTACK_DAMAGE_MODIFIER);
            for (AttributeModifier attributeModifier : stack.func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233823_f_)) {
                ((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_ATTACK_DAMAGE.get()).func_233767_b_(attributeModifier);
            }
            ((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_ARMOR_NEGATION.get()).func_188479_b(ModAttributes.ARMOR_NEGATION_MODIFIER);
            ((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_IMPACT.get()).func_188479_b(ModAttributes.IMPACT_MODIFIER);
            ((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_MAX_STRIKES.get()).func_188479_b(ModAttributes.MAX_STRIKE_MODIFIER);
            if (toChange != null) {
                for (AttributeModifier attributeModifier : toChange.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)ModAttributes.ARMOR_NEGATION.get())) {
                    ((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_ARMOR_NEGATION.get()).func_233767_b_(attributeModifier);
                }
                for (AttributeModifier attributeModifier : toChange.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)ModAttributes.IMPACT.get())) {
                    ((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_IMPACT.get()).func_233767_b_(attributeModifier);
                }
                for (AttributeModifier attributeModifier : toChange.getAttributeModifiers(EquipmentSlotType.MAINHAND, this).get((Object)ModAttributes.MAX_STRIKES.get())) {
                    ((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_MAX_STRIKES.get()).func_233767_b_(attributeModifier);
                }
            }
        }
        this.modifiLivingMotions(mainHandCap);
    }

    @Override
    public void onArmorSlotChanged(CapabilityItem fromCap, CapabilityItem toCap, EquipmentSlotType slotType) {
        ModifiableAttributeInstance mainhandAttackSpeed = ((ServerPlayerEntity)this.orgEntity).func_110148_a(Attributes.field_233825_h_);
        ModifiableAttributeInstance offhandAttackSpeed = ((ServerPlayerEntity)this.orgEntity).func_110148_a((Attribute)ModAttributes.OFFHAND_ATTACK_SPEED.get());
        mainhandAttackSpeed.func_188479_b(WEIGHT_PENALTY_MODIFIIER);
        float mainWeaponSpeed = (float)mainhandAttackSpeed.func_111125_b();
        for (AttributeModifier attributeModifier : this.getOriginalEntity().func_184614_ca().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_)) {
            mainWeaponSpeed += (float)attributeModifier.func_111164_d();
        }
        mainhandAttackSpeed.func_233767_b_(new AttributeModifier(WEIGHT_PENALTY_MODIFIIER, "weight penalty modifier", Formulars.getAttackSpeedPenalty(this.getWeight(), mainWeaponSpeed, this), AttributeModifier.Operation.ADDITION));
        offhandAttackSpeed.func_188479_b(WEIGHT_PENALTY_MODIFIIER);
        float offWeaponSpeed = (float)offhandAttackSpeed.func_111125_b();
        for (AttributeModifier attributeModifier : this.getOriginalEntity().func_184592_cb().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)Attributes.field_233825_h_)) {
            offWeaponSpeed += (float)attributeModifier.func_111164_d();
        }
        offhandAttackSpeed.func_233767_b_(new AttributeModifier(WEIGHT_PENALTY_MODIFIIER, "weight penalty modifier", Formulars.getAttackSpeedPenalty(this.getWeight(), offWeaponSpeed, this), AttributeModifier.Operation.ADDITION));
    }

    public void modifiLivingMotions(CapabilityItem mainhand) {
        Map<LivingMotion, StaticAnimation> motionChanger;
        this.resetModifiedLivingMotions();
        if (mainhand != null && (motionChanger = mainhand.getLivingMotionChanges(this)) != null) {
            ArrayList motions = Lists.newArrayList();
            ArrayList animations = Lists.newArrayList();
            for (Map.Entry<LivingMotion, StaticAnimation> entry : motionChanger.entrySet()) {
                this.addModifiedLivingMotion(entry.getKey(), entry.getValue());
                motions.add(entry.getKey());
                animations.add(entry.getValue());
            }
            LivingMotion[] motionarr = motions.toArray(new LivingMotion[0]);
            StaticAnimation[] animationarr = animations.toArray(new StaticAnimation[0]);
            STCLivingMotionChange msg = new STCLivingMotionChange(((ServerPlayerEntity)this.orgEntity).func_145782_y(), motionChanger.size());
            msg.setMotions(motionarr);
            msg.setAnimations(animationarr);
            ModNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, (ServerPlayerEntity)this.orgEntity);
            return;
        }
        STCLivingMotionChange msg = new STCLivingMotionChange(((ServerPlayerEntity)this.orgEntity).func_145782_y(), 0);
        ModNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, (ServerPlayerEntity)this.orgEntity);
    }

    private void addModifiedLivingMotion(LivingMotion motion, StaticAnimation animation) {
        if (animation != null) {
            if (!this.modifiedLivingMotions.contains((Object)motion)) {
                this.modifiedLivingMotions.add(motion);
            }
            this.livingMotionMap.put(motion, animation);
        }
    }

    private void resetModifiedLivingMotions() {
        for (LivingMotion livingMotion : this.modifiedLivingMotions) {
            if (this.defaultLivingAnimations.containsKey((Object)livingMotion)) {
                this.livingMotionMap.put(livingMotion, this.defaultLivingAnimations.get((Object)livingMotion));
                continue;
            }
            this.livingMotionMap.remove((Object)livingMotion);
        }
        this.modifiedLivingMotions.clear();
    }

    public void modifyLivingMotion(STCLivingMotionChange packet) {
        LivingMotion[] motions = packet.getMotions();
        StaticAnimation[] animations = packet.getAnimations();
        for (int i = 0; i < motions.length; ++i) {
            this.addModifiedLivingMotion(motions[i], animations[i]);
        }
        ModNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(packet, (ServerPlayerEntity)this.orgEntity);
    }

    public Set<Map.Entry<LivingMotion, StaticAnimation>> getLivingMotionEntrySet() {
        return this.livingMotionMap.entrySet();
    }

    @Override
    public void playAnimationSynchronize(int id, float modifyTime) {
        super.playAnimationSynchronize(id, modifyTime);
        ModNetworkManager.sendToPlayer(new STCPlayAnimation(id, ((ServerPlayerEntity)this.orgEntity).func_145782_y(), modifyTime), (ServerPlayerEntity)this.orgEntity);
    }

    @Override
    public void reserverAnimationSynchronize(StaticAnimation animation) {
        super.reserverAnimationSynchronize(animation);
        ModNetworkManager.sendToPlayer(new STCPlayAnimation(animation.getId(), ((ServerPlayerEntity)this.orgEntity).func_145782_y(), 0.0f), (ServerPlayerEntity)this.orgEntity);
    }

    @Override
    public void changeYaw(float amount) {
        super.changeYaw(amount);
        ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCNotifyPlayerYawChanged(((ServerPlayerEntity)this.orgEntity).func_145782_y(), this.yaw), this.orgEntity);
        ModNetworkManager.sendToPlayer(new STCNotifyPlayerYawChanged(((ServerPlayerEntity)this.orgEntity).func_145782_y(), this.yaw), (ServerPlayerEntity)this.orgEntity);
    }

    @Override
    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        if (this.getEventListener().activateEvents(EntityEventListener.EventType.HIT_EVENT, new PlayerHitEvent(this, damageSource))) {
            return false;
        }
        return super.attackEntityFrom(damageSource, amount);
    }

    @Override
    public ServerPlayerEntity getOriginalEntity() {
        return (ServerPlayerEntity)this.orgEntity;
    }

    public void setAttackTarget(LivingEntity entity) {
        this.attackTarget = entity;
    }

    @Override
    public LivingEntity getAttackTarget() {
        return this.attackTarget;
    }

    @Override
    public void aboutToDeath() {
    }
}

