/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.model.ClientModel;
import maninhouse.epicfight.client.model.ClientModels;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArmorCapability
extends CapabilityItem {
    protected static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    protected double weight;
    protected double stunArmor;
    private final EquipmentSlotType equipmentSlot;

    public ArmorCapability(Item item) {
        super(item, CapabilityItem.WeaponCategory.NONE_WEAON);
        ArmorItem armorItem = (ArmorItem)item;
        IArmorMaterial armorMaterial = armorItem.func_200880_d();
        this.equipmentSlot = armorItem.func_185083_B_();
        this.weight = (float)armorMaterial.func_200902_b(this.equipmentSlot) * 2.5f;
        this.stunArmor = (float)armorMaterial.func_200902_b(this.equipmentSlot) * 0.375f;
    }

    public ArmorCapability(Item item, double customWeight, double customStunArmor) {
        super(item, CapabilityItem.WeaponCategory.NONE_WEAON);
        ArmorItem armorItem = (ArmorItem)item;
        this.equipmentSlot = armorItem.func_185083_B_();
        this.weight = customWeight;
        this.stunArmor = customStunArmor;
    }

    @Override
    public void modifyItemTooltip(List<ITextComponent> itemTooltip, LivingData<?> entitydata) {
        itemTooltip.add(1, (ITextComponent)new StringTextComponent(TextFormatting.BLUE + " +" + (int)this.weight + " ").func_230529_a_((ITextComponent)new TranslationTextComponent(((Attribute)ModAttributes.WEIGHT.get()).func_233754_c_()).func_240699_a_(TextFormatting.BLUE)));
        if (this.stunArmor > 0.0) {
            itemTooltip.add(1, (ITextComponent)new StringTextComponent(TextFormatting.BLUE + " +" + ItemStack.field_111284_a.format(this.stunArmor) + " ").func_230529_a_((ITextComponent)new TranslationTextComponent(((Attribute)ModAttributes.MAX_STUN_ARMOR.get()).func_233754_c_()).func_240699_a_(TextFormatting.BLUE)));
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, LivingData<?> entitydata) {
        HashMultimap map = HashMultimap.create();
        if (entitydata != null && equipmentSlot == this.equipmentSlot) {
            map.put((Object)ModAttributes.WEIGHT.get(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", this.weight, AttributeModifier.Operation.ADDITION));
            map.put((Object)ModAttributes.MAX_STUN_ARMOR.get(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", this.stunArmor, AttributeModifier.Operation.ADDITION));
        }
        return map;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ClientModel getArmorModel(EquipmentSlotType slot) {
        return ArmorCapability.getBipedArmorModel(slot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ClientModel getBipedArmorModel(EquipmentSlotType slot) {
        ClientModels modelDB = ClientModels.LOGICAL_CLIENT;
        switch (slot) {
            case HEAD: {
                return modelDB.ITEM_HELMET;
            }
            case CHEST: {
                return modelDB.ITEM_CHESTPLATE;
            }
            case LEGS: {
                return modelDB.ITEM_LEGGINS;
            }
            case FEET: {
                return modelDB.ITEM_BOOTS;
            }
        }
        return null;
    }
}

