/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.capabilities.item.MaterialItemCapability;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.skill.Skill;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;

public class AxeCapability
extends MaterialItemCapability {
    protected static List<StaticAnimation> axeAttackMotions = new ArrayList<StaticAnimation>();

    public AxeCapability(Item item) {
        super(item, CapabilityItem.WeaponCategory.AXE);
    }

    @Override
    public List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        return axeAttackMotions;
    }

    @Override
    public Skill getSpecialAttack(PlayerData<?> playerdata) {
        return Skills.GUILLOTINE_AXE;
    }

    @Override
    protected void registerAttribute() {
        int i = this.itemTier.func_200925_d();
        if (i != 0) {
            this.addStyleAttibute(CapabilityItem.WieldStyle.ONE_HAND, (Pair<Supplier<Attribute>, AttributeModifier>)Pair.of(ModAttributes.ARMOR_NEGATION, (Object)ModAttributes.getArmorNegationModifier(10.0 * (double)i)));
        }
        this.addStyleAttibute(CapabilityItem.WieldStyle.ONE_HAND, (Pair<Supplier<Attribute>, AttributeModifier>)Pair.of(ModAttributes.IMPACT, (Object)ModAttributes.getImpactModifier(0.7 + 0.3 * (double)i)));
    }

    @Override
    public HitParticleType getHitParticle() {
        return (HitParticleType)Particles.HIT_BLADE.get();
    }

    @Override
    public SoundEvent getHitSound() {
        return Sounds.BLADE_HIT;
    }

    @Override
    public Collider getWeaponCollider() {
        return Colliders.tools;
    }

    static {
        axeAttackMotions = new ArrayList<StaticAnimation>();
        axeAttackMotions.add(Animations.AXE_AUTO1);
        axeAttackMotions.add(Animations.AXE_AUTO2);
        axeAttackMotions.add(Animations.AXE_DASH);
    }
}

