/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.main.EpicFightMod;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.skill.Skill;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class CapabilityItem {
    protected static List<StaticAnimation> commonAutoAttackMotion = new ArrayList<StaticAnimation>();
    protected final WeaponCategory weaponCategory;
    protected Map<WieldStyle, Map<Supplier<Attribute>, AttributeModifier>> attributeMap;

    public static List<StaticAnimation> getBasicAutoAttackMotion() {
        return commonAutoAttackMotion;
    }

    protected void loadClientThings() {
    }

    public CapabilityItem(WeaponCategory category) {
        if (EpicFightMod.isPhysicalClient()) {
            this.loadClientThings();
        }
        this.attributeMap = Maps.newHashMap();
        this.weaponCategory = category;
        this.registerAttribute();
    }

    public CapabilityItem(Item item, WeaponCategory category) {
        this.attributeMap = Maps.newHashMap();
        this.weaponCategory = category;
    }

    protected void registerAttribute() {
    }

    public void modifyItemTooltip(List<ITextComponent> itemTooltip, LivingData<?> entitydata) {
        if (this.isTwoHanded()) {
            itemTooltip.add(1, (ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.epicfight.twohanded").func_240699_a_(TextFormatting.DARK_GRAY)));
        } else if (this.isMainhandOnly()) {
            itemTooltip.add(1, (ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.name.epicfight.mainhand_only").func_240699_a_(TextFormatting.DARK_GRAY)));
        }
        Map<Supplier<Attribute>, AttributeModifier> attribute = this.getDamageAttributesInCondition(this.getStyle(entitydata));
        if (attribute != null) {
            for (Map.Entry<Supplier<Attribute>, AttributeModifier> attr : attribute.entrySet()) {
                double value;
                if (!entitydata.getOriginalEntity().func_233645_dx_().func_233790_b_(attr.getKey().get()) || (value = attr.getValue().func_111164_d() + entitydata.getOriginalEntity().func_110148_a(attr.getKey().get()).func_111125_b()) == 0.0) continue;
                itemTooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(attr.getKey().get().func_233754_c_(), new Object[]{ItemStack.field_111284_a.format(value)})));
            }
            if (!attribute.keySet().contains(ModAttributes.MAX_STRIKES)) {
                itemTooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(((Attribute)ModAttributes.MAX_STRIKES.get()).func_233754_c_(), new Object[]{ItemStack.field_111284_a.format(((Attribute)ModAttributes.MAX_STRIKES.get()).func_111110_b())})));
            }
        }
    }

    public List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        return CapabilityItem.getBasicAutoAttackMotion();
    }

    public List<StaticAnimation> getMountAttackMotion() {
        return null;
    }

    public Skill getSpecialAttack(PlayerData<?> playerdata) {
        return null;
    }

    public Skill getPassiveSkill() {
        return null;
    }

    public WeaponCategory getWeaponCategory() {
        return this.weaponCategory;
    }

    public void onHeld(PlayerData<?> playerdata) {
        SkillContainer skillContainer;
        Skill specialSkill = this.getSpecialAttack(playerdata);
        if (specialSkill != null && (skillContainer = playerdata.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK)).getContaining() != specialSkill) {
            skillContainer.setSkill(specialSkill);
        }
        Skill skill = this.getPassiveSkill();
        SkillContainer skillContainer2 = playerdata.getSkill(SkillSlot.WEAPON_GIMMICK);
        if (skill == null) {
            skillContainer2.setSkill(null);
        } else if (skillContainer2.getContaining() != skill) {
            skillContainer2.setSkill(skill);
        }
    }

    public SoundEvent getSmashingSound() {
        return Sounds.WHOOSH;
    }

    public SoundEvent getHitSound() {
        return Sounds.BLUNT_HIT;
    }

    public Collider getWeaponCollider() {
        return Colliders.fist;
    }

    public HitParticleType getHitParticle() {
        return (HitParticleType)Particles.HIT_BLUNT.get();
    }

    public void addStyleAttibute(WieldStyle style, Pair<Supplier<Attribute>, AttributeModifier> attributePair) {
        this.attributeMap.computeIfAbsent(style, key -> Maps.newHashMap());
        this.attributeMap.get((Object)style).put((Supplier<Attribute>)attributePair.getFirst(), (AttributeModifier)attributePair.getSecond());
    }

    public void addStyleAttributeSimple(WieldStyle style, double armorNegation, double impact, int maxStrikes) {
        this.addStyleAttibute(style, (Pair<Supplier<Attribute>, AttributeModifier>)Pair.of(ModAttributes.ARMOR_NEGATION, (Object)ModAttributes.getArmorNegationModifier(armorNegation)));
        this.addStyleAttibute(style, (Pair<Supplier<Attribute>, AttributeModifier>)Pair.of(ModAttributes.IMPACT, (Object)ModAttributes.getImpactModifier(impact)));
        this.addStyleAttibute(style, (Pair<Supplier<Attribute>, AttributeModifier>)Pair.of(ModAttributes.MAX_STRIKES, (Object)ModAttributes.getMaxStrikesModifier(maxStrikes)));
    }

    public final Map<Supplier<Attribute>, AttributeModifier> getDamageAttributesInCondition(WieldStyle style) {
        return this.attributeMap.get((Object)style);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, LivingData<?> entitydata) {
        Map<Supplier<Attribute>, AttributeModifier> modifierMap;
        HashMultimap map = HashMultimap.create();
        if (entitydata != null && (modifierMap = this.getDamageAttributesInCondition(this.getStyle(entitydata))) != null) {
            for (Map.Entry<Supplier<Attribute>, AttributeModifier> entry : modifierMap.entrySet()) {
                map.put((Object)entry.getKey().get(), (Object)entry.getValue());
            }
        }
        return map;
    }

    public Map<LivingMotion, StaticAnimation> getLivingMotionChanges(PlayerData<?> player) {
        return null;
    }

    public WieldStyle getStyle(LivingData<?> entitydata) {
        if (this.isTwoHanded()) {
            return WieldStyle.TWO_HAND;
        }
        if (this.isMainhandOnly()) {
            return entitydata.getOriginalEntity().func_184592_cb().func_190926_b() ? WieldStyle.TWO_HAND : WieldStyle.ONE_HAND;
        }
        return WieldStyle.ONE_HAND;
    }

    public final boolean canUsedInOffhand() {
        return this.getHandProperty() == HeldOption.GENERAL;
    }

    public final boolean isTwoHanded() {
        return this.getHandProperty() == HeldOption.TWO_HANDED;
    }

    public final boolean isMainhandOnly() {
        return this.getHandProperty() == HeldOption.MAINHAND_ONLY;
    }

    public boolean canUseOnMount() {
        return !this.isTwoHanded();
    }

    public HeldOption getHandProperty() {
        return HeldOption.GENERAL;
    }

    public void setCustomWeapon(double armorNegation1, double impact1, int maxStrikes1, double armorNegation2, double impact2, int maxStrikes2) {
        this.addStyleAttributeSimple(WieldStyle.ONE_HAND, armorNegation1, impact1, maxStrikes1);
        this.addStyleAttributeSimple(WieldStyle.TWO_HAND, armorNegation2, impact2, maxStrikes2);
    }

    public boolean isValidOffhandItem(ItemStack item) {
        return !this.isTwoHanded() && !item.func_190926_b();
    }

    static {
        commonAutoAttackMotion.add(Animations.FIST_AUTO_1);
        commonAutoAttackMotion.add(Animations.FIST_AUTO_2);
        commonAutoAttackMotion.add(Animations.FIST_AUTO_3);
        commonAutoAttackMotion.add(Animations.FIST_DASH);
    }

    public static enum WieldStyle {
        ONE_HAND,
        TWO_HAND,
        MOUNT,
        RANGED,
        SHEATH,
        LIECHTENHAUER;

    }

    public static enum HeldOption {
        TWO_HANDED,
        MAINHAND_ONLY,
        GENERAL;

    }

    public static enum WeaponCategory {
        NONE_WEAON,
        AXE,
        FIST,
        GREATSWORD,
        HOE,
        PICKAXE,
        SHOVEL,
        SWORD,
        KATANA,
        SPEAR,
        TACHI,
        LONGSWORD,
        DAGGER;

    }
}

