/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.skill.Skill;
import net.minecraft.util.SoundEvent;

public class ModWeaponCapability
extends CapabilityItem {
    protected final Function<LivingData<?>, CapabilityItem.WieldStyle> stylegetter;
    protected final Skill weaponGimmick;
    protected final SoundEvent smashingSound;
    protected final SoundEvent hitSound;
    protected final Collider weaponCollider;
    protected CapabilityItem.HeldOption handProperty;
    protected Map<CapabilityItem.WieldStyle, List<StaticAnimation>> autoAttackMotionMap = Maps.newHashMap();
    protected Map<CapabilityItem.WieldStyle, Skill> specialAttackMap = Maps.newHashMap();
    protected Map<CapabilityItem.WieldStyle, Map<LivingMotion, StaticAnimation>> livingMotionModifiers;

    public ModWeaponCapability(CapabilityItem.WeaponCategory category, Function<LivingData<?>, CapabilityItem.WieldStyle> stylegetter, Skill weaponGimmick, SoundEvent smash, SoundEvent hit, Collider weaponCollider, CapabilityItem.HeldOption handProperty) {
        super(category);
        this.stylegetter = stylegetter;
        this.weaponGimmick = weaponGimmick;
        this.smashingSound = smash;
        this.hitSound = hit;
        this.handProperty = handProperty;
        this.weaponCollider = weaponCollider;
    }

    public void addLivingMotionModifier(CapabilityItem.WieldStyle wieldStyle, LivingMotion livingMotion, StaticAnimation animation) {
        if (this.livingMotionModifiers == null) {
            this.livingMotionModifiers = new HashMap<CapabilityItem.WieldStyle, Map<LivingMotion, StaticAnimation>>();
        }
        if (!this.livingMotionModifiers.containsKey((Object)wieldStyle)) {
            this.livingMotionModifiers.put(wieldStyle, new HashMap());
        }
        this.livingMotionModifiers.get((Object)wieldStyle).put(livingMotion, animation);
    }

    public void addStyleCombo(CapabilityItem.WieldStyle style, StaticAnimation ... animation) {
        this.autoAttackMotionMap.put(style, Lists.newArrayList((Object[])animation));
    }

    public void addStyleSpecialAttack(CapabilityItem.WieldStyle style, Skill specialAttack) {
        this.specialAttackMap.put(style, specialAttack);
    }

    @Override
    public final List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        return this.autoAttackMotionMap.get((Object)this.getStyle(playerdata));
    }

    @Override
    public final Skill getSpecialAttack(PlayerData<?> playerdata) {
        return this.specialAttackMap.get((Object)this.getStyle(playerdata));
    }

    @Override
    public Skill getPassiveSkill() {
        return this.weaponGimmick;
    }

    @Override
    public final List<StaticAnimation> getMountAttackMotion() {
        return this.autoAttackMotionMap.get((Object)CapabilityItem.WieldStyle.MOUNT);
    }

    @Override
    public CapabilityItem.WieldStyle getStyle(LivingData<?> entitydata) {
        return this.stylegetter.apply(entitydata);
    }

    @Override
    public SoundEvent getSmashingSound() {
        return this.smashingSound;
    }

    @Override
    public SoundEvent getHitSound() {
        return this.hitSound;
    }

    @Override
    public HitParticleType getHitParticle() {
        return (HitParticleType)Particles.HIT_BLADE.get();
    }

    @Override
    public Collider getWeaponCollider() {
        return this.weaponCollider != null ? this.weaponCollider : super.getWeaponCollider();
    }

    @Override
    public CapabilityItem.HeldOption getHandProperty() {
        return this.handProperty;
    }

    @Override
    public Map<LivingMotion, StaticAnimation> getLivingMotionChanges(PlayerData<?> player) {
        return this.livingMotionModifiers == null ? null : this.livingMotionModifiers.get((Object)this.getStyle(player));
    }
}

