/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.ModCapabilities;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.capabilities.item.MaterialItemCapability;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Skills;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.physics.Collider;
import maninhouse.epicfight.skill.Skill;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SwordCapability
extends MaterialItemCapability {
    private static List<StaticAnimation> swordAttackMotion;
    private static List<StaticAnimation> dualSwordAttackMotion;

    public SwordCapability(Item item) {
        super(item, CapabilityItem.WeaponCategory.SWORD);
        if (swordAttackMotion == null) {
            swordAttackMotion = new ArrayList<StaticAnimation>();
            swordAttackMotion.add(Animations.SWORD_AUTO_1);
            swordAttackMotion.add(Animations.SWORD_AUTO_2);
            swordAttackMotion.add(Animations.SWORD_AUTO_3);
            swordAttackMotion.add(Animations.SWORD_DASH);
            dualSwordAttackMotion = new ArrayList<StaticAnimation>();
            dualSwordAttackMotion.add(Animations.SWORD_DUAL_AUTO_1);
            dualSwordAttackMotion.add(Animations.SWORD_DUAL_AUTO_2);
            dualSwordAttackMotion.add(Animations.SWORD_DUAL_AUTO_3);
            dualSwordAttackMotion.add(Animations.SWORD_DUAL_DASH);
        }
    }

    @Override
    protected void registerAttribute() {
        int i = this.itemTier.func_200925_d();
        this.addStyleAttibute(CapabilityItem.WieldStyle.ONE_HAND, (Pair<Supplier<Attribute>, AttributeModifier>)Pair.of(ModAttributes.MAX_STRIKES, (Object)ModAttributes.getMaxStrikesModifier(1)));
        this.addStyleAttibute(CapabilityItem.WieldStyle.ONE_HAND, (Pair<Supplier<Attribute>, AttributeModifier>)Pair.of(ModAttributes.IMPACT, (Object)ModAttributes.getImpactModifier(0.5 + 0.2 * (double)i)));
        this.addStyleAttibute(CapabilityItem.WieldStyle.TWO_HAND, (Pair<Supplier<Attribute>, AttributeModifier>)Pair.of(ModAttributes.MAX_STRIKES, (Object)ModAttributes.getMaxStrikesModifier(1)));
        this.addStyleAttibute(CapabilityItem.WieldStyle.TWO_HAND, (Pair<Supplier<Attribute>, AttributeModifier>)Pair.of(ModAttributes.IMPACT, (Object)ModAttributes.getImpactModifier(0.5 + 0.2 * (double)i)));
    }

    @Override
    public Skill getSpecialAttack(PlayerData<?> playerdata) {
        if (this.getStyle(playerdata) == CapabilityItem.WieldStyle.ONE_HAND) {
            return Skills.SWEEPING_EDGE;
        }
        return Skills.DANCING_EDGE;
    }

    @Override
    public List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        if (this.getStyle(playerdata) == CapabilityItem.WieldStyle.ONE_HAND) {
            return swordAttackMotion;
        }
        return dualSwordAttackMotion;
    }

    @Override
    public CapabilityItem.WieldStyle getStyle(LivingData<?> entitydata) {
        CapabilityItem item = entitydata.getHeldItemCapability(Hand.OFF_HAND);
        if (item != null && item.weaponCategory == CapabilityItem.WeaponCategory.SWORD) {
            return CapabilityItem.WieldStyle.TWO_HAND;
        }
        return CapabilityItem.WieldStyle.ONE_HAND;
    }

    @Override
    public SoundEvent getHitSound() {
        return this.itemTier == ItemTier.WOOD ? Sounds.BLUNT_HIT : Sounds.BLADE_HIT;
    }

    @Override
    public HitParticleType getHitParticle() {
        return this.itemTier == ItemTier.WOOD ? (HitParticleType)Particles.HIT_BLUNT.get() : (HitParticleType)Particles.HIT_BLADE.get();
    }

    @Override
    public Collider getWeaponCollider() {
        return Colliders.sword;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isValidOffhandItem(ItemStack item) {
        CapabilityItem cap = (CapabilityItem)item.getCapability(ModCapabilities.CAPABILITY_ITEM).orElse(null);
        return super.isValidOffhandItem(item) || cap != null && cap.weaponCategory == CapabilityItem.WeaponCategory.SWORD;
    }
}

