/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.capabilities.item;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import maninhouse.epicfight.animation.types.StaticAnimation;
import maninhouse.epicfight.capabilities.entity.LivingData;
import maninhouse.epicfight.capabilities.entity.player.PlayerData;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.capabilities.item.RangedWeaponCapability;
import maninhouse.epicfight.entity.ai.attribute.ModAttributes;
import maninhouse.epicfight.gamedata.Animations;
import maninhouse.epicfight.gamedata.Colliders;
import maninhouse.epicfight.gamedata.Sounds;
import maninhouse.epicfight.particle.HitParticleType;
import maninhouse.epicfight.particle.Particles;
import maninhouse.epicfight.physics.Collider;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;

public class TridentCapability
extends RangedWeaponCapability {
    private static List<StaticAnimation> attackMotion;
    private static List<StaticAnimation> mountAttackMotion;

    public TridentCapability(Item item) {
        super(item, null, Animations.BIPED_JAVELIN_AIM, Animations.BIPED_JAVELIN_REBOUND);
        if (attackMotion == null) {
            attackMotion = new ArrayList<StaticAnimation>();
            attackMotion.add(Animations.SPEAR_ONEHAND_AUTO);
            attackMotion.add(Animations.SPEAR_DASH);
        }
        if (mountAttackMotion == null) {
            mountAttackMotion = new ArrayList<StaticAnimation>();
            mountAttackMotion.add(Animations.SPEAR_MOUNT_ATTACK);
        }
    }

    @Override
    public CapabilityItem.WieldStyle getStyle(LivingData<?> entitydata) {
        return CapabilityItem.WieldStyle.ONE_HAND;
    }

    @Override
    protected void registerAttribute() {
        this.addStyleAttibute(CapabilityItem.WieldStyle.ONE_HAND, (Pair<Supplier<Attribute>, AttributeModifier>)Pair.of(ModAttributes.IMPACT, (Object)ModAttributes.getImpactModifier(2.25)));
    }

    @Override
    public SoundEvent getHitSound() {
        return Sounds.BLADE_HIT;
    }

    @Override
    public HitParticleType getHitParticle() {
        return (HitParticleType)Particles.HIT_BLADE.get();
    }

    @Override
    public Collider getWeaponCollider() {
        return Colliders.spear;
    }

    @Override
    public List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        return attackMotion;
    }

    @Override
    public List<StaticAnimation> getMountAttackMotion() {
        return mountAttackMotion;
    }

    @Override
    public final CapabilityItem.HeldOption getHandProperty() {
        return CapabilityItem.HeldOption.MAINHAND_ONLY;
    }
}

