/*
 * Decompiled with CFR 0.152.
 */
package maninhouse.epicfight.client.capabilites.entity;

import maninhouse.epicfight.animation.LivingMotion;
import maninhouse.epicfight.capabilities.item.CapabilityItem;
import maninhouse.epicfight.client.ClientEngine;
import maninhouse.epicfight.client.capabilites.entity.RemoteClientPlayerData;
import maninhouse.epicfight.main.EpicFightMod;
import maninhouse.epicfight.network.ModNetworkManager;
import maninhouse.epicfight.network.client.CTSPlayAnimation;
import maninhouse.epicfight.network.client.CTSSetPlayerTarget;
import maninhouse.epicfight.network.client.CTSToggleMode;
import maninhouse.epicfight.skill.SkillContainer;
import maninhouse.epicfight.skill.SkillSlot;
import maninhouse.epicfight.utils.math.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientPlayerData
extends RemoteClientPlayerData<ClientPlayerEntity> {
    private LivingEntity rayTarget;

    @Override
    public void onEntityConstructed(ClientPlayerEntity entity) {
        super.onEntityConstructed(entity);
        ClientEngine.INSTANCE.setPlayerData(this);
        ClientEngine.INSTANCE.inputController.setGamePlayer(this);
    }

    @Override
    public void onEntityJoinWorld(ClientPlayerEntity entity) {
        super.onEntityJoinWorld(entity);
        ModNetworkManager.sendToServer(new CTSToggleMode(ClientEngine.INSTANCE.isBattleMode()));
    }

    @Override
    public void updateMotion() {
        super.updateMotion();
        if (!this.getClientAnimator().prevAiming() && this.currentMixMotion == LivingMotion.AIMING) {
            ((ClientPlayerEntity)this.orgEntity).func_184605_cv();
            ClientEngine.INSTANCE.renderEngine.zoomIn();
        }
    }

    @Override
    public void updateOnClient() {
        Entity hit;
        super.updateOnClient();
        RayTraceResult rayResult = Minecraft.func_71410_x().field_71476_x;
        if (rayResult.func_216346_c() == RayTraceResult.Type.ENTITY && (hit = ((EntityRayTraceResult)rayResult).func_216348_a()) instanceof LivingEntity) {
            this.rayTarget = (LivingEntity)hit;
            ModNetworkManager.sendToServer(new CTSSetPlayerTarget(this.getAttackTarget().func_145782_y()));
        }
        if (this.rayTarget != null) {
            if (!this.rayTarget.func_70089_S()) {
                this.rayTarget = null;
                ModNetworkManager.sendToServer(new CTSSetPlayerTarget(-1));
            } else if (((ClientPlayerEntity)this.getOriginalEntity()).func_70068_e((Entity)this.rayTarget) > 64.0) {
                this.rayTarget = null;
                ModNetworkManager.sendToServer(new CTSSetPlayerTarget(-1));
            } else if (MathUtils.getAngleBetween(this.getOriginalEntity(), (Entity)this.rayTarget) > 1.5707963267948966) {
                this.rayTarget = null;
                ModNetworkManager.sendToServer(new CTSSetPlayerTarget(-1));
            }
        }
    }

    @Override
    protected void playReboundAnimation() {
        this.getClientAnimator().playReboundAnimation();
        ClientEngine.INSTANCE.renderEngine.zoomOut(40);
    }

    @Override
    public void playAnimationSynchronize(int id, float modifyTime) {
        ModNetworkManager.sendToServer(new CTSPlayAnimation(id, modifyTime, false, true));
    }

    @Override
    public void onHeldItemChange(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        super.onHeldItemChange(mainHandCap, offHandCap);
        if (mainHandCap != null) {
            mainHandCap.onHeld(this);
        } else {
            this.getSkill(SkillSlot.WEAPON_GIMMICK).setSkill(null);
        }
    }

    @Override
    public void aboutToDeath() {
    }

    public void initFromOldOne(ClientPlayerData old) {
        for (SkillContainer skill : this.skills = old.skills) {
            skill.setExecuter(this);
            if (skill.getContaining() == null) continue;
            skill.getContaining().onInitiate(skill);
        }
        this.setStunArmor(old.getStunArmor());
    }

    @Override
    public LivingEntity getAttackTarget() {
        return this.rayTarget;
    }

    @Override
    public boolean shouldSkipRender() {
        return !ClientEngine.INSTANCE.isBattleMode() && EpicFightMod.CLIENT_INGAME_CONFIG.filterAnimation.getValue() != false;
    }

    @Override
    public boolean isFirstPerson() {
        return Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON;
    }
}

